/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.kryonet;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import info.novatec.inspectit.kryonet.Connection;
import info.novatec.inspectit.kryonet.IExtendedSerialization;
import info.novatec.inspectit.storage.serializer.IKryoProvider;
import info.novatec.inspectit.storage.serializer.ISerializerProvider;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedSerializationImpl
implements IExtendedSerialization {
    private static final int INIT_CREATED_SERIALIZERS = 2;
    private Queue<IKryoProvider> serializerQueue = new ConcurrentLinkedQueue<IKryoProvider>();
    private ISerializerProvider<? extends IKryoProvider> serializerProvider;

    public ExtendedSerializationImpl(ISerializerProvider<? extends IKryoProvider> serializerProvider) {
        this(serializerProvider, 2);
    }

    public ExtendedSerializationImpl(ISerializerProvider<? extends IKryoProvider> serializerProvider, int initialSerializersCreated) {
        this.serializerProvider = serializerProvider;
        for (int i = 0; i < initialSerializersCreated; ++i) {
            this.serializerQueue.offer(this.createKryoProvider());
        }
    }

    @Override
    public void write(Connection connection, ByteBuffer buffer, Object object) {
    }

    @Override
    public Object read(Connection connection, ByteBuffer buffer) {
        return null;
    }

    @Override
    public void writeLength(ByteBuffer buffer, int length) {
        buffer.putInt(length);
    }

    @Override
    public int readLength(ByteBuffer buffer) {
        return buffer.getInt();
    }

    @Override
    public int getLengthLength() {
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Connection connection, OutputStream outputStream, Object object) {
        Output output = new Output(outputStream);
        IKryoProvider kryoProvider = this.serializerQueue.poll();
        if (null == kryoProvider) {
            kryoProvider = this.createKryoProvider();
        }
        try {
            Kryo kryo = kryoProvider.getKryo();
            kryo.getContext().put((Object)"connection", (Object)connection);
            kryo.writeClassAndObject(output, object);
            output.flush();
        }
        finally {
            this.serializerQueue.offer(kryoProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object read(Connection connection, InputStream inputStream) {
        Input input = new Input(inputStream);
        IKryoProvider kryoProvider = this.serializerQueue.poll();
        if (null == kryoProvider) {
            kryoProvider = this.createKryoProvider();
        }
        try {
            Kryo kryo = kryoProvider.getKryo();
            kryo.getContext().put((Object)"connection", (Object)connection);
            Object object = kryo.readClassAndObject(input);
            return object;
        }
        finally {
            this.serializerQueue.offer(kryoProvider);
        }
    }

    protected IKryoProvider createKryoProvider() {
        return this.serializerProvider.createSerializer();
    }
}

