/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.exception;

public class RemoteException
extends RuntimeException {
    private static final long serialVersionUID = 6269583794164214516L;
    private final String originalExceptionClass;
    private String serviceMethodSignature;

    protected RemoteException() {
        this.originalExceptionClass = null;
    }

    public RemoteException(Throwable originalException) {
        super(RemoteException.assertNotNull(originalException).getMessage());
        this.originalExceptionClass = originalException.getClass().getCanonicalName();
        super.setStackTrace(originalException.getStackTrace());
    }

    private static Throwable assertNotNull(Throwable originalException) {
        if (originalException == null) {
            throw new IllegalArgumentException("Original Exception for RemoteException must not be null.");
        }
        return originalException;
    }

    public String getOriginalExceptionClass() {
        return this.originalExceptionClass;
    }

    public String getServiceMethodSignature() {
        return this.serviceMethodSignature;
    }

    public void setServiceMethodSignature(String serviceMethodSignature) {
        this.serviceMethodSignature = serviceMethodSignature;
        Throwable cause = this.getCause();
        if (cause instanceof RemoteException) {
            ((RemoteException)cause).setServiceMethodSignature(serviceMethodSignature);
        }
    }
}

