/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.exception;

import info.novatec.inspectit.exception.IErrorCode;

public class BusinessException
extends Exception {
    private static final long serialVersionUID = -3961488831742178282L;
    private final String actionPerformed;
    private final IErrorCode errorCode;
    private String serviceMethodSignature;

    protected BusinessException() {
        this((IErrorCode)null);
    }

    public BusinessException(IErrorCode errorCode) {
        this(null, errorCode);
    }

    public BusinessException(String actionPerformed, IErrorCode errorCode) {
        super(BusinessException.generateMessage(actionPerformed, errorCode));
        this.actionPerformed = actionPerformed;
        this.errorCode = errorCode;
    }

    private static String generateMessage(String actionPerformed, IErrorCode errorCode) {
        if (null == errorCode) {
            return null;
        }
        String s = "The '" + errorCode.getName() + "' exception occurred on the '" + errorCode.getComponent() + "' component.";
        if (null != actionPerformed) {
            s = s + " Exception occurred executing the action: '" + actionPerformed + "'.";
        }
        return s;
    }

    public String getActionPerformed() {
        return this.actionPerformed;
    }

    public IErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getServiceMethodSignature() {
        return this.serviceMethodSignature;
    }

    public void setServiceMethodSignature(String serviceMethodSignature) {
        this.serviceMethodSignature = serviceMethodSignature;
    }
}

