/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.data.cmr;

import java.io.Serializable;

public class AgentStatusData
implements Serializable {
    private static final long serialVersionUID = -822865263748943014L;
    private AgentConnection agentConnection;
    private long lastDataSendTimestamp;
    private long lastKeepAliveTimestamp;
    private long connectionTimestamp;
    private long serverTimestamp;

    public AgentStatusData() {
        this.agentConnection = AgentConnection.NEVER_CONNECTED;
    }

    public AgentStatusData(AgentConnection agentConnection) {
        this.agentConnection = agentConnection;
    }

    public Long getMillisSinceLastData() {
        if (0L < this.lastDataSendTimestamp && this.lastDataSendTimestamp <= this.serverTimestamp) {
            return this.serverTimestamp - this.lastDataSendTimestamp;
        }
        return null;
    }

    public AgentConnection getAgentConnection() {
        return this.agentConnection;
    }

    public void setAgentConnection(AgentConnection agentConnection) {
        this.agentConnection = agentConnection;
    }

    public void setLastDataSendTimestamp(long lastDataSendTimestamp) {
        this.lastDataSendTimestamp = lastDataSendTimestamp;
    }

    public void setServerTimestamp(long serverTimestamp) {
        this.serverTimestamp = serverTimestamp;
    }

    public long getLastKeepAliveTimestamp() {
        return this.lastKeepAliveTimestamp;
    }

    public void setLastKeepAliveTimestamp(long lastKeepAliveTimestamp) {
        this.lastKeepAliveTimestamp = lastKeepAliveTimestamp;
    }

    public long getConnectionTimestamp() {
        return this.connectionTimestamp;
    }

    public void setConnectionTimestamp(long connectionTimestamp) {
        this.connectionTimestamp = connectionTimestamp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.agentConnection == null ? 0 : this.agentConnection.hashCode());
        result = 31 * result + (int)(this.lastDataSendTimestamp ^ this.lastDataSendTimestamp >>> 32);
        result = 31 * result + (int)(this.serverTimestamp ^ this.serverTimestamp >>> 32);
        result = 31 * result + (int)(this.lastKeepAliveTimestamp ^ this.lastKeepAliveTimestamp >>> 32);
        result = 31 * result + (int)(this.connectionTimestamp ^ this.connectionTimestamp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AgentStatusData other = (AgentStatusData)obj;
        if (this.agentConnection != other.agentConnection) {
            return false;
        }
        if (this.lastDataSendTimestamp != other.lastDataSendTimestamp) {
            return false;
        }
        if (this.serverTimestamp != other.serverTimestamp) {
            return false;
        }
        if (this.lastKeepAliveTimestamp != other.lastKeepAliveTimestamp) {
            return false;
        }
        return this.connectionTimestamp == other.connectionTimestamp;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AgentConnection {
        NEVER_CONNECTED,
        CONNECTED,
        NO_KEEP_ALIVE,
        DISCONNECTED;

    }
}

