/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.data;

import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.InvocationAwareData;
import info.novatec.inspectit.communication.data.ParameterContentData;
import java.sql.Timestamp;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(indexes={@Index(name="time_stamp_idx", columnList="timeStamp")})
public class TimerData
extends InvocationAwareData {
    private static final long serialVersionUID = 8992128958802371539L;
    private double min = -1.0;
    private double max = -1.0;
    private long count = 0L;
    private double duration = 0.0;
    private double variance;
    private double cpuMin = -1.0;
    private double cpuMax = -1.0;
    private double cpuDuration = 0.0;
    private long exclusiveCount = 0L;
    private double exclusiveDuration;
    private double exclusiveMax = -1.0;
    private double exclusiveMin = -1.0;
    private boolean charting;

    public TimerData() {
    }

    public TimerData(Timestamp timeStamp, long platformIdent, long sensorTypeIdent, long methodIdent) {
        super(timeStamp, platformIdent, sensorTypeIdent, methodIdent);
    }

    public TimerData(Timestamp timeStamp, long platformIdent, long sensorTypeIdent, long methodIdent, List<ParameterContentData> parameterContentData) {
        super(timeStamp, platformIdent, sensorTypeIdent, methodIdent, parameterContentData);
    }

    public double getMin() {
        return this.min;
    }

    public void calculateMin(double min) {
        this.min = this.min == -1.0 ? min : Math.min(this.min, min);
    }

    public double getMax() {
        return this.max;
    }

    public void calculateMax(double max) {
        this.max = Math.max(this.max, max);
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public void increaseCount() {
        ++this.count;
    }

    public double getDuration() {
        return this.duration;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public void addDuration(double duration) {
        this.duration += duration;
    }

    public double getAverage() {
        return this.duration / (double)this.count;
    }

    public double getVariance() {
        return this.variance;
    }

    public void setVariance(double variance) {
        this.variance = variance;
    }

    public boolean providesCapturedParameters() {
        return null != this.getParameterContentData() && !this.getParameterContentData().isEmpty();
    }

    public void calculateCpuMin(double min) {
        this.cpuMin = this.cpuMin == -1.0 ? min : Math.min(this.cpuMin, min);
    }

    public void calculateCpuMax(double time) {
        this.cpuMax = Math.max(this.cpuMax, time);
    }

    public double getCpuMin() {
        return this.cpuMin;
    }

    public double getCpuMax() {
        return this.cpuMax;
    }

    public double getCpuDuration() {
        return this.cpuDuration;
    }

    public void setCpuDuration(double cpuDuration) {
        this.cpuDuration = cpuDuration;
    }

    public void addCpuDuration(double cpuDuration) {
        this.cpuDuration += cpuDuration;
    }

    public double getCpuAverage() {
        return this.cpuDuration / (double)this.count;
    }

    public long getExclusiveCount() {
        return this.exclusiveCount;
    }

    public void setExclusiveCount(long exclusiveCount) {
        this.exclusiveCount = exclusiveCount;
    }

    public void increaseExclusiveCount() {
        ++this.exclusiveCount;
    }

    public double getExclusiveDuration() {
        return this.exclusiveDuration;
    }

    public void setExclusiveDuration(double exclusiveDuration) {
        this.exclusiveDuration = exclusiveDuration;
    }

    public void addExclusiveDuration(double exclusiveDuration) {
        this.exclusiveDuration += exclusiveDuration;
    }

    public double getExclusiveMax() {
        return this.exclusiveMax;
    }

    public void calculateExclusiveMax(double max) {
        this.exclusiveMax = Math.max(this.exclusiveMax, max);
    }

    public double getExclusiveMin() {
        return this.exclusiveMin;
    }

    public void calculateExclusiveMin(double min) {
        this.exclusiveMin = this.exclusiveMin == -1.0 ? min : Math.min(this.exclusiveMin, min);
    }

    public double getExclusiveAverage() {
        return this.exclusiveDuration / (double)this.exclusiveCount;
    }

    private void setMin(double min) {
        this.min = min;
    }

    private void setMax(double max) {
        this.max = max;
    }

    private void setCpuMin(double cpuMin) {
        this.cpuMin = cpuMin;
    }

    private void setCpuMax(double cpuMax) {
        this.cpuMax = cpuMax;
    }

    private void setExclusiveMax(double exclusiveMax) {
        this.exclusiveMax = exclusiveMax;
    }

    private void setExclusiveMin(double exclusiveMin) {
        this.exclusiveMin = exclusiveMin;
    }

    public boolean isCharting() {
        return this.charting;
    }

    public void setCharting(boolean charting) {
        this.charting = charting;
    }

    @Override
    public DefaultData finalizeData() {
        return this;
    }

    @Override
    public long getObjectSize(IObjectSizes objectSizes, boolean doAlign) {
        long size = super.getObjectSize(objectSizes, doAlign);
        size += objectSizes.getPrimitiveTypesSize(0, 1, 0, 0, 2, 10);
        if (doAlign) {
            return objectSizes.alignTo8Bytes(size);
        }
        return size;
    }

    @Override
    public double getInvocationAffiliationPercentage() {
        return (double)this.getObjectsInInvocationsCount() / (double)this.count;
    }

    public boolean isCpuMetricDataAvailable() {
        return this.cpuMin != -1.0;
    }

    public boolean isExclusiveTimeDataAvailable() {
        return this.exclusiveMin != -1.0;
    }

    public boolean isTimeDataAvailable() {
        return this.min != -1.0;
    }

    public void aggregateTimerData(TimerData timerData) {
        super.aggregateInvocationAwareData(timerData);
        this.setCount(this.getCount() + timerData.getCount());
        this.setDuration(this.getDuration() + timerData.getDuration());
        this.calculateMax(timerData.getMax());
        this.calculateMin(timerData.getMin());
        if (timerData.isCpuMetricDataAvailable()) {
            this.setCpuDuration(this.getCpuDuration() + timerData.getCpuDuration());
            this.calculateCpuMax(timerData.getCpuMax());
            this.calculateCpuMin(timerData.getCpuMin());
        }
        if (timerData.isExclusiveTimeDataAvailable()) {
            this.addExclusiveDuration(timerData.getExclusiveDuration());
            this.setExclusiveCount(this.getExclusiveCount() + timerData.getExclusiveCount());
            this.calculateExclusiveMax(timerData.getExclusiveMax());
            this.calculateExclusiveMin(timerData.getExclusiveMin());
        }
        this.charting |= timerData.isCharting();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.count ^ this.count >>> 32);
        long temp = Double.doubleToLongBits(this.cpuDuration);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.cpuMax);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.cpuMin);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.duration);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (int)(this.exclusiveCount ^ this.exclusiveCount >>> 32);
        temp = Double.doubleToLongBits(this.exclusiveDuration);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.exclusiveMax);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.exclusiveMin);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.max);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.min);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.variance);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.charting ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimerData other = (TimerData)obj;
        if (this.count != other.count) {
            return false;
        }
        if (Double.doubleToLongBits(this.cpuDuration) != Double.doubleToLongBits(other.cpuDuration)) {
            return false;
        }
        if (Double.doubleToLongBits(this.cpuMax) != Double.doubleToLongBits(other.cpuMax)) {
            return false;
        }
        if (Double.doubleToLongBits(this.cpuMin) != Double.doubleToLongBits(other.cpuMin)) {
            return false;
        }
        if (Double.doubleToLongBits(this.duration) != Double.doubleToLongBits(other.duration)) {
            return false;
        }
        if (this.exclusiveCount != other.exclusiveCount) {
            return false;
        }
        if (Double.doubleToLongBits(this.exclusiveDuration) != Double.doubleToLongBits(other.exclusiveDuration)) {
            return false;
        }
        if (Double.doubleToLongBits(this.exclusiveMax) != Double.doubleToLongBits(other.exclusiveMax)) {
            return false;
        }
        if (Double.doubleToLongBits(this.exclusiveMin) != Double.doubleToLongBits(other.exclusiveMin)) {
            return false;
        }
        if (Double.doubleToLongBits(this.max) != Double.doubleToLongBits(other.max)) {
            return false;
        }
        if (Double.doubleToLongBits(this.min) != Double.doubleToLongBits(other.min)) {
            return false;
        }
        if (Double.doubleToLongBits(this.variance) != Double.doubleToLongBits(other.variance)) {
            return false;
        }
        return this.charting == other.charting;
    }
}

