/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.data;

import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.communication.data.HttpInfo;
import info.novatec.inspectit.communication.data.TimerData;
import java.sql.Timestamp;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class HttpTimerData
extends TimerData {
    private static final long serialVersionUID = -7868876342858232388L;
    public static final String INSPECTIT_TAGGING_HEADER = "inspectit";
    public static final String REQUEST_METHOD_MULTIPLE = "MULTIPLE";
    @Transient
    private Map<String, String[]> parameters = null;
    @Transient
    private Map<String, String> attributes = null;
    @Transient
    private Map<String, String> headers = null;
    @Transient
    private Map<String, String> sessionAttributes = null;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST})
    private HttpInfo httpInfo = new HttpInfo();

    public HttpTimerData() {
    }

    public HttpTimerData(Timestamp timeStamp, long platformIdent, long sensorTypeIdent, long methodIdent) {
        super(timeStamp, platformIdent, sensorTypeIdent, methodIdent);
    }

    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String[]> parameters) {
        this.parameters = parameters;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
        if (null != headers) {
            this.httpInfo.setInspectItTaggingHeaderValue(headers.get(INSPECTIT_TAGGING_HEADER));
        } else {
            this.httpInfo.setInspectItTaggingHeaderValue("n.a.");
        }
    }

    public Map<String, String> getSessionAttributes() {
        return this.sessionAttributes;
    }

    public void setSessionAttributes(Map<String, String> sessionAttributes) {
        this.sessionAttributes = sessionAttributes;
    }

    public HttpInfo getHttpInfo() {
        return this.httpInfo;
    }

    public void setHttpInfo(HttpInfo httpInfo) {
        this.httpInfo = httpInfo;
    }

    @Override
    public long getObjectSize(IObjectSizes objectSizes, boolean doAlign) {
        long size = super.getObjectSize(objectSizes, doAlign);
        size += objectSizes.getPrimitiveTypesSize(5, 0, 0, 0, 0, 0);
        if (null != this.parameters) {
            size += objectSizes.getSizeOfHashMap(this.parameters.size());
            for (Map.Entry<String, String[]> entry : this.parameters.entrySet()) {
                size += objectSizes.getSizeOf(entry.getKey());
                String[] values = entry.getValue();
                size += objectSizes.getSizeOfArray(values.length);
                for (int i = 0; i < values.length; ++i) {
                    size += objectSizes.getSizeOf(values[i]);
                }
            }
        }
        if (null != this.attributes) {
            size += objectSizes.getSizeOfHashMap(this.attributes.size());
            for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
                size += objectSizes.getSizeOf(entry.getKey());
                size += objectSizes.getSizeOf((String)entry.getValue());
            }
        }
        if (null != this.headers) {
            size += objectSizes.getSizeOfHashMap(this.headers.size());
            for (Map.Entry<String, Object> entry : this.headers.entrySet()) {
                size += objectSizes.getSizeOf(entry.getKey());
                size += objectSizes.getSizeOf((String)entry.getValue());
            }
        }
        if (null != this.sessionAttributes) {
            size += objectSizes.getSizeOfHashMap(this.sessionAttributes.size());
            for (Map.Entry<String, Object> entry : this.sessionAttributes.entrySet()) {
                size += objectSizes.getSizeOf(entry.getKey());
                size += objectSizes.getSizeOf((String)entry.getValue());
            }
        }
        size += objectSizes.getSizeOf(this.httpInfo);
        if (doAlign) {
            return objectSizes.alignTo8Bytes(size);
        }
        return size;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.headers == null ? 0 : this.headers.hashCode());
        result = 31 * result + (this.httpInfo == null ? 0 : this.httpInfo.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.sessionAttributes == null ? 0 : this.sessionAttributes.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpTimerData other = (HttpTimerData)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.headers == null ? other.headers != null : !this.headers.equals(other.headers)) {
            return false;
        }
        if (this.httpInfo == null ? other.httpInfo != null : !this.httpInfo.equals(other.httpInfo)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        return !(this.sessionAttributes == null ? other.sessionAttributes != null : !this.sessionAttributes.equals(other.sessionAttributes));
    }

    public String toString() {
        String sup = super.toString();
        return sup + "HttpTimerData [uri=" + (null != this.httpInfo ? this.httpInfo.getUri() : "n.a.") + ", parameters=" + this.parameters + ", attributes=" + this.attributes + ", headers=" + this.headers + "]";
    }
}

