/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage;

import info.novatec.inspectit.storage.AbstractStorageData;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.label.AbstractStorageLabel;
import info.novatec.inspectit.storage.label.type.AbstractStorageLabelType;
import java.util.ArrayList;
import java.util.List;

public class LocalStorageData
extends AbstractStorageData {
    private static final long serialVersionUID = -6129025210768974889L;
    private boolean fullyDownloaded;
    private List<AbstractStorageLabel<?>> labelList = new ArrayList();

    public LocalStorageData() {
    }

    public LocalStorageData(StorageData storageData) {
        this.copyStorageDataInformation(storageData);
    }

    public final void copyStorageDataInformation(StorageData storageData) {
        this.setId(storageData.getId());
        this.setName(storageData.getName());
        this.setDescription(storageData.getDescription());
        this.setDiskSize(storageData.getDiskSize());
        this.setCmrVersion(storageData.getCmrVersion());
        this.labelList = storageData.getLabelList();
    }

    public boolean isFullyDownloaded() {
        return this.fullyDownloaded;
    }

    public void setFullyDownloaded(boolean fullyDownloaded) {
        this.fullyDownloaded = fullyDownloaded;
    }

    @Override
    public List<AbstractStorageLabel<?>> getLabelList() {
        return this.labelList;
    }

    public <T> List<AbstractStorageLabel<T>> getLabels(AbstractStorageLabelType<T> labelType) {
        ArrayList<AbstractStorageLabel<T>> labels = new ArrayList<AbstractStorageLabel<T>>();
        for (AbstractStorageLabel<?> label : this.labelList) {
            if (!label.getStorageLabelType().equals(labelType)) continue;
            labels.add(label);
        }
        return labels;
    }
}

