/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.indexing.storage.impl;

import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.indexing.IIndexQuery;
import info.novatec.inspectit.indexing.LeafTask;
import info.novatec.inspectit.indexing.impl.IndexingException;
import info.novatec.inspectit.indexing.storage.AbstractStorageDescriptor;
import info.novatec.inspectit.indexing.storage.IStorageDescriptor;
import info.novatec.inspectit.indexing.storage.IStorageTreeComponent;
import info.novatec.inspectit.indexing.storage.impl.SimpleStorageDescriptor;
import info.novatec.inspectit.indexing.storage.impl.StorageDescriptor;
import info.novatec.inspectit.storage.util.StorageUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;
import org.apache.commons.lang.builder.ToStringBuilder;

public class LeafWithNoDescriptors<E extends DefaultData>
implements IStorageTreeComponent<E> {
    private static final long MAX_RANGE_SIZE = 0x800000L;
    private int id;
    private transient BoundedDecriptor boundedDecriptor = new BoundedDecriptor();
    private List<SimpleStorageDescriptor> descriptors = new ArrayList<SimpleStorageDescriptor>();

    public LeafWithNoDescriptors() {
        this(StorageUtil.getRandomInt());
    }

    public LeafWithNoDescriptors(int id) {
        this.id = id;
    }

    @Override
    public IStorageDescriptor put(E element) throws IndexingException {
        return this.boundedDecriptor;
    }

    @Override
    public IStorageDescriptor get(E element) {
        throw new UnsupportedOperationException("LeafWithNoDescriptors can not answer on the single element query.");
    }

    @Override
    public List<IStorageDescriptor> query(IIndexQuery query) {
        ArrayList<IStorageDescriptor> list = new ArrayList<IStorageDescriptor>();
        for (SimpleStorageDescriptor simpleStorageDescriptor : this.descriptors) {
            list.add(new StorageDescriptor(this.id, simpleStorageDescriptor));
        }
        return list;
    }

    @Override
    public List<IStorageDescriptor> query(IIndexQuery query, ForkJoinPool forkJoinPool) {
        return forkJoinPool.invoke(this.getTaskForForkJoinQuery(query));
    }

    @Override
    public IStorageDescriptor getAndRemove(E template) {
        return null;
    }

    @Override
    public synchronized void preWriteFinalization() {
        this.optimiseDescriptors(this.descriptors);
    }

    @Override
    public long getComponentSize(IObjectSizes objectSizes) {
        long size = objectSizes.getSizeOfObjectHeader();
        size += objectSizes.getPrimitiveTypesSize(2, 0, 1, 0, 0, 0);
        size += objectSizes.getSizeOf(this.descriptors);
        long descriptorSize = objectSizes.alignTo8Bytes(objectSizes.getSizeOfObjectObject() + objectSizes.getPrimitiveTypesSize(0, 0, 1, 0, 1, 0));
        return objectSizes.alignTo8Bytes(size += (long)this.descriptors.size() * descriptorSize);
    }

    private synchronized void addPositionAndSize(long position, long size) {
        for (SimpleStorageDescriptor storageDescriptor : this.descriptors) {
            if ((long)storageDescriptor.getSize() + size >= 0x800000L || !storageDescriptor.join(position, size)) continue;
            return;
        }
        SimpleStorageDescriptor storageDescriptor = new SimpleStorageDescriptor(position, (int)size);
        this.descriptors.add(storageDescriptor);
    }

    private void optimiseDescriptors(List<SimpleStorageDescriptor> descriptorList) {
        for (int i = 0; i < descriptorList.size() - 1; ++i) {
            for (int j = i + 1; j < descriptorList.size(); ++j) {
                SimpleStorageDescriptor descriptor = this.descriptors.get(i);
                SimpleStorageDescriptor other = this.descriptors.get(j);
                if ((long)(descriptor.getSize() + other.getSize()) >= 0x800000L || !descriptor.join(other)) continue;
                descriptorList.remove(j);
                --j;
            }
        }
    }

    int getId() {
        return this.id;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("descriptors", this.descriptors);
        return toStringBuilder.toString();
    }

    @Override
    public RecursiveTask<List<IStorageDescriptor>> getTaskForForkJoinQuery(IIndexQuery query) {
        return new LeafTask(this, query);
    }

    private class BoundedDecriptor
    extends AbstractStorageDescriptor {
        private BoundedDecriptor() {
        }

        @Override
        public int getChannelId() {
            return LeafWithNoDescriptors.this.id;
        }

        @Override
        public void setChannelId(int channelId) {
        }

        @Override
        public long getPosition() {
            return 0L;
        }

        @Override
        public long getSize() {
            return 0L;
        }

        @Override
        public void setPositionAndSize(long position, long size) {
            LeafWithNoDescriptors.this.addPositionAndSize(position, size);
        }
    }
}

