/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.util;

import java.lang.ref.SoftReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakList<T>
extends AbstractList<T> {
    private List<SoftReference<T>> refs = new ArrayList<SoftReference<T>>();

    private T getHardReference(SoftReference<T> o) {
        if (null != o) {
            return o.get();
        }
        return null;
    }

    @Override
    public T get(int index) {
        return this.getHardReference(this.refs.get(index));
    }

    @Override
    public boolean add(T o) {
        return this.refs.add(new SoftReference<T>(o));
    }

    @Override
    public void add(int index, T o) {
        this.refs.add(index, new SoftReference<T>(o));
    }

    @Override
    public void clear() {
        this.refs.clear();
    }

    @Override
    public T remove(int index) {
        return this.getHardReference(this.refs.remove(index));
    }

    @Override
    public T set(int index, T element) {
        return this.getHardReference(this.refs.set(index, new SoftReference<T>(element)));
    }

    @Override
    public boolean contains(Object o) {
        for (int i = 0; i < this.size(); ++i) {
            if (o != this.get(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.refs.size();
    }

    public List<T> getHardReferences() {
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < this.size(); ++i) {
            T tmp = this.get(i);
            if (null == tmp) continue;
            result.add(tmp);
        }
        return result;
    }

    public void removeAllNullElements() {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (this.get(i) != null) continue;
            this.remove(i);
        }
    }
}

