/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.util;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringConstraint {
    private static final Logger LOG = LoggerFactory.getLogger(StringConstraint.class);
    private static final boolean USE_TRAILING_DOTS = true;
    private static final int MAX_STRING_LENGTH = Integer.MAX_VALUE;
    private int effectiveStringLength;

    public StringConstraint(Map<String, Object> parameter) {
        block4: {
            this.effectiveStringLength = Integer.MAX_VALUE;
            String value = (String)parameter.get("stringLength");
            if (value != null) {
                try {
                    int configStringLength = Integer.parseInt(value);
                    if (configStringLength < Integer.MAX_VALUE && configStringLength >= 0) {
                        this.effectiveStringLength = configStringLength;
                    }
                }
                catch (NumberFormatException e) {
                    if (!LOG.isWarnEnabled()) break block4;
                    LOG.warn("Property 'stringLength' is not defined correctly. Using unlimited string length.");
                }
            }
        }
    }

    public String crop(String string) {
        if (null == string || string.length() <= this.effectiveStringLength) {
            return string;
        }
        if (this.effectiveStringLength == 0) {
            return "";
        }
        String cropped = string.substring(0, this.effectiveStringLength);
        cropped = this.appendTrailingDots(cropped);
        return cropped;
    }

    public Map<String, String[]> crop(Map<String, String[]> original) {
        HashMap<String, String[]> result = new HashMap<String, String[]>(original.size());
        for (Map.Entry<String, String[]> entry : original.entrySet()) {
            String key = entry.getKey();
            if (null == key) continue;
            String[] value = entry.getValue();
            String[] convertedValue = null;
            if (null == value) {
                convertedValue = new String[]{"<notset>"};
            } else {
                boolean croppingWasNeeded = false;
                convertedValue = value;
                int l = value.length;
                for (int i = 0; i < l; ++i) {
                    String curValue = value[i];
                    String croppingResult = this.crop(curValue);
                    if (curValue != croppingResult & !croppingWasNeeded) {
                        croppingWasNeeded = true;
                        convertedValue = new String[value.length];
                        System.arraycopy(value, 0, convertedValue, 0, i);
                        convertedValue[i] = croppingResult;
                    }
                    if (!croppingWasNeeded) continue;
                    convertedValue[i] = croppingResult;
                }
            }
            result.put(key, convertedValue);
        }
        return result;
    }

    public String cropKeepFinalCharacter(String string, char finalChar) {
        String cropped = this.crop(string);
        if (null == string || string.equals(cropped)) {
            return string;
        }
        if (cropped.length() == 0) {
            return cropped;
        }
        return cropped + finalChar;
    }

    private String appendTrailingDots(String string) {
        return string + "...";
    }
}

