/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionCache {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectionCache.class);
    Cache<Class<?>, Cache<String, Method>> cache = CacheBuilder.newBuilder().weakKeys().softValues().build();

    public Object invokeMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes, Object instance, Object[] values, Object errorValue) {
        Method method;
        if (null == clazz || null == methodName) {
            return errorValue;
        }
        Cache classCache = (Cache)this.cache.getIfPresent(clazz);
        if (null == classCache) {
            classCache = CacheBuilder.newBuilder().expireAfterAccess(1200L, TimeUnit.SECONDS).weakKeys().build();
            this.cache.put(clazz, (Object)classCache);
        }
        if (null == (method = (Method)classCache.getIfPresent((Object)methodName))) {
            try {
                method = clazz.getMethod(methodName, parameterTypes);
                method.setAccessible(true);
            }
            catch (Exception e) {
                LOG.warn("Could not lookup method " + methodName + " on class " + clazz.getName(), (Throwable)e);
                return errorValue;
            }
            classCache.put((Object)methodName, (Object)method);
        }
        try {
            return method.invoke(instance, values);
        }
        catch (Exception e) {
            LOG.warn("Could not invoke method " + methodName + " on instance " + instance, (Throwable)e);
            return errorValue;
        }
    }
}

