/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.util;

import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class MessageFormatFormatter
extends Formatter {
    private static final MessageFormat MESSAGE_FORMAT = new MessageFormat("{0,date,HH:mm:ss,sss} {1} {2} - {3} \n");
    private static final MessageFormat MESSAGE_FORMAT_THROWN = new MessageFormat("{0,date,HH:mm:ss,sss} {1} {2} - {3} \n {4} \n");

    public String format(LogRecord record) {
        Object[] arguments = new Object[5];
        arguments[0] = new Date(record.getMillis());
        arguments[1] = record.getLevel();
        String[] nameSplit = record.getSourceClassName().split("\\.");
        arguments[2] = nameSplit[nameSplit.length - 1];
        arguments[3] = record.getMessage();
        if (null != record.getThrown()) {
            arguments[4] = record.getThrown().toString();
            return MESSAGE_FORMAT_THROWN.format(arguments);
        }
        return MESSAGE_FORMAT.format(arguments);
    }
}

