/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.spring;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import info.novatec.inspectit.agent.config.IConfigurationStorage;
import info.novatec.inspectit.agent.config.impl.JmxSensorTypeConfig;
import info.novatec.inspectit.agent.config.impl.MethodSensorTypeConfig;
import info.novatec.inspectit.agent.config.impl.PlatformSensorTypeConfig;
import info.novatec.inspectit.agent.config.impl.StrategyConfig;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@Configuration
@ComponentScan(value={"info.novatec.inspectit"})
public class SpringConfiguration
implements BeanDefinitionRegistryPostProcessor {
    private BeanDefinitionRegistry registry;
    private ConfigurableListableBeanFactory beanFactory;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.registry = registry;
    }

    @Bean
    public static PropertyPlaceholderConfigurer properties() {
        PropertyPlaceholderConfigurer ppc = new PropertyPlaceholderConfigurer();
        ClassPathResource[] resources = new ClassPathResource[]{new ClassPathResource("/config/bytebufferpool.properties"), new ClassPathResource("/config/instrumentation.properties")};
        ppc.setLocations((Resource[])resources);
        ppc.setIgnoreUnresolvablePlaceholders(true);
        return ppc;
    }

    @Bean(name={"socketReadExecutorService"})
    @Scope(value="singleton")
    public ExecutorService getSocketReadExecutorService() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("inspectit-socket-read-executor-service-thread-%d").setDaemon(true).build();
        return Executors.newFixedThreadPool(1, threadFactory);
    }

    @Bean(name={"coreServiceExecutorService"})
    @Scope(value="singleton")
    public ScheduledExecutorService getScheduledExecutorService() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("inspectit-core-service-executor-service-thread-%d").setDaemon(true).build();
        return Executors.newScheduledThreadPool(1, threadFactory);
    }

    public void registerComponents(IConfigurationStorage configurationStorage) throws Exception {
        String className = configurationStorage.getBufferStrategyConfig().getClazzName();
        String beanName = "bufferStrategy[" + className + "]";
        this.registerBeanDefinitionAndInitialize(beanName, className);
        for (StrategyConfig sendingStrategyConfig : configurationStorage.getSendingStrategyConfigs()) {
            className = sendingStrategyConfig.getClazzName();
            beanName = "sendingStrategy[" + className + "]";
            this.registerBeanDefinitionAndInitialize(beanName, className);
        }
        for (PlatformSensorTypeConfig platformSensorTypeConfig : configurationStorage.getPlatformSensorTypes()) {
            className = platformSensorTypeConfig.getClassName();
            beanName = "platformSensorType[" + className + "]";
            this.registerBeanDefinitionAndInitialize(beanName, className);
        }
        for (JmxSensorTypeConfig jmxSensorTypeConfig : configurationStorage.getJmxSensorTypes()) {
            className = jmxSensorTypeConfig.getClassName();
            beanName = "jmxSensorType[" + className + "]";
            this.registerBeanDefinitionAndInitialize(beanName, className);
        }
        for (MethodSensorTypeConfig methodSensorTypeConfig : configurationStorage.getMethodSensorTypes()) {
            className = methodSensorTypeConfig.getClassName();
            beanName = "methodSensorType[" + className + "]";
            this.registerBeanDefinitionAndInitialize(beanName, className);
        }
    }

    private void registerBeanDefinitionAndInitialize(String beanName, String className) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(className);
        GenericBeanDefinition definition = new GenericBeanDefinition();
        definition.setBeanClass(clazz);
        definition.setAutowireMode(2);
        definition.setAutowireCandidate(true);
        this.registry.registerBeanDefinition(beanName, (BeanDefinition)definition);
        this.beanFactory.getBean(beanName, clazz);
    }
}

