/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.sensor.platform.provider.ibm;

import info.novatec.inspectit.agent.sensor.platform.provider.def.DefaultOperatingSystemInfoProvider;
import info.novatec.inspectit.agent.sensor.platform.provider.util.CpuUsageCalculator;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IbmJava6OperatingSystemInfoProvider
extends DefaultOperatingSystemInfoProvider {
    private static final Logger LOG = LoggerFactory.getLogger(IbmJava6OperatingSystemInfoProvider.class);
    private static final String IBM_OPERATING_SYSTEM_MX_BEAN_CLASS = "com.ibm.lang.management.OperatingSystemMXBeanImpl";
    private RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
    private CpuUsageCalculator cpuCalculator = new CpuUsageCalculator();
    private Method committedVirtualMemorySizeMethod;
    private Method freePhysicalMemorySizeMethod;
    private Method processCpuTimeMethod;
    private Method totalPhysicalMemorySizeMethod;
    private Object ibmOperatingSystemMxBeanInstance;

    public IbmJava6OperatingSystemInfoProvider() throws Exception {
        this.initAndCheckEnvironment();
    }

    private void initAndCheckEnvironment() throws Exception {
        Class<?> ibmOperatingSystemMxBeanClass = null;
        ibmOperatingSystemMxBeanClass = Class.forName(IBM_OPERATING_SYSTEM_MX_BEAN_CLASS);
        if (null != ibmOperatingSystemMxBeanClass) {
            Method getInstanceMethod = ibmOperatingSystemMxBeanClass.getDeclaredMethod("getInstance", new Class[0]);
            getInstanceMethod.setAccessible(true);
            if (null != getInstanceMethod) {
                this.ibmOperatingSystemMxBeanInstance = getInstanceMethod.invoke(null, new Object[0]);
            }
            if (null != this.ibmOperatingSystemMxBeanInstance) {
                this.committedVirtualMemorySizeMethod = this.getMethod(ibmOperatingSystemMxBeanClass, "getProcessVirtualMemorySize", new Class[0]);
                Object result = this.getValueFromMethodInvocation(this.ibmOperatingSystemMxBeanInstance, this.committedVirtualMemorySizeMethod, new Object[0]);
                if (!(result instanceof Number)) {
                    throw new Exception("Result of getProcessVirtualMemorySize() method invocation is not a number. Result was: " + result);
                }
                this.freePhysicalMemorySizeMethod = this.getMethod(ibmOperatingSystemMxBeanClass, "getFreePhysicalMemorySize", new Class[0]);
                result = this.getValueFromMethodInvocation(this.ibmOperatingSystemMxBeanInstance, this.freePhysicalMemorySizeMethod, new Object[0]);
                if (!(result instanceof Number)) {
                    throw new Exception("Result of getFreePhysicalMemorySize() method invocation is not a number. Result was: " + result);
                }
                this.processCpuTimeMethod = this.getMethod(ibmOperatingSystemMxBeanClass, "getProcessCpuTime", new Class[0]);
                result = this.getValueFromMethodInvocation(this.ibmOperatingSystemMxBeanInstance, this.processCpuTimeMethod, new Object[0]);
                if (!(result instanceof Number)) {
                    throw new Exception("Result of getProcessCpuTime() method invocation is not a number. Result was: " + result);
                }
                this.totalPhysicalMemorySizeMethod = this.getMethod(ibmOperatingSystemMxBeanClass, "getTotalPhysicalMemory", new Class[0]);
                result = this.getValueFromMethodInvocation(this.ibmOperatingSystemMxBeanInstance, this.totalPhysicalMemorySizeMethod, new Object[0]);
                if (!(result instanceof Number)) {
                    throw new Exception("Result of getTotalPhysicalMemory() method invocation is not a number. Result was: " + result);
                }
            }
        }
    }

    @Override
    public long getCommittedVirtualMemorySize() {
        Number result = (Number)this.getValueFromMethodInvocation(this.ibmOperatingSystemMxBeanInstance, this.committedVirtualMemorySizeMethod, new Object[0]);
        return result.longValue();
    }

    @Override
    public long getFreePhysicalMemorySize() {
        Number result = (Number)this.getValueFromMethodInvocation(this.ibmOperatingSystemMxBeanInstance, this.freePhysicalMemorySizeMethod, new Object[0]);
        return result.longValue();
    }

    @Override
    public long getProcessCpuTime() {
        Number result = (Number)this.getValueFromMethodInvocation(this.ibmOperatingSystemMxBeanInstance, this.processCpuTimeMethod, new Object[0]);
        return result.longValue() * 100L;
    }

    @Override
    public long getTotalPhysicalMemorySize() {
        Number result = (Number)this.getValueFromMethodInvocation(this.ibmOperatingSystemMxBeanInstance, this.totalPhysicalMemorySizeMethod, new Object[0]);
        return result.longValue();
    }

    @Override
    public float retrieveCpuUsage() {
        this.cpuCalculator.setUptime(this.runtimeBean.getUptime());
        this.cpuCalculator.setProcessCpuTime(this.getProcessCpuTime());
        this.cpuCalculator.setAvailableProcessors(this.getAvailableProcessors());
        this.cpuCalculator.updateCpuUsage();
        return this.cpuCalculator.getCpuUsage();
    }

    private Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws Exception {
        Method m = clazz.getDeclaredMethod(methodName, parameterTypes);
        m.setAccessible(true);
        return m;
    }

    private <V> V getValueFromMethodInvocation(Object instance, Method method, Object ... args) {
        try {
            return (V)method.invoke(instance, args);
        }
        catch (Exception e) {
            LOG.warn("Exception throw during method invocation.", (Throwable)e);
            return null;
        }
    }
}

