/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.sensor.platform.provider.factory;

import info.novatec.inspectit.agent.sensor.platform.provider.PlatformSensorInfoProvider;
import info.novatec.inspectit.agent.sensor.platform.provider.def.DefaultPlatformSensorInfoProvider;
import info.novatec.inspectit.agent.sensor.platform.provider.ibm.IbmJava6PlatformSensorInfoProvider;
import info.novatec.inspectit.agent.sensor.platform.provider.sun.SunPlatformSensorInfoProvider;
import info.novatec.inspectit.util.UnderlyingSystemInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PlatformSensorInfoProviderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PlatformSensorInfoProviderFactory.class);
    private static volatile PlatformSensorInfoProvider platformSensorInfoProvider;

    private PlatformSensorInfoProviderFactory() {
    }

    public static PlatformSensorInfoProvider getPlatformSensorInfoProvider() {
        return platformSensorInfoProvider;
    }

    private static synchronized void createIbmJava6PlatformSensorInfoProvider() throws Exception {
        if (null == platformSensorInfoProvider) {
            platformSensorInfoProvider = new IbmJava6PlatformSensorInfoProvider();
        }
    }

    private static synchronized void createSunPlatformSensorInfoProvider() {
        if (null == platformSensorInfoProvider) {
            platformSensorInfoProvider = new SunPlatformSensorInfoProvider();
        }
    }

    private static synchronized void createDefaultPlatformSensorInfoProvider() {
        if (null == platformSensorInfoProvider) {
            platformSensorInfoProvider = new DefaultPlatformSensorInfoProvider();
        }
    }

    static {
        if (UnderlyingSystemInfo.JVM_PROVIDER == UnderlyingSystemInfo.JvmProvider.SUN || UnderlyingSystemInfo.JVM_PROVIDER == UnderlyingSystemInfo.JvmProvider.ORACLE) {
            if (null == platformSensorInfoProvider) {
                PlatformSensorInfoProviderFactory.createSunPlatformSensorInfoProvider();
            }
        } else if (UnderlyingSystemInfo.JVM_PROVIDER == UnderlyingSystemInfo.JvmProvider.IBM && (UnderlyingSystemInfo.JAVA_VERSION == UnderlyingSystemInfo.JavaVersion.JAVA_1_6 || UnderlyingSystemInfo.JAVA_VERSION == UnderlyingSystemInfo.JavaVersion.JAVA_1_7) && null == platformSensorInfoProvider) {
            try {
                PlatformSensorInfoProviderFactory.createIbmJava6PlatformSensorInfoProvider();
            }
            catch (Exception e) {
                LOG.warn("Creation of the Platform Sensor Info Provider for IBM virtual machine failed.", (Throwable)e);
            }
        }
        if (null == platformSensorInfoProvider) {
            PlatformSensorInfoProviderFactory.createDefaultPlatformSensorInfoProvider();
        }
    }
}

