/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.sensor.platform.provider.def;

import info.novatec.inspectit.agent.sensor.platform.provider.RuntimeInfoProvider;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;

public class DefaultRuntimeInfoProvider
implements RuntimeInfoProvider {
    private CompilationMXBean compilationBean = ManagementFactory.getCompilationMXBean();
    private ClassLoadingMXBean classLoadingBean = ManagementFactory.getClassLoadingMXBean();
    private RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();

    public long getTotalCompilationTime() {
        try {
            return this.compilationBean.getTotalCompilationTime();
        }
        catch (UnsupportedOperationException e) {
            return -1L;
        }
    }

    public long getTotalLoadedClassCount() {
        return this.classLoadingBean.getTotalLoadedClassCount();
    }

    public int getLoadedClassCount() {
        return this.classLoadingBean.getLoadedClassCount();
    }

    public long getUnloadedClassCount() {
        return this.classLoadingBean.getUnloadedClassCount();
    }

    public String getJitCompilerName() {
        return this.compilationBean.getName();
    }

    public String getVmName() {
        try {
            return this.runtimeBean.getVmName();
        }
        catch (SecurityException e) {
            return "";
        }
    }

    public String getVmVendor() {
        try {
            return this.runtimeBean.getVmVendor();
        }
        catch (SecurityException e) {
            return "";
        }
    }

    public String getVmVersion() {
        try {
            return this.runtimeBean.getVmVersion();
        }
        catch (SecurityException e) {
            return "";
        }
    }

    public String getSpecName() {
        try {
            return this.runtimeBean.getSpecName();
        }
        catch (SecurityException e) {
            return "";
        }
    }

    public String getClassPath() {
        try {
            return this.runtimeBean.getClassPath();
        }
        catch (SecurityException e) {
            return "";
        }
    }

    public String getLibraryPath() {
        try {
            return this.runtimeBean.getLibraryPath();
        }
        catch (SecurityException e) {
            return "";
        }
    }

    public String getBootClassPath() {
        try {
            return this.runtimeBean.getBootClassPath();
        }
        catch (UnsupportedOperationException e) {
            return "";
        }
        catch (SecurityException e) {
            return "";
        }
    }

    public long getUptime() {
        return this.runtimeBean.getUptime();
    }
}

