/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.sensor.platform;

import info.novatec.inspectit.agent.core.ICoreService;
import info.novatec.inspectit.agent.core.IIdManager;
import info.novatec.inspectit.agent.core.IdNotAvailableException;
import info.novatec.inspectit.agent.sensor.platform.AbstractPlatformSensor;
import info.novatec.inspectit.agent.sensor.platform.IPlatformSensor;
import info.novatec.inspectit.agent.sensor.platform.provider.ThreadInfoProvider;
import info.novatec.inspectit.agent.sensor.platform.provider.factory.PlatformSensorInfoProviderFactory;
import info.novatec.inspectit.communication.SystemSensorData;
import info.novatec.inspectit.communication.data.ThreadInformationData;
import info.novatec.inspectit.spring.logger.Log;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadInformation
extends AbstractPlatformSensor
implements IPlatformSensor {
    @Log
    Logger log;
    @Autowired
    private IIdManager idManager;
    private ThreadInfoProvider threadBean = PlatformSensorInfoProviderFactory.getPlatformSensorInfoProvider().getThreadInfoProvider();

    public ThreadInformation() {
    }

    public ThreadInformation(IIdManager idManager) {
        this.idManager = idManager;
    }

    public int getDaemonThreadCount() {
        return this.threadBean.getDaemonThreadCount();
    }

    public int getPeakThreadCount() {
        return this.threadBean.getPeakThreadCount();
    }

    public int getThreadCount() {
        return this.threadBean.getThreadCount();
    }

    public long getTotalStartedThreadCount() {
        return this.threadBean.getTotalStartedThreadCount();
    }

    @Override
    public void update(ICoreService coreService, long sensorTypeIdent) {
        int daemonThreadCount = this.getDaemonThreadCount();
        int peakThreadCount = this.getPeakThreadCount();
        int threadCount = this.getThreadCount();
        long totalStartedThreadCount = this.getTotalStartedThreadCount();
        ThreadInformationData threadData = (ThreadInformationData)coreService.getPlatformSensorData(sensorTypeIdent);
        if (threadData == null) {
            try {
                long platformId = this.idManager.getPlatformId();
                long registeredSensorTypeId = this.idManager.getRegisteredSensorTypeId(sensorTypeIdent);
                Timestamp timestamp = new Timestamp(GregorianCalendar.getInstance().getTimeInMillis());
                threadData = new ThreadInformationData(timestamp, platformId, registeredSensorTypeId);
                threadData.incrementCount();
                threadData.addDaemonThreadCount(daemonThreadCount);
                threadData.setMinDaemonThreadCount(daemonThreadCount);
                threadData.setMaxDaemonThreadCount(daemonThreadCount);
                threadData.addPeakThreadCount(peakThreadCount);
                threadData.setMinPeakThreadCount(peakThreadCount);
                threadData.setMaxPeakThreadCount(peakThreadCount);
                threadData.addThreadCount(threadCount);
                threadData.setMinThreadCount(threadCount);
                threadData.setMaxThreadCount(threadCount);
                threadData.addTotalStartedThreadCount(totalStartedThreadCount);
                threadData.setMinTotalStartedThreadCount(totalStartedThreadCount);
                threadData.setMaxTotalStartedThreadCount(totalStartedThreadCount);
                coreService.addPlatformSensorData(sensorTypeIdent, (SystemSensorData)threadData);
            }
            catch (IdNotAvailableException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Could not save the thread information because of an unavailable id. " + e.getMessage());
                }
            }
        } else {
            threadData.incrementCount();
            threadData.addDaemonThreadCount(daemonThreadCount);
            threadData.addPeakThreadCount(peakThreadCount);
            threadData.addThreadCount(threadCount);
            threadData.addTotalStartedThreadCount(totalStartedThreadCount);
            if (daemonThreadCount < threadData.getMinDaemonThreadCount()) {
                threadData.setMinDaemonThreadCount(daemonThreadCount);
            } else if (daemonThreadCount > threadData.getMaxDaemonThreadCount()) {
                threadData.setMaxDaemonThreadCount(daemonThreadCount);
            }
            if (peakThreadCount < threadData.getMinPeakThreadCount()) {
                threadData.setMinPeakThreadCount(peakThreadCount);
            } else if (peakThreadCount > threadData.getMaxPeakThreadCount()) {
                threadData.setMaxPeakThreadCount(peakThreadCount);
            }
            if (threadCount < threadData.getMinThreadCount()) {
                threadData.setMinThreadCount(threadCount);
            } else if (threadCount > threadData.getMaxThreadCount()) {
                threadData.setMaxThreadCount(threadCount);
            }
            if (totalStartedThreadCount < threadData.getMinTotalStartedThreadCount()) {
                threadData.setMinTotalStartedThreadCount(totalStartedThreadCount);
            } else if (totalStartedThreadCount > threadData.getMaxTotalStartedThreadCount()) {
                threadData.setMaxTotalStartedThreadCount(totalStartedThreadCount);
            }
        }
    }

    @Override
    public void init(Map<String, Object> parameter) {
    }

    @Override
    public boolean automaticUpdate() {
        return true;
    }
}

