/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.sensor.platform;

import info.novatec.inspectit.agent.core.ICoreService;
import info.novatec.inspectit.agent.core.IIdManager;
import info.novatec.inspectit.agent.core.IdNotAvailableException;
import info.novatec.inspectit.agent.sensor.platform.AbstractPlatformSensor;
import info.novatec.inspectit.agent.sensor.platform.IPlatformSensor;
import info.novatec.inspectit.agent.sensor.platform.provider.MemoryInfoProvider;
import info.novatec.inspectit.agent.sensor.platform.provider.OperatingSystemInfoProvider;
import info.novatec.inspectit.agent.sensor.platform.provider.RuntimeInfoProvider;
import info.novatec.inspectit.agent.sensor.platform.provider.factory.PlatformSensorInfoProviderFactory;
import info.novatec.inspectit.communication.SystemSensorData;
import info.novatec.inspectit.communication.data.SystemInformationData;
import info.novatec.inspectit.spring.logger.Log;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemInformation
extends AbstractPlatformSensor
implements IPlatformSensor {
    @Log
    Logger log;
    private static final int MAX_LENGTH = 10000;
    @Autowired
    private IIdManager idManager;
    private boolean updateRequested = true;
    private OperatingSystemInfoProvider osBean = PlatformSensorInfoProviderFactory.getPlatformSensorInfoProvider().getOperatingSystemInfoProvider();
    private MemoryInfoProvider memoryBean = PlatformSensorInfoProviderFactory.getPlatformSensorInfoProvider().getMemoryInfoProvider();
    private RuntimeInfoProvider runtimeBean = PlatformSensorInfoProviderFactory.getPlatformSensorInfoProvider().getRuntimeInfoProvider();

    public SystemInformation() {
    }

    public SystemInformation(IIdManager idManager) {
        this.idManager = idManager;
    }

    public long getTotalPhysMemory() {
        return this.osBean.getTotalPhysicalMemorySize();
    }

    public long getTotalSwapSpace() {
        return this.osBean.getTotalSwapSpaceSize();
    }

    public int getAvailableProcessors() {
        return this.osBean.getAvailableProcessors();
    }

    public String getArchitecture() {
        return this.osBean.getArch();
    }

    public String getOsName() {
        return this.osBean.getName();
    }

    public String getOsVersion() {
        return this.osBean.getVersion();
    }

    public String getJitCompilerName() {
        return this.runtimeBean.getJitCompilerName();
    }

    public String getClassPath() {
        return this.runtimeBean.getClassPath();
    }

    public String getBootClassPath() {
        return this.runtimeBean.getBootClassPath();
    }

    public String getLibraryPath() {
        return this.runtimeBean.getLibraryPath();
    }

    public String getVmVendor() {
        return this.runtimeBean.getVmVendor();
    }

    public String getVmName() {
        return this.runtimeBean.getVmName();
    }

    public String getVmVersion() {
        return this.runtimeBean.getVmVersion();
    }

    public String getVmSpecName() {
        return this.runtimeBean.getSpecName();
    }

    public long getInitHeapMemorySize() {
        return this.memoryBean.getHeapMemoryUsage().getInit();
    }

    public long getMaxHeapMemorySize() {
        return this.memoryBean.getHeapMemoryUsage().getMax();
    }

    public long getInitNonHeapMemorySize() {
        return this.memoryBean.getNonHeapMemoryUsage().getInit();
    }

    public long getMaxNonHeapMemorySize() {
        return this.memoryBean.getNonHeapMemoryUsage().getMax();
    }

    @Override
    public void update(ICoreService coreService, long sensorTypeIdent) {
        block3: {
            try {
                long platformId = this.idManager.getPlatformId();
                long registeredSensorTypeId = this.idManager.getRegisteredSensorTypeId(sensorTypeIdent);
                Timestamp timestamp = new Timestamp(GregorianCalendar.getInstance().getTimeInMillis());
                SystemInformationData systemData = new SystemInformationData(timestamp, platformId, registeredSensorTypeId);
                this.updateRequested = false;
                String vmArgumentName = "";
                String vmArgumentValue = "";
                long totalPhysMemory = this.getTotalPhysMemory();
                long totalSwapSpace = this.getTotalSwapSpace();
                int availableProcessors = this.getAvailableProcessors();
                String architecture = this.getArchitecture();
                String osName = this.getOsName();
                String osVersion = this.getOsVersion();
                String jitCompilerName = this.getJitCompilerName();
                String classPath = this.crop(this.getClassPath());
                String bootClassPath = this.crop(this.getBootClassPath());
                String libraryPath = this.crop(this.getLibraryPath());
                String vmVendor = this.getVmVendor();
                String vmVersion = this.getVmVersion();
                String vmName = this.getVmName();
                String vmSpecName = this.getVmSpecName();
                long initHeapMemorySize = this.getInitHeapMemorySize();
                long maxHeapMemorySize = this.getMaxHeapMemorySize();
                long initNonHeapMemorySize = this.getInitNonHeapMemorySize();
                long maxNonHeapMemorySize = this.getMaxNonHeapMemorySize();
                systemData.setTotalPhysMemory(totalPhysMemory);
                systemData.setTotalSwapSpace(totalSwapSpace);
                systemData.setAvailableProcessors(availableProcessors);
                systemData.setArchitecture(architecture);
                systemData.setOsName(osName);
                systemData.setOsVersion(osVersion);
                systemData.setJitCompilerName(jitCompilerName);
                systemData.setClassPath(classPath);
                systemData.setBootClassPath(bootClassPath);
                systemData.setLibraryPath(libraryPath);
                systemData.setVmVendor(vmVendor);
                systemData.setVmVersion(vmVersion);
                systemData.setVmName(vmName);
                systemData.setVmSpecName(vmSpecName);
                systemData.setInitHeapMemorySize(initHeapMemorySize);
                systemData.setMaxHeapMemorySize(maxHeapMemorySize);
                systemData.setInitNonHeapMemorySize(initNonHeapMemorySize);
                systemData.setMaxNonHeapMemorySize(maxNonHeapMemorySize);
                Properties properties = System.getProperties();
                for (Map.Entry<Object, Object> property : properties.entrySet()) {
                    vmArgumentName = (String)property.getKey();
                    vmArgumentValue = (String)property.getValue();
                    systemData.addVMArguments(vmArgumentName, vmArgumentValue);
                }
                coreService.addPlatformSensorData(sensorTypeIdent, (SystemSensorData)systemData);
            }
            catch (IdNotAvailableException e) {
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug("Could not save the system information because of an unavailable id. " + e.getMessage());
            }
        }
    }

    @Override
    public void init(Map<String, Object> parameter) {
    }

    @Override
    public boolean automaticUpdate() {
        return this.updateRequested;
    }

    private String crop(String value) {
        if (null != value && value.length() > 10000) {
            return value.substring(0, 10000);
        }
        return value;
    }
}

