/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.sensor.platform;

import info.novatec.inspectit.agent.core.ICoreService;
import info.novatec.inspectit.agent.core.IIdManager;
import info.novatec.inspectit.agent.core.IdNotAvailableException;
import info.novatec.inspectit.agent.sensor.platform.AbstractPlatformSensor;
import info.novatec.inspectit.agent.sensor.platform.IPlatformSensor;
import info.novatec.inspectit.agent.sensor.platform.provider.RuntimeInfoProvider;
import info.novatec.inspectit.agent.sensor.platform.provider.factory.PlatformSensorInfoProviderFactory;
import info.novatec.inspectit.communication.SystemSensorData;
import info.novatec.inspectit.communication.data.RuntimeInformationData;
import info.novatec.inspectit.spring.logger.Log;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeInformation
extends AbstractPlatformSensor
implements IPlatformSensor {
    @Log
    Logger log;
    @Autowired
    private IIdManager idManager;
    private RuntimeInfoProvider runtimeBean = PlatformSensorInfoProviderFactory.getPlatformSensorInfoProvider().getRuntimeInfoProvider();

    public RuntimeInformation() {
    }

    public RuntimeInformation(IIdManager idManager) {
        this.idManager = idManager;
    }

    public long getUptime() {
        return this.runtimeBean.getUptime();
    }

    @Override
    public void update(ICoreService coreService, long sensorTypeIdent) {
        long uptime = this.getUptime();
        RuntimeInformationData runtimeData = (RuntimeInformationData)coreService.getPlatformSensorData(sensorTypeIdent);
        if (runtimeData == null) {
            try {
                long platformId = this.idManager.getPlatformId();
                long registeredSensorTypeId = this.idManager.getRegisteredSensorTypeId(sensorTypeIdent);
                Timestamp timestamp = new Timestamp(GregorianCalendar.getInstance().getTimeInMillis());
                runtimeData = new RuntimeInformationData(timestamp, platformId, registeredSensorTypeId);
                runtimeData.incrementCount();
                runtimeData.addUptime(uptime);
                runtimeData.setMinUptime(uptime);
                runtimeData.setMaxUptime(uptime);
                coreService.addPlatformSensorData(sensorTypeIdent, (SystemSensorData)runtimeData);
            }
            catch (IdNotAvailableException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Could not save the runtime information because of an unavailable id. " + e.getMessage());
                }
            }
        } else {
            runtimeData.incrementCount();
            runtimeData.addUptime(uptime);
            if (uptime < runtimeData.getMinUptime()) {
                runtimeData.setMinUptime(uptime);
            } else if (uptime > runtimeData.getMaxUptime()) {
                runtimeData.setMaxUptime(uptime);
            }
        }
    }

    @Override
    public void init(Map<String, Object> parameter) {
    }

    @Override
    public boolean automaticUpdate() {
        return true;
    }
}

