/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.sensor.platform;

import info.novatec.inspectit.agent.core.ICoreService;
import info.novatec.inspectit.agent.core.IIdManager;
import info.novatec.inspectit.agent.core.IdNotAvailableException;
import info.novatec.inspectit.agent.sensor.platform.AbstractPlatformSensor;
import info.novatec.inspectit.agent.sensor.platform.IPlatformSensor;
import info.novatec.inspectit.agent.sensor.platform.provider.MemoryInfoProvider;
import info.novatec.inspectit.agent.sensor.platform.provider.OperatingSystemInfoProvider;
import info.novatec.inspectit.agent.sensor.platform.provider.factory.PlatformSensorInfoProviderFactory;
import info.novatec.inspectit.communication.SystemSensorData;
import info.novatec.inspectit.communication.data.MemoryInformationData;
import info.novatec.inspectit.spring.logger.Log;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryInformation
extends AbstractPlatformSensor
implements IPlatformSensor {
    @Log
    Logger log;
    @Autowired
    private IIdManager idManager;
    private MemoryInfoProvider memoryBean = PlatformSensorInfoProviderFactory.getPlatformSensorInfoProvider().getMemoryInfoProvider();
    private OperatingSystemInfoProvider osBean = PlatformSensorInfoProviderFactory.getPlatformSensorInfoProvider().getOperatingSystemInfoProvider();

    public MemoryInformation() {
    }

    public MemoryInformation(IIdManager idManager) {
        this.idManager = idManager;
    }

    public long getFreePhysMemory() {
        return this.osBean.getFreePhysicalMemorySize();
    }

    public long getFreeSwapSpace() {
        return this.osBean.getFreeSwapSpaceSize();
    }

    public long getComittedVirtualMemSize() {
        return this.osBean.getCommittedVirtualMemorySize();
    }

    public long getUsedHeapMemorySize() {
        return this.memoryBean.getHeapMemoryUsage().getUsed();
    }

    public long getComittedHeapMemorySize() {
        return this.memoryBean.getHeapMemoryUsage().getCommitted();
    }

    public long getUsedNonHeapMemorySize() {
        return this.memoryBean.getNonHeapMemoryUsage().getUsed();
    }

    public long getComittedNonHeapMemoryUsage() {
        return this.memoryBean.getNonHeapMemoryUsage().getCommitted();
    }

    @Override
    public void update(ICoreService coreService, long sensorTypeIdent) {
        long freePhysMemory = this.getFreePhysMemory();
        long freeSwapSpace = this.getFreeSwapSpace();
        long comittedVirtualMemSize = this.getComittedVirtualMemSize();
        long usedHeapMemorySize = this.getUsedHeapMemorySize();
        long comittedHeapMemorySize = this.getComittedHeapMemorySize();
        long usedNonHeapMemorySize = this.getUsedNonHeapMemorySize();
        long comittedNonHeapMemorySize = this.getComittedNonHeapMemoryUsage();
        MemoryInformationData memoryData = (MemoryInformationData)coreService.getPlatformSensorData(sensorTypeIdent);
        if (memoryData == null) {
            try {
                long platformId = this.idManager.getPlatformId();
                long registeredSensorTypeId = this.idManager.getRegisteredSensorTypeId(sensorTypeIdent);
                Timestamp timestamp = new Timestamp(GregorianCalendar.getInstance().getTimeInMillis());
                memoryData = new MemoryInformationData(timestamp, platformId, registeredSensorTypeId);
                memoryData.incrementCount();
                memoryData.addFreePhysMemory(freePhysMemory);
                memoryData.setMinFreePhysMemory(freePhysMemory);
                memoryData.setMaxFreePhysMemory(freePhysMemory);
                memoryData.addFreeSwapSpace(freeSwapSpace);
                memoryData.setMinFreeSwapSpace(freeSwapSpace);
                memoryData.setMaxFreeSwapSpace(freeSwapSpace);
                memoryData.addComittedVirtualMemSize(comittedVirtualMemSize);
                memoryData.setMinComittedVirtualMemSize(comittedVirtualMemSize);
                memoryData.setMaxComittedVirtualMemSize(comittedVirtualMemSize);
                memoryData.addUsedHeapMemorySize(usedHeapMemorySize);
                memoryData.setMinUsedHeapMemorySize(usedHeapMemorySize);
                memoryData.setMaxUsedHeapMemorySize(usedHeapMemorySize);
                memoryData.addComittedHeapMemorySize(comittedHeapMemorySize);
                memoryData.setMinComittedHeapMemorySize(comittedHeapMemorySize);
                memoryData.setMaxComittedHeapMemorySize(comittedHeapMemorySize);
                memoryData.addUsedNonHeapMemorySize(usedNonHeapMemorySize);
                memoryData.setMinUsedNonHeapMemorySize(usedNonHeapMemorySize);
                memoryData.setMaxUsedNonHeapMemorySize(usedNonHeapMemorySize);
                memoryData.addComittedNonHeapMemorySize(comittedNonHeapMemorySize);
                memoryData.setMinComittedNonHeapMemorySize(comittedNonHeapMemorySize);
                memoryData.setMaxComittedNonHeapMemorySize(comittedNonHeapMemorySize);
                coreService.addPlatformSensorData(sensorTypeIdent, (SystemSensorData)memoryData);
            }
            catch (IdNotAvailableException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Could not save the memory information because of an unavailable id. " + e.getMessage());
                }
            }
        } else {
            memoryData.incrementCount();
            memoryData.addFreePhysMemory(freePhysMemory);
            memoryData.addFreeSwapSpace(freeSwapSpace);
            memoryData.addComittedVirtualMemSize(comittedVirtualMemSize);
            memoryData.addUsedHeapMemorySize(usedHeapMemorySize);
            memoryData.addComittedHeapMemorySize(comittedHeapMemorySize);
            memoryData.addUsedNonHeapMemorySize(usedNonHeapMemorySize);
            memoryData.addComittedNonHeapMemorySize(comittedNonHeapMemorySize);
            if (freePhysMemory < memoryData.getMinFreePhysMemory()) {
                memoryData.setMinFreePhysMemory(freePhysMemory);
            } else if (freePhysMemory > memoryData.getMaxFreePhysMemory()) {
                memoryData.setMaxFreePhysMemory(freePhysMemory);
            }
            if (freeSwapSpace < memoryData.getMinFreeSwapSpace()) {
                memoryData.setMinFreeSwapSpace(freeSwapSpace);
            } else if (freeSwapSpace > memoryData.getMaxFreeSwapSpace()) {
                memoryData.setMaxFreeSwapSpace(freeSwapSpace);
            }
            if (comittedVirtualMemSize < memoryData.getMinComittedVirtualMemSize()) {
                memoryData.setMinComittedVirtualMemSize(comittedVirtualMemSize);
            } else if (comittedVirtualMemSize > memoryData.getMaxComittedVirtualMemSize()) {
                memoryData.setMaxComittedVirtualMemSize(comittedVirtualMemSize);
            }
            if (usedHeapMemorySize < memoryData.getMinUsedHeapMemorySize()) {
                memoryData.setMinUsedHeapMemorySize(usedHeapMemorySize);
            } else if (usedHeapMemorySize > memoryData.getMaxUsedHeapMemorySize()) {
                memoryData.setMaxUsedHeapMemorySize(usedHeapMemorySize);
            }
            if (comittedHeapMemorySize < memoryData.getMinComittedHeapMemorySize()) {
                memoryData.setMinComittedHeapMemorySize(comittedHeapMemorySize);
            } else if (comittedHeapMemorySize > memoryData.getMaxComittedHeapMemorySize()) {
                memoryData.setMaxComittedHeapMemorySize(comittedHeapMemorySize);
            }
            if (usedNonHeapMemorySize < memoryData.getMinUsedNonHeapMemorySize()) {
                memoryData.setMinUsedNonHeapMemorySize(usedNonHeapMemorySize);
            } else if (usedNonHeapMemorySize > memoryData.getMaxUsedNonHeapMemorySize()) {
                memoryData.setMaxUsedNonHeapMemorySize(usedNonHeapMemorySize);
            }
            if (comittedNonHeapMemorySize < memoryData.getMinComittedNonHeapMemorySize()) {
                memoryData.setMinComittedNonHeapMemorySize(comittedNonHeapMemorySize);
            } else if (comittedNonHeapMemorySize > memoryData.getMaxComittedNonHeapMemorySize()) {
                memoryData.setMaxComittedNonHeapMemorySize(comittedNonHeapMemorySize);
            }
        }
    }

    @Override
    public void init(Map<String, Object> parameter) {
    }

    @Override
    public boolean automaticUpdate() {
        return true;
    }
}

