/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.sensor.platform;

import info.novatec.inspectit.agent.core.ICoreService;
import info.novatec.inspectit.agent.core.IIdManager;
import info.novatec.inspectit.agent.core.IdNotAvailableException;
import info.novatec.inspectit.agent.sensor.platform.AbstractPlatformSensor;
import info.novatec.inspectit.agent.sensor.platform.IPlatformSensor;
import info.novatec.inspectit.agent.sensor.platform.provider.OperatingSystemInfoProvider;
import info.novatec.inspectit.agent.sensor.platform.provider.factory.PlatformSensorInfoProviderFactory;
import info.novatec.inspectit.communication.SystemSensorData;
import info.novatec.inspectit.communication.data.CpuInformationData;
import info.novatec.inspectit.spring.logger.Log;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CpuInformation
extends AbstractPlatformSensor
implements IPlatformSensor {
    @Log
    Logger log;
    @Autowired
    private IIdManager idManager;
    private OperatingSystemInfoProvider osBean = PlatformSensorInfoProviderFactory.getPlatformSensorInfoProvider().getOperatingSystemInfoProvider();

    public CpuInformation() {
    }

    public CpuInformation(IIdManager idManager) {
        this.idManager = idManager;
    }

    public long getProcessCpuTime() {
        return this.osBean.getProcessCpuTime();
    }

    @Override
    public void update(ICoreService coreService, long sensorTypeIdent) {
        long processCpuTime = this.getProcessCpuTime();
        float cpuUsage = this.osBean.retrieveCpuUsage();
        CpuInformationData osData = (CpuInformationData)coreService.getPlatformSensorData(sensorTypeIdent);
        if (osData == null) {
            try {
                long platformId = this.idManager.getPlatformId();
                long registeredSensorTypeId = this.idManager.getRegisteredSensorTypeId(sensorTypeIdent);
                Timestamp timestamp = new Timestamp(GregorianCalendar.getInstance().getTimeInMillis());
                osData = new CpuInformationData(timestamp, platformId, registeredSensorTypeId);
                osData.incrementCount();
                osData.updateProcessCpuTime(processCpuTime);
                osData.addCpuUsage(cpuUsage);
                osData.setMinCpuUsage(cpuUsage);
                osData.setMaxCpuUsage(cpuUsage);
                coreService.addPlatformSensorData(sensorTypeIdent, (SystemSensorData)osData);
            }
            catch (IdNotAvailableException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Could not save the cpu information because of an unavailable id. " + e.getMessage());
                }
            }
        } else {
            osData.incrementCount();
            osData.updateProcessCpuTime(processCpuTime);
            osData.addCpuUsage(cpuUsage);
            if (cpuUsage < osData.getMinCpuUsage()) {
                osData.setMinCpuUsage(cpuUsage);
            } else if (cpuUsage > osData.getMaxCpuUsage()) {
                osData.setMaxCpuUsage(cpuUsage);
            }
        }
    }

    @Override
    public void init(Map<String, Object> parameter) {
    }

    @Override
    public boolean automaticUpdate() {
        return true;
    }
}

