/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.sensor.platform;

import info.novatec.inspectit.agent.core.ICoreService;
import info.novatec.inspectit.agent.core.IIdManager;
import info.novatec.inspectit.agent.core.IdNotAvailableException;
import info.novatec.inspectit.agent.sensor.platform.AbstractPlatformSensor;
import info.novatec.inspectit.agent.sensor.platform.IPlatformSensor;
import info.novatec.inspectit.agent.sensor.platform.provider.RuntimeInfoProvider;
import info.novatec.inspectit.agent.sensor.platform.provider.factory.PlatformSensorInfoProviderFactory;
import info.novatec.inspectit.communication.SystemSensorData;
import info.novatec.inspectit.communication.data.CompilationInformationData;
import info.novatec.inspectit.spring.logger.Log;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationInformation
extends AbstractPlatformSensor
implements IPlatformSensor {
    @Log
    Logger log;
    @Autowired
    private IIdManager idManager;
    private RuntimeInfoProvider runtimeBean = PlatformSensorInfoProviderFactory.getPlatformSensorInfoProvider().getRuntimeInfoProvider();

    public CompilationInformation() {
    }

    public CompilationInformation(IIdManager idManager) {
        this.idManager = idManager;
    }

    public long getTotalCompilationTime() {
        return this.runtimeBean.getTotalCompilationTime();
    }

    @Override
    public void update(ICoreService coreService, long sensorTypeIdent) {
        long totalCompilationTime = this.getTotalCompilationTime();
        CompilationInformationData compilationData = (CompilationInformationData)coreService.getPlatformSensorData(sensorTypeIdent);
        if (compilationData == null) {
            try {
                long platformId = this.idManager.getPlatformId();
                long registeredSensorTypeId = this.idManager.getRegisteredSensorTypeId(sensorTypeIdent);
                Timestamp timestamp = new Timestamp(GregorianCalendar.getInstance().getTimeInMillis());
                compilationData = new CompilationInformationData(timestamp, platformId, registeredSensorTypeId);
                compilationData.incrementCount();
                compilationData.addTotalCompilationTime(totalCompilationTime);
                compilationData.setMinTotalCompilationTime(totalCompilationTime);
                compilationData.setMaxTotalCompilationTime(totalCompilationTime);
                coreService.addPlatformSensorData(sensorTypeIdent, (SystemSensorData)compilationData);
            }
            catch (IdNotAvailableException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Could not save the compilation information because of an unavailable id. " + e.getMessage());
                }
            }
        } else {
            compilationData.incrementCount();
            compilationData.addTotalCompilationTime(totalCompilationTime);
            if (totalCompilationTime < compilationData.getMinTotalCompilationTime()) {
                compilationData.setMinTotalCompilationTime(totalCompilationTime);
            } else if (totalCompilationTime > compilationData.getMaxTotalCompilationTime()) {
                compilationData.setMaxTotalCompilationTime(totalCompilationTime);
            }
        }
    }

    @Override
    public void init(Map<String, Object> parameter) {
    }

    @Override
    public boolean automaticUpdate() {
        return true;
    }
}

