/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.sensor.platform;

import info.novatec.inspectit.agent.core.ICoreService;
import info.novatec.inspectit.agent.core.IIdManager;
import info.novatec.inspectit.agent.core.IdNotAvailableException;
import info.novatec.inspectit.agent.sensor.platform.AbstractPlatformSensor;
import info.novatec.inspectit.agent.sensor.platform.IPlatformSensor;
import info.novatec.inspectit.agent.sensor.platform.provider.RuntimeInfoProvider;
import info.novatec.inspectit.agent.sensor.platform.provider.factory.PlatformSensorInfoProviderFactory;
import info.novatec.inspectit.communication.SystemSensorData;
import info.novatec.inspectit.communication.data.ClassLoadingInformationData;
import info.novatec.inspectit.spring.logger.Log;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoadingInformation
extends AbstractPlatformSensor
implements IPlatformSensor {
    @Log
    Logger log;
    @Autowired
    private IIdManager idManager;
    private RuntimeInfoProvider runtimeBean = PlatformSensorInfoProviderFactory.getPlatformSensorInfoProvider().getRuntimeInfoProvider();

    public ClassLoadingInformation() {
    }

    public ClassLoadingInformation(IIdManager idManager) {
        this.idManager = idManager;
    }

    public int getLoadedClassCount() {
        return this.runtimeBean.getLoadedClassCount();
    }

    public long getTotalLoadedClassCount() {
        return this.runtimeBean.getTotalLoadedClassCount();
    }

    public long getUnloadedClassCount() {
        return this.runtimeBean.getUnloadedClassCount();
    }

    @Override
    public void update(ICoreService coreService, long sensorTypeIdent) {
        int loadedClassCount = this.getLoadedClassCount();
        long totalLoadedClassCount = this.getTotalLoadedClassCount();
        long unloadedClassCount = this.getUnloadedClassCount();
        ClassLoadingInformationData classLoadingData = (ClassLoadingInformationData)coreService.getPlatformSensorData(sensorTypeIdent);
        if (classLoadingData == null) {
            try {
                long platformId = this.idManager.getPlatformId();
                long registeredSensorTypeId = this.idManager.getRegisteredSensorTypeId(sensorTypeIdent);
                Timestamp timestamp = new Timestamp(GregorianCalendar.getInstance().getTimeInMillis());
                classLoadingData = new ClassLoadingInformationData(timestamp, platformId, registeredSensorTypeId);
                classLoadingData.incrementCount();
                classLoadingData.addLoadedClassCount(loadedClassCount);
                classLoadingData.setMinLoadedClassCount(loadedClassCount);
                classLoadingData.setMaxLoadedClassCount(loadedClassCount);
                classLoadingData.addTotalLoadedClassCount(totalLoadedClassCount);
                classLoadingData.setMinTotalLoadedClassCount(totalLoadedClassCount);
                classLoadingData.setMaxTotalLoadedClassCount(totalLoadedClassCount);
                classLoadingData.addUnloadedClassCount(unloadedClassCount);
                classLoadingData.setMinUnloadedClassCount(unloadedClassCount);
                classLoadingData.setMaxUnloadedClassCount(unloadedClassCount);
                coreService.addPlatformSensorData(sensorTypeIdent, (SystemSensorData)classLoadingData);
            }
            catch (IdNotAvailableException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Could not save the class loading information because of an unavailable id. " + e.getMessage());
                }
            }
        } else {
            classLoadingData.incrementCount();
            classLoadingData.addLoadedClassCount(loadedClassCount);
            classLoadingData.addTotalLoadedClassCount(totalLoadedClassCount);
            classLoadingData.addUnloadedClassCount(unloadedClassCount);
            if (loadedClassCount < classLoadingData.getMinLoadedClassCount()) {
                classLoadingData.setMinLoadedClassCount(loadedClassCount);
            } else if (loadedClassCount > classLoadingData.getMaxLoadedClassCount()) {
                classLoadingData.setMaxLoadedClassCount(loadedClassCount);
            }
            if (totalLoadedClassCount < classLoadingData.getMinTotalLoadedClassCount()) {
                classLoadingData.setMinTotalLoadedClassCount(totalLoadedClassCount);
            } else if (totalLoadedClassCount > classLoadingData.getMaxTotalLoadedClassCount()) {
                classLoadingData.setMaxTotalLoadedClassCount(totalLoadedClassCount);
            }
            if (unloadedClassCount < classLoadingData.getMinUnloadedClassCount()) {
                classLoadingData.setMinUnloadedClassCount(unloadedClassCount);
            } else if (unloadedClassCount > classLoadingData.getMaxUnloadedClassCount()) {
                classLoadingData.setMaxUnloadedClassCount(unloadedClassCount);
            }
        }
    }

    @Override
    public void init(Map<String, Object> parameter) {
    }

    @Override
    public boolean automaticUpdate() {
        return true;
    }
}

