/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.sensor.method.timer;

import info.novatec.inspectit.agent.sensor.method.timer.AggregateTimerStorage;
import info.novatec.inspectit.agent.sensor.method.timer.ITimerStorage;
import info.novatec.inspectit.agent.sensor.method.timer.OptimizedTimerStorage;
import info.novatec.inspectit.agent.sensor.method.timer.PlainTimerStorage;
import info.novatec.inspectit.communication.data.ParameterContentData;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimerStorageFactory {
    private static TimerStorageFactory singleton;
    public static final int RAW_DATA_TRANSMISSION = 0;
    public static final int AGGREGATE_BEFORE_SEND = 1;
    public static final int OPTIMIZED = 2;
    private int mode = 2;

    private TimerStorageFactory() {
    }

    public static TimerStorageFactory getFactory() {
        if (null == singleton) {
            TimerStorageFactory.createTimerStorageFactory();
        }
        return singleton;
    }

    private static synchronized void createTimerStorageFactory() {
        if (null == singleton) {
            singleton = new TimerStorageFactory();
        }
    }

    public void setParameters(Map<String, Object> parameters) {
        String mode = (String)parameters.get("mode");
        if (null != mode) {
            if ("raw".equals(mode)) {
                this.setMode(0);
            } else if ("aggregate".equals(mode)) {
                this.setMode(1);
            } else if ("optimized".equals(mode)) {
                this.setMode(2);
            }
        }
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public ITimerStorage newStorage(Timestamp timeStamp, long platformIdent, long sensorTypeIdent, long methodIdent, List<ParameterContentData> parameterContentData, boolean charting) {
        switch (this.mode) {
            case 0: {
                return new PlainTimerStorage(timeStamp, platformIdent, sensorTypeIdent, methodIdent, parameterContentData, charting);
            }
            case 1: {
                return new AggregateTimerStorage(timeStamp, platformIdent, sensorTypeIdent, methodIdent, parameterContentData, charting);
            }
            case 2: {
                return new OptimizedTimerStorage(timeStamp, platformIdent, sensorTypeIdent, methodIdent, parameterContentData, charting);
            }
        }
        return new OptimizedTimerStorage(timeStamp, platformIdent, sensorTypeIdent, methodIdent, parameterContentData, charting);
    }
}

