/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.sensor.method.timer;

import info.novatec.inspectit.agent.config.IPropertyAccessor;
import info.novatec.inspectit.agent.config.impl.RegisteredSensorConfig;
import info.novatec.inspectit.agent.core.ICoreService;
import info.novatec.inspectit.agent.core.IIdManager;
import info.novatec.inspectit.agent.core.IdNotAvailableException;
import info.novatec.inspectit.agent.hooking.IConstructorHook;
import info.novatec.inspectit.agent.hooking.IMethodHook;
import info.novatec.inspectit.agent.sensor.method.timer.ITimerStorage;
import info.novatec.inspectit.agent.sensor.method.timer.TimerStorageFactory;
import info.novatec.inspectit.communication.data.ParameterContentData;
import info.novatec.inspectit.util.StringConstraint;
import info.novatec.inspectit.util.ThreadLocalStack;
import info.novatec.inspectit.util.Timer;
import java.lang.management.ThreadMXBean;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerHook
implements IMethodHook,
IConstructorHook {
    private static final Logger LOG = LoggerFactory.getLogger(TimerHook.class);
    private final ThreadLocalStack<Double> timeStack = new ThreadLocalStack();
    private final Timer timer;
    private final IIdManager idManager;
    private final IPropertyAccessor propertyAccessor;
    private final TimerStorageFactory timerStorageFactory = TimerStorageFactory.getFactory();
    private StringConstraint strConstraint;
    private ThreadMXBean threadMXBean;
    private boolean supported = false;
    private boolean enabled = false;
    private final ThreadLocalStack<Long> threadCpuTimeStack = new ThreadLocalStack();

    public TimerHook(Timer timer, IIdManager idManager, IPropertyAccessor propertyAccessor, Map<String, Object> param, ThreadMXBean threadMXBean) {
        this.timer = timer;
        this.idManager = idManager;
        this.propertyAccessor = propertyAccessor;
        this.threadMXBean = threadMXBean;
        try {
            this.supported = threadMXBean.isThreadCpuTimeSupported();
            if (this.supported) {
                this.enabled = threadMXBean.isThreadCpuTimeEnabled();
                if (!this.enabled) {
                    threadMXBean.setThreadCpuTimeEnabled(true);
                    this.enabled = threadMXBean.isThreadCpuTimeEnabled();
                }
            }
        }
        catch (RuntimeException e) {
            LOG.warn("Exception in the TimerHook.", (Throwable)e);
        }
        this.timerStorageFactory.setParameters(param);
        this.strConstraint = new StringConstraint(param);
    }

    @Override
    public void beforeBody(long methodId, long sensorTypeId, Object object, Object[] parameters, RegisteredSensorConfig rsc) {
        this.timeStack.push(new Double(this.timer.getCurrentTime()));
        if (this.enabled) {
            this.threadCpuTimeStack.push(this.threadMXBean.getCurrentThreadCpuTime());
        }
    }

    @Override
    public void firstAfterBody(long methodId, long sensorTypeId, Object object, Object[] parameters, Object result, RegisteredSensorConfig rsc) {
        this.timeStack.push(new Double(this.timer.getCurrentTime()));
        if (this.enabled) {
            this.threadCpuTimeStack.push(this.threadMXBean.getCurrentThreadCpuTime());
        }
    }

    @Override
    public void secondAfterBody(ICoreService coreService, long methodId, long sensorTypeId, Object object, Object[] parameters, Object result, RegisteredSensorConfig rsc) {
        ITimerStorage storage;
        double endTime = this.timeStack.pop();
        double startTime = this.timeStack.pop();
        double duration = endTime - startTime;
        double cpuDuration = -1.0;
        if (this.enabled) {
            long cpuEndTime = this.threadCpuTimeStack.pop();
            long cpuStartTime = this.threadCpuTimeStack.pop();
            cpuDuration = (double)(cpuEndTime - cpuStartTime) / 1000000.0;
        }
        List<ParameterContentData> parameterContentData = null;
        String prefix = null;
        if (rsc.isPropertyAccess()) {
            parameterContentData = this.propertyAccessor.getParameterContentData(rsc.getPropertyAccessorList(), object, parameters, result);
            prefix = parameterContentData.toString();
            for (ParameterContentData contentData : parameterContentData) {
                contentData.setContent(this.strConstraint.crop(contentData.getContent()));
            }
        }
        if (null == (storage = (ITimerStorage)coreService.getObjectStorage(sensorTypeId, methodId, prefix))) {
            try {
                long platformId = this.idManager.getPlatformId();
                long registeredSensorTypeId = this.idManager.getRegisteredSensorTypeId(sensorTypeId);
                long registeredMethodId = this.idManager.getRegisteredMethodId(methodId);
                Timestamp timestamp = new Timestamp(System.currentTimeMillis() - Math.round(duration));
                boolean charting = "true".equals(rsc.getSettings().get("charting"));
                storage = this.timerStorageFactory.newStorage(timestamp, platformId, registeredSensorTypeId, registeredMethodId, parameterContentData, charting);
                storage.addData(duration, cpuDuration);
                coreService.addObjectStorage(sensorTypeId, methodId, prefix, storage);
            }
            catch (IdNotAvailableException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not save the timer data because of an unavailable id. " + e.getMessage());
                }
            }
        } else {
            storage.addData(duration, cpuDuration);
        }
    }

    @Override
    public void beforeConstructor(long methodId, long sensorTypeId, Object[] parameters, RegisteredSensorConfig rsc) {
        this.timeStack.push(new Double(this.timer.getCurrentTime()));
        if (this.enabled) {
            this.threadCpuTimeStack.push(this.threadMXBean.getCurrentThreadCpuTime());
        }
    }

    @Override
    public void afterConstructor(ICoreService coreService, long methodId, long sensorTypeId, Object object, Object[] parameters, RegisteredSensorConfig rsc) {
        this.timeStack.push(new Double(this.timer.getCurrentTime()));
        if (this.enabled) {
            this.threadCpuTimeStack.push(this.threadMXBean.getCurrentThreadCpuTime());
        }
        this.secondAfterBody(coreService, methodId, sensorTypeId, object, parameters, null, rsc);
    }
}

