/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.sensor.method.timer;

import info.novatec.inspectit.agent.sensor.method.timer.ITimerStorage;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.ParameterContentData;
import info.novatec.inspectit.communication.data.TimerData;
import java.sql.Timestamp;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimizedTimerStorage
implements ITimerStorage {
    private TimerData timerData;

    public OptimizedTimerStorage(Timestamp timeStamp, long platformIdent, long sensorTypeIdent, long methodIdent, List<ParameterContentData> parameterContentData, boolean charting) {
        this.timerData = new TimerData(timeStamp, platformIdent, sensorTypeIdent, methodIdent, parameterContentData);
        this.timerData.setCharting(charting);
    }

    @Override
    public void addData(double time, double cpuTime) {
        this.timerData.increaseCount();
        this.timerData.addDuration(time);
        this.timerData.calculateMax(time);
        this.timerData.calculateMin(time);
        if (cpuTime >= 0.0) {
            this.timerData.addCpuDuration(cpuTime);
            this.timerData.calculateCpuMax(cpuTime);
            this.timerData.calculateCpuMin(cpuTime);
        }
    }

    @Override
    public DefaultData finalizeDataObject() {
        return this.timerData;
    }
}

