/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.sensor.method.logging.severity;

import info.novatec.inspectit.agent.sensor.method.logging.severity.Log4JSeverityHelper;
import info.novatec.inspectit.agent.sensor.method.logging.severity.SeverityHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SeverityHelperFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SeverityHelperFactory.class);

    private SeverityHelperFactory() {
    }

    public static SeverityHelper getForFramework(Framework framework, String minimumLevel) {
        Log4JSeverityHelper helper;
        switch (framework) {
            case LOG4J: {
                helper = new Log4JSeverityHelper(minimumLevel);
                break;
            }
            default: {
                throw new RuntimeException("No logging checker for framework " + (Object)((Object)framework) + " can be found.");
            }
        }
        if (!helper.isValid()) {
            LOG.warn("The configured minimum logging severity " + minimumLevel + " is not found for the technology log4j. No logging will be captured. Defined levels are " + ((SeverityHelper)helper).getOrderedLevels());
        }
        return helper;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Framework {
        LOG4J;

    }
}

