/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.sensor.method.logging;

import info.novatec.inspectit.agent.config.impl.RegisteredSensorConfig;
import info.novatec.inspectit.agent.core.ICoreService;
import info.novatec.inspectit.agent.core.IIdManager;
import info.novatec.inspectit.agent.core.IdNotAvailableException;
import info.novatec.inspectit.agent.hooking.IMethodHook;
import info.novatec.inspectit.agent.sensor.method.logging.severity.SeverityHelper;
import info.novatec.inspectit.agent.sensor.method.logging.severity.SeverityHelperFactory;
import info.novatec.inspectit.communication.MethodSensorData;
import info.novatec.inspectit.communication.data.LoggingData;
import java.sql.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log4JLoggingHook
implements IMethodHook {
    private static final Logger LOG = LoggerFactory.getLogger(Log4JLoggingHook.class);
    private IIdManager idManager;
    private SeverityHelper checker;

    public Log4JLoggingHook(IIdManager idManager, String minimumLevelToCapture) {
        this.idManager = idManager;
        this.checker = SeverityHelperFactory.getForFramework(SeverityHelperFactory.Framework.LOG4J, minimumLevelToCapture);
    }

    public void beforeBody(long methodId, long sensorTypeId, Object object, Object[] parameters, RegisteredSensorConfig rsc) {
    }

    public void firstAfterBody(long methodId, long sensorTypeId, Object object, Object[] parameters, Object result, RegisteredSensorConfig rsc) {
    }

    public void secondAfterBody(ICoreService coreService, long methodId, long sensorTypeId, Object object, Object[] parameters, Object result, RegisteredSensorConfig rsc) {
        block4: {
            if (this.checker.isValid()) {
                String level = String.valueOf(parameters[1]);
                if (!this.checker.shouldCapture(level)) {
                    return;
                }
                try {
                    LoggingData data = new LoggingData();
                    data.setLevel(level);
                    data.setMessage(String.valueOf(parameters[2]));
                    data.setPlatformIdent(this.idManager.getPlatformId());
                    data.setSensorTypeIdent(this.idManager.getRegisteredSensorTypeId(sensorTypeId));
                    data.setMethodIdent(this.idManager.getRegisteredMethodId(methodId));
                    data.setTimeStamp(new Timestamp(System.currentTimeMillis()));
                    coreService.addMethodSensorData(sensorTypeId, methodId, null, (MethodSensorData)data);
                }
                catch (IdNotAvailableException e) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug("Could not save the timer data because of an unavailable id. " + e.getMessage());
                }
            }
        }
    }
}

