/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.sensor.method.jdbc;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import info.novatec.inspectit.util.ThreadLocalStack;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class StatementStorage {
    private static final Logger LOG = LoggerFactory.getLogger(StatementStorage.class);
    private static final String NULL_VALUE = "null";
    private Cache<Object, QueryInformation> preparedStatements = CacheBuilder.newBuilder().expireAfterAccess(1200L, TimeUnit.SECONDS).weakKeys().build();
    private ThreadLocalStack<String> sqlThreadLocalStack = new ThreadLocalStack();

    public void addPreparedStatement(Object object) {
        String sql = this.sqlThreadLocalStack.getLast();
        this.preparedStatements.put(object, (Object)new QueryInformation(sql));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Recorded prepared sql statement: " + sql);
        }
    }

    protected String getPreparedStatement(Object object) {
        QueryInformation queryAndParameters = (QueryInformation)this.preparedStatements.getIfPresent(object);
        String query = null;
        if (null != queryAndParameters) {
            query = queryAndParameters.query;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Return prepared sql statement: " + query);
        }
        return query;
    }

    protected List<String> getParameters(Object object) {
        QueryInformation queryAndParameters = (QueryInformation)this.preparedStatements.getIfPresent(object);
        if (null == queryAndParameters) {
            return null;
        }
        return queryAndParameters.getParametersAsList();
    }

    protected void addParameter(Object preparedStatement, int index, Object value) {
        QueryInformation queryAndParameters = (QueryInformation)this.preparedStatements.getIfPresent(preparedStatement);
        if (null == queryAndParameters) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not get the prepared statement from the cache to add a parameter! Prepared Statement:" + preparedStatement + " index:" + index + " value:" + value);
            }
            return;
        }
        String[] parameters = queryAndParameters.getParameters();
        if (0 > index || parameters.length <= index) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Trying to set the parameter with value " + value + " at index " + index + ", but the prepared statement did not have parameter on this index.");
            }
            return;
        }
        if (null != value) {
            parameters[index] = value instanceof String || value instanceof Date || value instanceof Time || value instanceof Timestamp ? "'" + value.toString() + "'" : value.toString();
        } else {
            value = NULL_VALUE;
            parameters[index] = (String)value;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Prepared Statement :: Added value:" + value.toString() + " with index:" + index + " to prepared statement:" + preparedStatement);
        }
    }

    protected void clearParameters(Object preparedStatement) {
        QueryInformation queryAndParameters = (QueryInformation)this.preparedStatements.getIfPresent(preparedStatement);
        if (null == queryAndParameters) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not get the prepared statement from the cache to clear the parameters! Prepared Statement:" + preparedStatement);
            }
            return;
        }
        queryAndParameters.clearParameters();
    }

    protected void addSql(String sql) {
        this.sqlThreadLocalStack.push(sql);
    }

    protected void removeSql() {
        this.sqlThreadLocalStack.pop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QueryInformation {
        private String query;
        private String[] parameters = null;

        public QueryInformation(String query) {
            this.query = query;
        }

        public String[] getParameters() {
            if (null == this.parameters) {
                int count = 0;
                for (int i = this.query.length() - 1; i > 0; --i) {
                    if (this.query.charAt(i) != '?') continue;
                    ++count;
                }
                this.parameters = new String[count];
            }
            return this.parameters;
        }

        public void clearParameters() {
            if (null == this.parameters) {
                return;
            }
            this.parameters = new String[this.parameters.length];
        }

        public List<String> getParametersAsList() {
            if (null == this.parameters) {
                return null;
            }
            return Arrays.asList(this.parameters);
        }
    }
}

