/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.sensor.method.jdbc;

import info.novatec.inspectit.agent.config.impl.RegisteredSensorConfig;
import info.novatec.inspectit.agent.core.ICoreService;
import info.novatec.inspectit.agent.core.IIdManager;
import info.novatec.inspectit.agent.core.IdNotAvailableException;
import info.novatec.inspectit.agent.hooking.IMethodHook;
import info.novatec.inspectit.agent.sensor.method.jdbc.ConnectionMetaDataStorage;
import info.novatec.inspectit.agent.sensor.method.jdbc.StatementReflectionCache;
import info.novatec.inspectit.communication.MethodSensorData;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.util.StringConstraint;
import info.novatec.inspectit.util.ThreadLocalStack;
import info.novatec.inspectit.util.Timer;
import java.sql.Timestamp;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementHook
implements IMethodHook {
    private static final Logger LOG = LoggerFactory.getLogger(StatementHook.class);
    private final ThreadLocalStack<Double> timeStack = new ThreadLocalStack();
    private final Timer timer;
    private final IIdManager idManager;
    private final ConnectionMetaDataStorage connectionMetaDataStorage;
    private ThreadLocal<Boolean> threadLast = new ThreadLocal();
    private StringConstraint strConstraint;
    private StatementReflectionCache statementReflectionCache;

    public StatementHook(Timer timer, IIdManager idManager, ConnectionMetaDataStorage connectionMetaDataStorage, StatementReflectionCache statementReflectionCache, Map<String, Object> parameter) {
        this.timer = timer;
        this.idManager = idManager;
        this.connectionMetaDataStorage = connectionMetaDataStorage;
        this.strConstraint = new StringConstraint(parameter);
        this.statementReflectionCache = statementReflectionCache;
    }

    @Override
    public void beforeBody(long methodId, long sensorTypeId, Object object, Object[] parameters, RegisteredSensorConfig rsc) {
        this.timeStack.push(new Double(this.timer.getCurrentTime()));
        this.threadLast.set(Boolean.TRUE);
    }

    @Override
    public void firstAfterBody(long methodId, long sensorTypeId, Object object, Object[] parameters, Object result, RegisteredSensorConfig rsc) {
        this.timeStack.push(new Double(this.timer.getCurrentTime()));
    }

    @Override
    public void secondAfterBody(ICoreService coreService, long methodId, long sensorTypeId, Object object, Object[] parameters, Object result, RegisteredSensorConfig rsc) {
        double endTime = this.timeStack.pop();
        double startTime = this.timeStack.pop();
        if (this.threadLast.get().booleanValue()) {
            this.threadLast.set(Boolean.FALSE);
            double duration = endTime - startTime;
            String sql = parameters[0].toString();
            SqlStatementData sqlData = (SqlStatementData)coreService.getMethodSensorData(sensorTypeId, methodId, sql);
            if (null == sqlData) {
                try {
                    Timestamp timestamp = new Timestamp(System.currentTimeMillis() - Math.round(duration));
                    long platformId = this.idManager.getPlatformId();
                    long registeredSensorTypeId = this.idManager.getRegisteredSensorTypeId(sensorTypeId);
                    long registeredMethodId = this.idManager.getRegisteredMethodId(methodId);
                    sqlData = new SqlStatementData(timestamp, platformId, registeredSensorTypeId, registeredMethodId);
                    sqlData.setPreparedStatement(false);
                    sqlData.setSql(this.strConstraint.crop(sql));
                    sqlData.setDuration(duration);
                    sqlData.calculateMin(duration);
                    sqlData.calculateMax(duration);
                    sqlData.setCount(1L);
                    this.connectionMetaDataStorage.populate(sqlData, this.statementReflectionCache.getConnection(object.getClass(), object));
                    coreService.addMethodSensorData(sensorTypeId, methodId, sql, (MethodSensorData)sqlData);
                }
                catch (IdNotAvailableException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Could not save the sql data because of an unavailable id. " + e.getMessage());
                    }
                }
            } else {
                sqlData.increaseCount();
                sqlData.addDuration(duration);
                sqlData.calculateMin(duration);
                sqlData.calculateMax(duration);
            }
        }
    }
}

