/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.sensor.method.jdbc;

import info.novatec.inspectit.agent.config.impl.RegisteredSensorConfig;
import info.novatec.inspectit.agent.core.ICoreService;
import info.novatec.inspectit.agent.hooking.IMethodHook;
import info.novatec.inspectit.agent.sensor.method.jdbc.StatementStorage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PreparedStatementParameterHook
implements IMethodHook {
    private StatementStorage statementStorage;
    private static ThreadLocal<Boolean> threadLast = new ThreadLocal();
    private static final Map<String, String> METHOD_VALUE_MAP = new HashMap<String, String>();

    public PreparedStatementParameterHook(StatementStorage statementStorage) {
        this.statementStorage = statementStorage;
    }

    public void beforeBody(long methodId, long sensorTypeId, Object object, Object[] parameters, RegisteredSensorConfig rsc) {
        threadLast.set(Boolean.TRUE);
    }

    public void firstAfterBody(long methodId, long sensorTypeId, Object object, Object[] parameters, Object result, RegisteredSensorConfig rsc) {
    }

    public void secondAfterBody(ICoreService coreService, long methodId, long sensorTypeId, Object object, Object[] parameters, Object result, RegisteredSensorConfig rsc) {
        if (threadLast.get().booleanValue()) {
            threadLast.set(Boolean.FALSE);
            List<String> parameterTypes = rsc.getParameterTypes();
            if (METHOD_VALUE_MAP.containsKey(rsc.getTargetMethodName()) && parameterTypes.size() >= 1 && "int".equals(parameterTypes.get(0))) {
                int index = (Integer)parameters[0] - 1;
                String value = METHOD_VALUE_MAP.get(rsc.getTargetMethodName());
                this.statementStorage.addParameter(object, index, value);
            } else if (parameterTypes.size() >= 2 && "int".equals(parameterTypes.get(0))) {
                int index = (Integer)parameters[0] - 1;
                Object value = parameters[1];
                this.statementStorage.addParameter(object, index, value);
            } else if ("clearParameters".equals(rsc.getTargetMethodName())) {
                this.statementStorage.clearParameters(object);
            }
        }
    }

    static {
        METHOD_VALUE_MAP.put("setNull", null);
        METHOD_VALUE_MAP.put("setAsciiStream", "[AsciiStream]");
        METHOD_VALUE_MAP.put("setBinaryStream", "[BinaryStream]");
        METHOD_VALUE_MAP.put("setBlob", "[Blob]");
        METHOD_VALUE_MAP.put("setCharacterStream", "[CharacterStream]");
        METHOD_VALUE_MAP.put("setClob", "[Clob]");
        METHOD_VALUE_MAP.put("setNCharacterStream", "[NCharacterStream]");
        METHOD_VALUE_MAP.put("setNClob", "[NClob]");
        METHOD_VALUE_MAP.put("setUnicodeStream", "[UnicodeStream]");
    }
}

