/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.sensor.method.jdbc;

import info.novatec.inspectit.agent.config.impl.RegisteredSensorConfig;
import info.novatec.inspectit.agent.core.ICoreService;
import info.novatec.inspectit.agent.core.IIdManager;
import info.novatec.inspectit.agent.core.IdNotAvailableException;
import info.novatec.inspectit.agent.hooking.IConstructorHook;
import info.novatec.inspectit.agent.hooking.IMethodHook;
import info.novatec.inspectit.agent.sensor.method.jdbc.ConnectionMetaDataStorage;
import info.novatec.inspectit.agent.sensor.method.jdbc.StatementReflectionCache;
import info.novatec.inspectit.agent.sensor.method.jdbc.StatementStorage;
import info.novatec.inspectit.communication.MethodSensorData;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.util.StringConstraint;
import info.novatec.inspectit.util.ThreadLocalStack;
import info.novatec.inspectit.util.Timer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreparedStatementHook
implements IMethodHook,
IConstructorHook {
    Logger log = LoggerFactory.getLogger(PreparedStatementHook.class);
    private final ThreadLocalStack<Double> timeStack = new ThreadLocalStack();
    private final Timer timer;
    private final IIdManager idManager;
    private final StatementStorage statementStorage;
    private final ConnectionMetaDataStorage connectionMetaDataStorage;
    private ThreadLocal<Boolean> threadLast = new ThreadLocal();
    private StringConstraint strConstraint;
    private StatementReflectionCache statementReflectionCache;
    private static List<Long> preparedStatementsWithExceptions = new ArrayList<Long>(0);

    public PreparedStatementHook(Timer timer, IIdManager idManager, StatementStorage statementStorage, ConnectionMetaDataStorage connectionMetaDataStorage, StatementReflectionCache statementReflectionCache, Map<String, Object> parameter) {
        this.timer = timer;
        this.idManager = idManager;
        this.statementStorage = statementStorage;
        this.connectionMetaDataStorage = connectionMetaDataStorage;
        this.strConstraint = new StringConstraint(parameter);
        this.statementReflectionCache = statementReflectionCache;
    }

    @Override
    public void beforeBody(long methodId, long sensorTypeId, Object object, Object[] parameters, RegisteredSensorConfig rsc) {
        this.timeStack.push(new Double(this.timer.getCurrentTime()));
        this.threadLast.set(Boolean.TRUE);
    }

    @Override
    public void firstAfterBody(long methodId, long sensorTypeId, Object object, Object[] parameters, Object result, RegisteredSensorConfig rsc) {
        this.timeStack.push(new Double(this.timer.getCurrentTime()));
    }

    @Override
    public void secondAfterBody(ICoreService coreService, long methodId, long sensorTypeId, Object object, Object[] parameters, Object result, RegisteredSensorConfig rsc) {
        double endTime = this.timeStack.pop();
        double startTime = this.timeStack.pop();
        if (this.threadLast.get().booleanValue()) {
            this.threadLast.set(Boolean.FALSE);
            String sql = this.statementStorage.getPreparedStatement(object);
            if (null != sql) {
                double duration = endTime - startTime;
                SqlStatementData sqlData = (SqlStatementData)coreService.getMethodSensorData(sensorTypeId, methodId, sql);
                if (null == sqlData) {
                    try {
                        Timestamp timestamp = new Timestamp(System.currentTimeMillis() - Math.round(duration));
                        List<String> params = this.statementStorage.getParameters(object);
                        long platformId = this.idManager.getPlatformId();
                        long registeredSensorTypeId = this.idManager.getRegisteredSensorTypeId(sensorTypeId);
                        long registeredMethodId = this.idManager.getRegisteredMethodId(methodId);
                        sqlData = new SqlStatementData(timestamp, platformId, registeredSensorTypeId, registeredMethodId);
                        sqlData.setPreparedStatement(true);
                        sqlData.setSql(this.strConstraint.crop(sql));
                        sqlData.setDuration(duration);
                        sqlData.calculateMin(duration);
                        sqlData.calculateMax(duration);
                        sqlData.setCount(1L);
                        sqlData.setParameterValues(params);
                        this.connectionMetaDataStorage.populate(sqlData, this.statementReflectionCache.getConnection(object.getClass(), object));
                        coreService.addMethodSensorData(sensorTypeId, methodId, sql, (MethodSensorData)sqlData);
                    }
                    catch (IdNotAvailableException e) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Could not save the sql data because of an unavailable id. " + e.getMessage());
                        }
                    }
                } else {
                    sqlData.increaseCount();
                    sqlData.addDuration(duration);
                    sqlData.calculateMin(duration);
                    sqlData.calculateMax(duration);
                }
            } else {
                this.threadLast.set(Boolean.TRUE);
            }
        }
    }

    @Override
    public void beforeConstructor(long methodId, long sensorTypeId, Object[] parameters, RegisteredSensorConfig rsc) {
    }

    @Override
    public void afterConstructor(ICoreService coreService, long methodId, long sensorTypeId, Object object, Object[] parameters, RegisteredSensorConfig rsc) {
        try {
            this.statementStorage.addPreparedStatement(object);
        }
        catch (NoSuchElementException e) {
            Long methodIdLong = methodId;
            if (preparedStatementsWithExceptions.contains(methodIdLong)) {
                return;
            }
            this.log.info("Could not add prepared statement, no sql available! Method ID(local): " + methodId);
            this.log.info("This is not an inspectIT issue, but you forgot to integrate the Connection creating the SQL statement in the configuration, please consult the management of inspectIT and send the following stacktrace!", (Throwable)e);
            ArrayList<Long> clonedList = new ArrayList<Long>(preparedStatementsWithExceptions);
            clonedList.add(methodIdLong);
            preparedStatementsWithExceptions = clonedList;
        }
    }
}

