/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.sensor.method.jdbc;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.util.ReflectionCache;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ConnectionMetaDataStorage {
    protected static final ConnectionMetaData EMPTY = new ConnectionMetaData();
    Cache<Object, ConnectionMetaData> storage = CacheBuilder.newBuilder().weakKeys().softValues().build();
    ConnectionMetaDataExtractor dataExtractor = new ConnectionMetaDataExtractor();

    public void populate(SqlStatementData sqlData, Object connection) {
        ConnectionMetaData connectionMetaData = this.get(connection);
        if (null != connectionMetaData && EMPTY != connectionMetaData) {
            sqlData.setDatabaseProductName(connectionMetaData.product);
            sqlData.setDatabaseProductVersion(connectionMetaData.version);
            sqlData.setDatabaseUrl(connectionMetaData.url);
        }
    }

    private ConnectionMetaData get(final Object connection) {
        if (null == connection) {
            return null;
        }
        try {
            return (ConnectionMetaData)this.storage.get(connection, (Callable)new Callable<ConnectionMetaData>(){

                @Override
                public ConnectionMetaData call() throws Exception {
                    ConnectionMetaData data = ConnectionMetaDataStorage.this.dataExtractor.parse(connection);
                    return data != null ? data : EMPTY;
                }
            });
        }
        catch (ExecutionException e) {
            return EMPTY;
        }
    }

    static class JDBCUrlExtractor {
        private final Pattern urlPattern = Pattern.compile("^jdbc:(?:oracle:.*?|.*?):(?:[@/]*)?(.*?)([;?].*)?$");

        JDBCUrlExtractor() {
        }

        public String extractURLfromJDBCURL(String url) {
            try {
                Matcher matcher = this.urlPattern.matcher(url);
                matcher.find();
                return matcher.group(1);
            }
            catch (IllegalStateException i) {
                return url;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConnectionMetaDataExtractor {
        private static final String GET_META_DATA = "getMetaData";
        private static final String GET_URL = "getURL";
        private static final String GET_DATABASE_PRODUCT_VERSION = "getDatabaseProductVersion";
        private static final String GET_DATABASE_PRODUCT_NAME = "getDatabaseProductName";
        private static final String IS_CLOSED = "isClosed";
        static JDBCUrlExtractor urlExtractor = new JDBCUrlExtractor();
        static ReflectionCache cache = new ReflectionCache();
        static Logger logger = LoggerFactory.getLogger(ConnectionMetaDataExtractor.class);

        ConnectionMetaDataExtractor() {
        }

        public ConnectionMetaData parse(Object connection) {
            if (null == connection) {
                logger.warn("Meta Information on database cannot be read for the null connection.");
                return null;
            }
            Class<?> connectionClass = connection.getClass();
            if (this.isClosed(connectionClass, connection)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Meta Information on database cannot be read because the connection is closed.");
                }
                return null;
            }
            ConnectionMetaData data = new ConnectionMetaData();
            Object metaData = this.getMetaData(connectionClass, connection);
            if (null == metaData) {
                logger.warn("Meta information on database cannot be read for connection " + connection.toString() + ". No database details like URL or Vendor will be displayed.");
                return data;
            }
            Class<?> metaDataClass = metaData.getClass();
            data.version = this.parseVersion(metaDataClass, metaData);
            data.url = this.parseTarget(metaDataClass, metaData);
            data.product = this.parseProduct(metaDataClass, metaData);
            return data;
        }

        private boolean isClosed(Class<?> connectionClass, Object connection) {
            return (Boolean)cache.invokeMethod(connectionClass, IS_CLOSED, null, connection, null, true);
        }

        private Object getMetaData(Class<?> connectionClass, Object connection) {
            return cache.invokeMethod(connectionClass, GET_META_DATA, null, connection, null, null);
        }

        private String parseTarget(Class<?> databaseMetaDataClass, Object databaseMetaData) {
            String url = (String)cache.invokeMethod(databaseMetaDataClass, GET_URL, null, databaseMetaData, null, null);
            return urlExtractor.extractURLfromJDBCURL(url);
        }

        private String parseVersion(Class<?> databaseMetaDataClass, Object databaseMetaData) {
            return (String)cache.invokeMethod(databaseMetaDataClass, GET_DATABASE_PRODUCT_VERSION, null, databaseMetaData, null, null);
        }

        private String parseProduct(Class<?> databaseMetaDataClass, Object databaseMetaData) {
            return (String)cache.invokeMethod(databaseMetaDataClass, GET_DATABASE_PRODUCT_NAME, null, databaseMetaData, null, null);
        }
    }

    public static class ConnectionMetaData {
        public String url;
        public String product;
        public String version;
    }
}

