/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.sensor.method.invocationsequence;

import info.novatec.inspectit.agent.buffer.IBufferStrategy;
import info.novatec.inspectit.agent.config.IPropertyAccessor;
import info.novatec.inspectit.agent.config.impl.MethodSensorTypeConfig;
import info.novatec.inspectit.agent.config.impl.PlatformSensorTypeConfig;
import info.novatec.inspectit.agent.config.impl.RegisteredSensorConfig;
import info.novatec.inspectit.agent.core.ICoreService;
import info.novatec.inspectit.agent.core.IIdManager;
import info.novatec.inspectit.agent.core.IObjectStorage;
import info.novatec.inspectit.agent.core.IdNotAvailableException;
import info.novatec.inspectit.agent.core.ListListener;
import info.novatec.inspectit.agent.hooking.IConstructorHook;
import info.novatec.inspectit.agent.hooking.IMethodHook;
import info.novatec.inspectit.agent.sending.ISendingStrategy;
import info.novatec.inspectit.agent.sensor.exception.ExceptionSensor;
import info.novatec.inspectit.agent.sensor.method.invocationsequence.UnsupportedMethodException;
import info.novatec.inspectit.agent.sensor.method.jdbc.ConnectionSensor;
import info.novatec.inspectit.agent.sensor.method.jdbc.PreparedStatementParameterSensor;
import info.novatec.inspectit.agent.sensor.method.jdbc.PreparedStatementSensor;
import info.novatec.inspectit.agent.sensor.method.logging.Log4JLoggingSensor;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.MethodSensorData;
import info.novatec.inspectit.communication.SystemSensorData;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.communication.data.HttpTimerData;
import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.communication.data.InvocationSequenceDataHelper;
import info.novatec.inspectit.communication.data.JmxSensorValueData;
import info.novatec.inspectit.communication.data.LoggingData;
import info.novatec.inspectit.communication.data.ParameterContentData;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.communication.data.TimerData;
import info.novatec.inspectit.util.StringConstraint;
import info.novatec.inspectit.util.ThreadLocalStack;
import info.novatec.inspectit.util.Timer;
import java.net.ConnectException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationSequenceHook
implements IMethodHook,
IConstructorHook,
ICoreService {
    private static final Logger LOG = LoggerFactory.getLogger(InvocationSequenceHook.class);
    private final IIdManager idManager;
    private final IPropertyAccessor propertyAccessor;
    private final ThreadLocal<InvocationSequenceData> threadLocalInvocationData = new ThreadLocal();
    private final ThreadLocal<Long> invocationStartId = new ThreadLocal();
    private final ThreadLocal<Long> invocationStartIdCount = new ThreadLocal();
    private final Timer timer;
    private final ThreadLocalStack<Double> timeStack = new ThreadLocalStack();
    private final Map<Long, Double> minDurationMap = new HashMap<Long, Double>();
    private final StringConstraint strConstraint;
    private final boolean enhancedExceptionSensor;

    public InvocationSequenceHook(Timer timer, IIdManager idManager, IPropertyAccessor propertyAccessor, Map<String, Object> param, boolean enhancedExceptionSensor) {
        this.timer = timer;
        this.idManager = idManager;
        this.propertyAccessor = propertyAccessor;
        this.strConstraint = new StringConstraint(param);
        this.enhancedExceptionSensor = enhancedExceptionSensor;
    }

    @Override
    public void beforeBody(long methodId, long sensorTypeId, Object object, Object[] parameters, RegisteredSensorConfig rsc) {
        block6: {
            if (this.skip(rsc)) {
                return;
            }
            try {
                long platformId = this.idManager.getPlatformId();
                Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                long registeredMethodId = this.idManager.getRegisteredMethodId(methodId);
                if (null == this.threadLocalInvocationData.get()) {
                    long registeredSensorTypeId = this.idManager.getRegisteredSensorTypeId(sensorTypeId);
                    this.timeStack.push(new Double(this.timer.getCurrentTime()));
                    InvocationSequenceData invocationSequenceData = new InvocationSequenceData(timestamp, platformId, registeredSensorTypeId, registeredMethodId);
                    this.threadLocalInvocationData.set(invocationSequenceData);
                    this.invocationStartId.set(methodId);
                    this.invocationStartIdCount.set(1L);
                } else {
                    if (methodId == this.invocationStartId.get()) {
                        long count = this.invocationStartIdCount.get();
                        this.invocationStartIdCount.set(count + 1L);
                    }
                    InvocationSequenceData invocationSequenceData = this.threadLocalInvocationData.get();
                    invocationSequenceData.setChildCount(invocationSequenceData.getChildCount() + 1L);
                    InvocationSequenceData nestedInvocationSequenceData = new InvocationSequenceData(timestamp, platformId, invocationSequenceData.getSensorTypeIdent(), registeredMethodId);
                    nestedInvocationSequenceData.setStart(this.timer.getCurrentTime());
                    nestedInvocationSequenceData.setParentSequence(invocationSequenceData);
                    invocationSequenceData.getNestedSequences().add(nestedInvocationSequenceData);
                    this.threadLocalInvocationData.set(nestedInvocationSequenceData);
                }
            }
            catch (IdNotAvailableException idNotAvailableException) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug("Could not start invocation sequence because of a (currently) not mapped ID");
            }
        }
    }

    @Override
    public void firstAfterBody(long methodId, long sensorTypeId, Object object, Object[] parameters, Object result, RegisteredSensorConfig rsc) {
        if (this.skip(rsc)) {
            return;
        }
        InvocationSequenceData invocationSequenceData = this.threadLocalInvocationData.get();
        if (null != invocationSequenceData && methodId == this.invocationStartId.get()) {
            long count = this.invocationStartIdCount.get();
            this.invocationStartIdCount.set(count - 1L);
            if (0L == count - 1L) {
                this.timeStack.push(new Double(this.timer.getCurrentTime()));
            }
        }
    }

    @Override
    public void secondAfterBody(ICoreService coreService, long methodId, long sensorTypeId, Object object, Object[] parameters, Object result, RegisteredSensorConfig rsc) {
        if (this.skip(rsc)) {
            return;
        }
        InvocationSequenceData invocationSequenceData = this.threadLocalInvocationData.get();
        if (null != invocationSequenceData) {
            if (rsc.isPropertyAccess()) {
                List<ParameterContentData> parameterContentData = this.propertyAccessor.getParameterContentData(rsc.getPropertyAccessorList(), object, parameters, result);
                for (ParameterContentData contentData : parameterContentData) {
                    contentData.setContent(this.strConstraint.crop(contentData.getContent()));
                }
            }
            if (methodId == this.invocationStartId.get() && 0L == this.invocationStartIdCount.get()) {
                double endTime = this.timeStack.pop();
                double startTime = this.timeStack.pop();
                double duration = endTime - startTime;
                if (this.minDurationMap.containsKey(this.invocationStartId.get())) {
                    this.checkForSavingOrNot(coreService, methodId, sensorTypeId, rsc, invocationSequenceData, startTime, endTime, duration);
                } else if (rsc.getSettings().containsKey("minduration")) {
                    this.minDurationMap.put(this.invocationStartId.get(), Double.valueOf((String)rsc.getSettings().get("minduration")));
                    this.checkForSavingOrNot(coreService, methodId, sensorTypeId, rsc, invocationSequenceData, startTime, endTime, duration);
                } else {
                    invocationSequenceData.setDuration(duration);
                    invocationSequenceData.setStart(startTime);
                    invocationSequenceData.setEnd(endTime);
                    coreService.addMethodSensorData(sensorTypeId, methodId, String.valueOf(startTime), (MethodSensorData)invocationSequenceData);
                }
                this.threadLocalInvocationData.set(null);
            } else {
                try {
                    long registeredId = this.idManager.getRegisteredMethodId(methodId);
                    if (registeredId != invocationSequenceData.getMethodIdent()) {
                        return;
                    }
                }
                catch (IdNotAvailableException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Skipping end of invocation sequence because of a (currently) not mapped ID");
                    }
                    return;
                }
                InvocationSequenceData parentSequence = invocationSequenceData.getParentSequence();
                if (this.removeDueToExceptionDelegation(rsc, invocationSequenceData) || this.removeDueToWrappedSqls(rsc, invocationSequenceData) || this.removeDueToNotCapturedLogging(rsc, invocationSequenceData)) {
                    parentSequence.getNestedSequences().remove(invocationSequenceData);
                    parentSequence.setChildCount(parentSequence.getChildCount() - 1L);
                    if (CollectionUtils.isNotEmpty((Collection)invocationSequenceData.getNestedSequences())) {
                        for (InvocationSequenceData child : invocationSequenceData.getNestedSequences()) {
                            child.setParentSequence(parentSequence);
                            parentSequence.getNestedSequences().add(child);
                        }
                        parentSequence.setChildCount(parentSequence.getChildCount() + invocationSequenceData.getChildCount());
                    }
                } else {
                    invocationSequenceData.setEnd(this.timer.getCurrentTime());
                    invocationSequenceData.setDuration(invocationSequenceData.getEnd() - invocationSequenceData.getStart());
                    parentSequence.setChildCount(parentSequence.getChildCount() + invocationSequenceData.getChildCount());
                }
                this.threadLocalInvocationData.set(parentSequence);
            }
        }
    }

    private boolean removeDueToExceptionDelegation(RegisteredSensorConfig rsc, InvocationSequenceData invocationSequenceData) {
        if (1 == rsc.getSensorTypeConfigs().size()) {
            MethodSensorTypeConfig methodSensorTypeConfig = rsc.getSensorTypeConfigs().get(0);
            if (ExceptionSensor.class.getCanonicalName().equals(methodSensorTypeConfig.getClassName())) {
                return CollectionUtils.isEmpty((Collection)invocationSequenceData.getExceptionSensorDataObjects());
            }
        }
        return false;
    }

    private boolean removeDueToWrappedSqls(RegisteredSensorConfig rsc, InvocationSequenceData invocationSequenceData) {
        if (1 == rsc.getSensorTypeConfigs().size() || 2 == rsc.getSensorTypeConfigs().size() && this.enhancedExceptionSensor) {
            for (MethodSensorTypeConfig methodSensorTypeConfig : rsc.getSensorTypeConfigs()) {
                if (!PreparedStatementSensor.class.getCanonicalName().equals(methodSensorTypeConfig.getClassName()) || null != invocationSequenceData.getSqlStatementData() && 0L != invocationSequenceData.getSqlStatementData().getCount()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean removeDueToNotCapturedLogging(RegisteredSensorConfig rsc, InvocationSequenceData invocationSequenceData) {
        if (1 == rsc.getSensorTypeConfigs().size() || 2 == rsc.getSensorTypeConfigs().size() && this.enhancedExceptionSensor) {
            for (MethodSensorTypeConfig methodSensorTypeConfig : rsc.getSensorTypeConfigs()) {
                if (!Log4JLoggingSensor.class.getCanonicalName().equals(methodSensorTypeConfig.getClassName())) continue;
                return !InvocationSequenceDataHelper.hasLoggingData((InvocationSequenceData)invocationSequenceData);
            }
        }
        return false;
    }

    private boolean skip(RegisteredSensorConfig rsc) {
        if (1 == rsc.getSensorTypeConfigs().size() || 2 == rsc.getSensorTypeConfigs().size() && this.enhancedExceptionSensor) {
            for (MethodSensorTypeConfig methodSensorTypeConfig : rsc.getSensorTypeConfigs()) {
                if (PreparedStatementParameterSensor.class.getCanonicalName().equals(methodSensorTypeConfig.getClassName())) {
                    return true;
                }
                if (!ConnectionSensor.class.getCanonicalName().equals(methodSensorTypeConfig.getClassName())) continue;
                return true;
            }
        }
        return false;
    }

    private void checkForSavingOrNot(ICoreService coreService, long methodId, long sensorTypeId, RegisteredSensorConfig rsc, InvocationSequenceData invocationSequenceData, double startTime, double endTime, double duration) {
        double minduration = this.minDurationMap.get(this.invocationStartId.get());
        if (duration >= minduration) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Saving invocation. " + duration + " > " + minduration + " ID(local): " + rsc.getId());
            }
            invocationSequenceData.setDuration(duration);
            invocationSequenceData.setStart(startTime);
            invocationSequenceData.setEnd(endTime);
            coreService.addMethodSensorData(sensorTypeId, methodId, String.valueOf(startTime), (MethodSensorData)invocationSequenceData);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Not saving invocation. " + duration + " < " + minduration + " ID(local): " + rsc.getId());
        }
    }

    @Override
    public void beforeConstructor(long methodId, long sensorTypeId, Object[] parameters, RegisteredSensorConfig rsc) {
        this.beforeBody(methodId, sensorTypeId, null, parameters, rsc);
    }

    @Override
    public void afterConstructor(ICoreService coreService, long methodId, long sensorTypeId, Object object, Object[] parameters, RegisteredSensorConfig rsc) {
        this.firstAfterBody(methodId, sensorTypeId, object, parameters, null, rsc);
        this.secondAfterBody(coreService, methodId, sensorTypeId, object, parameters, null, rsc);
    }

    private void saveDataObject(DefaultData dataObject) {
        InvocationSequenceData invocationSequenceData = this.threadLocalInvocationData.get();
        if (dataObject.getClass().equals(SqlStatementData.class) && null == invocationSequenceData.getSqlStatementData()) {
            invocationSequenceData.setSqlStatementData((SqlStatementData)dataObject);
        }
        if (dataObject.getClass().equals(HttpTimerData.class) && (null == invocationSequenceData.getTimerData() || invocationSequenceData.getTimerData().getClass().equals(TimerData.class))) {
            invocationSequenceData.setTimerData((TimerData)((HttpTimerData)dataObject));
        }
        if (dataObject.getClass().equals(TimerData.class) && null == invocationSequenceData.getTimerData()) {
            invocationSequenceData.setTimerData((TimerData)dataObject);
        }
        if (dataObject.getClass().equals(ExceptionSensorData.class)) {
            ExceptionSensorData exceptionSensorData = (ExceptionSensorData)dataObject;
            invocationSequenceData.addExceptionSensorData(exceptionSensorData);
        }
        if (dataObject.getClass().equals(LoggingData.class)) {
            LoggingData loggingData = (LoggingData)dataObject;
            invocationSequenceData.setLoggingData(loggingData);
        }
    }

    @Override
    public void addMethodSensorData(long sensorTypeId, long methodId, String prefix, MethodSensorData methodSensorData) {
        if (null == this.threadLocalInvocationData.get()) {
            LOG.error("thread data NULL!!!!");
            return;
        }
        this.saveDataObject(methodSensorData.finalizeData());
    }

    @Override
    public void addObjectStorage(long sensorTypeId, long methodId, String prefix, IObjectStorage objectStorage) {
        if (null == this.threadLocalInvocationData.get()) {
            LOG.error("thread data NULL!!!!");
            return;
        }
        DefaultData defaultData = objectStorage.finalizeDataObject();
        this.saveDataObject(defaultData.finalizeData());
    }

    @Override
    public void addPlatformSensorData(long sensorTypeIdent, SystemSensorData systemSensorData) {
        this.saveDataObject(systemSensorData.finalizeData());
    }

    @Override
    public void addExceptionSensorData(long sensorTypeIdent, long throwableIdentityHashCode, ExceptionSensorData exceptionSensorData) {
        if (null == this.threadLocalInvocationData.get()) {
            LOG.info("thread data NULL!!!!");
            return;
        }
        this.saveDataObject(exceptionSensorData.finalizeData());
    }

    @Override
    public ExceptionSensorData getExceptionSensorData(long sensorTypeIdent, long throwableIdentityHashCode) {
        return null;
    }

    @Override
    public MethodSensorData getMethodSensorData(long sensorTypeIdent, long methodIdent, String prefix) {
        return null;
    }

    @Override
    public IObjectStorage getObjectStorage(long sensorTypeIdent, long methodIdent, String prefix) {
        return null;
    }

    @Override
    public SystemSensorData getPlatformSensorData(long sensorTypeIdent) {
        return null;
    }

    @Override
    public void addListListener(ListListener<?> listener) {
        throw new UnsupportedMethodException();
    }

    public void addSendStrategy(ISendingStrategy strategy) {
        throw new UnsupportedMethodException();
    }

    public void connect() throws ConnectException {
        throw new UnsupportedMethodException();
    }

    @Override
    public void removeListListener(ListListener<?> listener) {
        throw new UnsupportedMethodException();
    }

    @Override
    public void sendData() {
        throw new UnsupportedMethodException();
    }

    public void setBufferStrategy(IBufferStrategy<DefaultData> bufferStrategy) {
        throw new UnsupportedMethodException();
    }

    public void startSendingStrategies() {
        throw new UnsupportedMethodException();
    }

    public void addPlatformSensorType(PlatformSensorTypeConfig platformSensorTypeConfig) {
        throw new UnsupportedMethodException();
    }

    @Override
    public void start() {
        throw new UnsupportedMethodException();
    }

    @Override
    public void stop() {
        throw new UnsupportedMethodException();
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        throw new UnsupportedMethodException();
    }

    @Override
    public void addJmxSensorValueData(long sensorTypeIdent, String objectName, String attributeName, JmxSensorValueData jmxSensorValueData) {
        throw new UnsupportedMethodException();
    }
}

