/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.sensor.method.http;

import info.novatec.inspectit.util.StringConstraint;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HttpRequestParameterExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(HttpRequestParameterExtractor.class);
    private StringConstraint strConstraint;
    private Method markerMethod;
    private ConcurrentHashMap<String, Method> methodCache = new ConcurrentHashMap();

    public HttpRequestParameterExtractor(StringConstraint strConstraint) {
        this.strConstraint = strConstraint;
        try {
            this.markerMethod = Object.class.getMethod("toString", new Class[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Method toString() can not be found", e);
        }
    }

    public String getRequestUri(Class<?> httpServletRequestClass, Object httpServletRequest) {
        Method m = this.retrieveMethod(HttpMethods.SERVLET_REQUEST_URI, httpServletRequestClass);
        if (null == m) {
            return "n.a.";
        }
        try {
            String uri = (String)m.invoke(httpServletRequest, (Object[])null);
            if (null != uri) {
                return uri;
            }
            return "n.a.";
        }
        catch (Exception e) {
            LOG.error("Invocation on given object failed.", (Throwable)e);
            return "n.a.";
        }
    }

    public String getRequestMethod(Class<?> httpServletRequestClass, Object httpServletRequest) {
        Method m = this.retrieveMethod(HttpMethods.SERVLET_GET_METHOD, httpServletRequestClass);
        if (null == m) {
            return "n.a.";
        }
        try {
            String requestMethod = (String)m.invoke(httpServletRequest, (Object[])null);
            if (null != requestMethod) {
                return requestMethod;
            }
            return "n.a.";
        }
        catch (Exception e) {
            LOG.error("Invocation on given object failed.", (Throwable)e);
            return "n.a.";
        }
    }

    public Map<String, String[]> getParameterMap(Class<?> httpServletRequestClass, Object httpServletRequest) {
        Method m = this.retrieveMethod(HttpMethods.SERVLET_GET_PARAMETER_MAP, httpServletRequestClass);
        if (null == m) {
            return null;
        }
        try {
            Map parameterMap = (Map)m.invoke(httpServletRequest, (Object[])null);
            if (null == parameterMap || parameterMap.isEmpty()) {
                return null;
            }
            return this.strConstraint.crop(parameterMap);
        }
        catch (Exception e) {
            LOG.error("Invocation on given object failed.", (Throwable)e);
            return null;
        }
    }

    public Map<String, String> getAttributes(Class<?> httpServletRequestClass, Object httpServletRequest) {
        Method attributesMethod = this.retrieveMethod(HttpMethods.SERVLET_GET_ATTRIBUTE_NAMES, httpServletRequestClass);
        if (null == attributesMethod) {
            return null;
        }
        Method attributeValue = this.retrieveMethod(HttpMethods.SERVLET_GET_ATTRIBUTE, httpServletRequestClass);
        if (null == attributeValue) {
            return null;
        }
        try {
            Enumeration params = (Enumeration)attributesMethod.invoke(httpServletRequest, (Object[])null);
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (null == params) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Attribute enumeration was <null>");
                }
                return null;
            }
            while (params.hasMoreElements()) {
                String attrName = (String)params.nextElement();
                Object value = attributeValue.invoke(httpServletRequest, attrName);
                attributes.put(attrName, this.strConstraint.crop(this.getAttributeValue(value)));
            }
            return attributes;
        }
        catch (Exception e) {
            LOG.error("Invocation of " + attributesMethod.getName() + " to get attributes on given object failed.", (Throwable)e);
            return null;
        }
    }

    public Map<String, String> getHeaders(Class<?> httpServletRequestClass, Object httpServletRequest) {
        Method headerNamesMethod = this.retrieveMethod(HttpMethods.SERVLET_GET_HEADER_NAMES, httpServletRequestClass);
        if (null == headerNamesMethod) {
            return null;
        }
        Method headerValueMethod = this.retrieveMethod(HttpMethods.SERVLET_GET_HEADER, httpServletRequestClass);
        if (null == headerValueMethod) {
            return null;
        }
        try {
            Enumeration headers = (Enumeration)headerNamesMethod.invoke(httpServletRequest, (Object[])null);
            HashMap<String, String> headersResult = new HashMap<String, String>();
            if (headers != null) {
                while (headers.hasMoreElements()) {
                    String headerName = (String)headers.nextElement();
                    String headerValue = (String)headerValueMethod.invoke(httpServletRequest, headerName);
                    headersResult.put(headerName, this.strConstraint.crop(headerValue));
                }
                return headersResult;
            }
        }
        catch (Exception e) {
            LOG.error("Invocation of to get attributes on given object failed.", (Throwable)e);
        }
        return null;
    }

    public Map<String, String> getSessionAttributes(Class<?> httpServletRequestClass, Object httpServletRequest) {
        Class<?> httpSessionClass;
        Object httpSession;
        Method getSessionMethod = this.retrieveMethod(HttpMethods.SERVLET_GET_SESSION, httpServletRequestClass);
        if (null == getSessionMethod) {
            return null;
        }
        try {
            httpSession = getSessionMethod.invoke(httpServletRequest, Boolean.FALSE);
            if (httpSession == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No session can be found");
                }
                return null;
            }
            httpSessionClass = httpSession.getClass();
        }
        catch (Exception e) {
            LOG.error("Invocation of to get attributes on given object failed.", (Throwable)e);
            return null;
        }
        Method getAttributeNamesSession = this.retrieveMethod(HttpMethods.SESSION_GET_ATTRIBUTE_NAMES, httpSessionClass);
        if (null == getAttributeNamesSession) {
            return null;
        }
        Method getAttributeValueSession = this.retrieveMethod(HttpMethods.SESSION_GET_ATTRIBUTE, httpSessionClass);
        if (null == getAttributeValueSession) {
            return null;
        }
        try {
            Enumeration sessionAttr = (Enumeration)getAttributeNamesSession.invoke(httpSession, (Object[])null);
            HashMap<String, String> sessionAttributes = new HashMap<String, String>();
            if (null != sessionAttr) {
                while (sessionAttr.hasMoreElements()) {
                    String sessionAtt = (String)sessionAttr.nextElement();
                    Object sessionValue = getAttributeValueSession.invoke(httpSession, sessionAtt);
                    sessionAttributes.put(sessionAtt, this.strConstraint.crop(this.getAttributeValue(sessionValue)));
                }
                return sessionAttributes;
            }
        }
        catch (Exception e) {
            LOG.error("Invocation of to get attributes on given object failed.", (Throwable)e);
        }
        return null;
    }

    private Method retrieveMethod(HttpMethods httpMethod, Class<?> clazzUsedToLookup) {
        String cacheLookupName = this.getCacheLookupName(httpMethod, clazzUsedToLookup);
        Method m = this.methodCache.get(cacheLookupName);
        if (null == m) {
            try {
                m = clazzUsedToLookup.getMethod(httpMethod.methodName, httpMethod.parameters);
                m.setAccessible(true);
                Method existing = this.methodCache.putIfAbsent(cacheLookupName, m);
                if (null != existing) {
                    m = existing;
                }
            }
            catch (Exception e) {
                LOG.error("The provided class " + clazzUsedToLookup.getCanonicalName() + " did not provide the desired method.", (Throwable)e);
                this.methodCache.putIfAbsent(cacheLookupName, this.markerMethod);
            }
        } else if (this.markerMethod.equals(m)) {
            return null;
        }
        return m;
    }

    private String getCacheLookupName(HttpMethods httpMethod, Class<?> clazz) {
        return clazz.getCanonicalName() + '#' + httpMethod.methodName;
    }

    private String getAttributeValue(Object attribute) {
        if (null == attribute) {
            return "<notset>";
        }
        if (attribute.getClass().isArray()) {
            StringBuilder stringBuilder = new StringBuilder("[");
            boolean isFirst = true;
            int length = Array.getLength(attribute);
            for (int i = 0; i < length; ++i) {
                if (isFirst) {
                    stringBuilder.append(Array.get(attribute, i));
                    isFirst = false;
                    continue;
                }
                stringBuilder.append(", ");
                stringBuilder.append(Array.get(attribute, i));
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
        return attribute.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum HttpMethods {
        SERVLET_REQUEST_URI("getRequestURI", null),
        SERVLET_GET_PARAMETER_MAP("getParameterMap", null),
        SERVLET_GET_ATTRIBUTE_NAMES("getAttributeNames", null),
        SERVLET_GET_ATTRIBUTE("getAttribute", new Class[]{String.class}),
        SERVLET_GET_HEADER_NAMES("getHeaderNames", null),
        SERVLET_GET_HEADER("getHeader", new Class[]{String.class}),
        SERVLET_GET_SESSION("getSession", new Class[]{Boolean.TYPE}),
        SERVLET_GET_METHOD("getMethod", null),
        SESSION_GET_ATTRIBUTE_NAMES("getAttributeNames", null),
        SESSION_GET_ATTRIBUTE("getAttribute", new Class[]{String.class});

        private String methodName;
        private Class<?>[] parameters;

        private HttpMethods(String methodName, Class<?>[] parameters) {
            this.methodName = methodName;
            this.parameters = parameters;
        }
    }
}

