/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.sensor.method.http;

import info.novatec.inspectit.agent.config.impl.RegisteredSensorConfig;
import info.novatec.inspectit.agent.core.ICoreService;
import info.novatec.inspectit.agent.core.IIdManager;
import info.novatec.inspectit.agent.core.IdNotAvailableException;
import info.novatec.inspectit.agent.hooking.IMethodHook;
import info.novatec.inspectit.agent.sensor.method.http.HttpRequestParameterExtractor;
import info.novatec.inspectit.agent.sensor.method.http.StartEndMarker;
import info.novatec.inspectit.communication.MethodSensorData;
import info.novatec.inspectit.communication.data.HttpTimerData;
import info.novatec.inspectit.util.StringConstraint;
import info.novatec.inspectit.util.ThreadLocalStack;
import info.novatec.inspectit.util.Timer;
import java.lang.management.ThreadMXBean;
import java.sql.Timestamp;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpHook
implements IMethodHook {
    private static final Logger LOG = LoggerFactory.getLogger(HttpHook.class);
    private final ThreadLocalStack<Double> timeStack = new ThreadLocalStack();
    private final Timer timer;
    private final IIdManager idManager;
    private ThreadMXBean threadMXBean;
    private boolean threadCPUTimeJMXAvailable = false;
    private boolean threadCPUTimeEnabled = false;
    private final ThreadLocalStack<Long> threadCpuTimeStack = new ThreadLocalStack();
    private HttpRequestParameterExtractor extractor;
    private final boolean captureSessionData;
    private static final String HTTP_SERVLET_REQUEST_CLASS = "javax.servlet.http.HttpServletRequest";
    private static final String OBJECT_CLASS = Object.class.getName();
    private static final CopyOnWriteArrayList<Class<?>> WHITE_LIST = new CopyOnWriteArrayList();
    private static final CopyOnWriteArrayList<Class<?>> BLACK_LIST = new CopyOnWriteArrayList();
    private final StartEndMarker refMarker = new StartEndMarker();

    public HttpHook(Timer timer, IIdManager idManager, Map<String, Object> parameters, ThreadMXBean threadMXBean) {
        this.timer = timer;
        this.idManager = idManager;
        this.threadMXBean = threadMXBean;
        this.extractor = new HttpRequestParameterExtractor(new StringConstraint(parameters));
        if (null != parameters && "true".equals(parameters.get("sessioncapture"))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Enabling session capturing for the http sensor");
            }
            this.captureSessionData = true;
        } else {
            this.captureSessionData = false;
        }
        try {
            this.threadCPUTimeJMXAvailable = threadMXBean.isThreadCpuTimeSupported();
            if (this.threadCPUTimeJMXAvailable) {
                this.threadCPUTimeEnabled = threadMXBean.isThreadCpuTimeEnabled();
                if (!this.threadCPUTimeEnabled) {
                    threadMXBean.setThreadCpuTimeEnabled(true);
                    this.threadCPUTimeEnabled = threadMXBean.isThreadCpuTimeEnabled();
                }
            }
        }
        catch (RuntimeException e) {
            LOG.warn("Your environment does not support to capture CPU timings.");
        }
    }

    @Override
    public void beforeBody(long methodId, long sensorTypeId, Object object, Object[] parameters, RegisteredSensorConfig rsc) {
        if (!this.refMarker.isMarkerSet()) {
            Object httpServletRequest;
            Class<?> servletRequestClass;
            if (parameters.length != 0 && this.providesHttpMetrics(servletRequestClass = (httpServletRequest = parameters[0]).getClass())) {
                this.timeStack.push(new Double(this.timer.getCurrentTime()));
                if (this.threadCPUTimeEnabled) {
                    this.threadCpuTimeStack.push(this.threadMXBean.getCurrentThreadCpuTime());
                }
                this.refMarker.markCall();
            }
        } else {
            this.refMarker.markCall();
        }
    }

    @Override
    public void firstAfterBody(long methodId, long sensorTypeId, Object object, Object[] parameters, Object result, RegisteredSensorConfig rsc) {
        if (!this.refMarker.isMarkerSet()) {
            return;
        }
        this.refMarker.markEndCall();
        if (this.refMarker.matchesFirst()) {
            this.timeStack.push(new Double(this.timer.getCurrentTime()));
            if (this.threadCPUTimeEnabled) {
                this.threadCpuTimeStack.push(this.threadMXBean.getCurrentThreadCpuTime());
            }
        }
    }

    @Override
    public void secondAfterBody(ICoreService coreService, long methodId, long sensorTypeId, Object object, Object[] parameters, Object result, RegisteredSensorConfig rsc) {
        block6: {
            if (this.refMarker.isMarkerSet() && this.refMarker.matchesFirst()) {
                Object httpServletRequest;
                Class<?> servletRequestClass;
                this.refMarker.remove();
                if (parameters.length != 0 && this.providesHttpMetrics(servletRequestClass = (httpServletRequest = parameters[0]).getClass())) {
                    try {
                        double endTime = this.timeStack.pop();
                        double startTime = this.timeStack.pop();
                        double duration = endTime - startTime;
                        double cpuDuration = -1.0;
                        if (this.threadCPUTimeEnabled) {
                            long cpuEndTime = this.threadCpuTimeStack.pop();
                            long cpuStartTime = this.threadCpuTimeStack.pop();
                            cpuDuration = (double)(cpuEndTime - cpuStartTime) / 1000000.0;
                        }
                        long platformId = this.idManager.getPlatformId();
                        long registeredSensorTypeId = this.idManager.getRegisteredSensorTypeId(sensorTypeId);
                        long registeredMethodId = this.idManager.getRegisteredMethodId(methodId);
                        Timestamp timestamp = new Timestamp(System.currentTimeMillis() - Math.round(duration));
                        HttpTimerData data = new HttpTimerData();
                        data.setPlatformIdent(platformId);
                        data.setMethodIdent(registeredMethodId);
                        data.setSensorTypeIdent(registeredSensorTypeId);
                        data.setTimeStamp(timestamp);
                        data.setDuration(duration);
                        data.calculateMin(duration);
                        data.calculateMax(duration);
                        data.setCpuDuration(cpuDuration);
                        data.calculateCpuMax(cpuDuration);
                        data.calculateCpuMin(cpuDuration);
                        data.setCount(1L);
                        data.getHttpInfo().setUri(this.extractor.getRequestUri(servletRequestClass, httpServletRequest));
                        data.getHttpInfo().setRequestMethod(this.extractor.getRequestMethod(servletRequestClass, httpServletRequest));
                        data.setParameters(this.extractor.getParameterMap(servletRequestClass, httpServletRequest));
                        data.setAttributes(this.extractor.getAttributes(servletRequestClass, httpServletRequest));
                        data.setHeaders(this.extractor.getHeaders(servletRequestClass, httpServletRequest));
                        if (this.captureSessionData) {
                            data.setSessionAttributes(this.extractor.getSessionAttributes(servletRequestClass, httpServletRequest));
                        }
                        boolean charting = "true".equals(rsc.getSettings().get("charting"));
                        data.setCharting(charting);
                        coreService.addMethodSensorData(registeredSensorTypeId, registeredMethodId, null, (MethodSensorData)data);
                    }
                    catch (IdNotAvailableException e) {
                        if (!LOG.isDebugEnabled()) break block6;
                        LOG.debug("Could not save the timer data because of an unavailable id. " + e.getMessage());
                    }
                }
            }
        }
    }

    private boolean providesHttpMetrics(Class<?> c) {
        if (WHITE_LIST.contains(c)) {
            return true;
        }
        if (BLACK_LIST.contains(c)) {
            return false;
        }
        boolean realizesInterface = this.checkForInterface(c, HTTP_SERVLET_REQUEST_CLASS);
        if (realizesInterface) {
            WHITE_LIST.addIfAbsent(c);
        } else {
            BLACK_LIST.addIfAbsent(c);
        }
        return realizesInterface;
    }

    private boolean checkForInterface(Class<?> c, String interfaceName) {
        if (c.getName().equals(OBJECT_CLASS)) {
            return false;
        }
        for (Class<?> clazz : c.getInterfaces()) {
            if (!clazz.getName().equals(interfaceName)) continue;
            return true;
        }
        return this.checkForInterface(c.getSuperclass(), interfaceName);
    }
}

