/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.sensor.method.averagetimer;

import info.novatec.inspectit.agent.config.IPropertyAccessor;
import info.novatec.inspectit.agent.config.impl.RegisteredSensorConfig;
import info.novatec.inspectit.agent.core.ICoreService;
import info.novatec.inspectit.agent.core.IIdManager;
import info.novatec.inspectit.agent.core.IdNotAvailableException;
import info.novatec.inspectit.agent.hooking.IConstructorHook;
import info.novatec.inspectit.agent.hooking.IMethodHook;
import info.novatec.inspectit.communication.MethodSensorData;
import info.novatec.inspectit.communication.data.ParameterContentData;
import info.novatec.inspectit.communication.data.TimerData;
import info.novatec.inspectit.util.StringConstraint;
import info.novatec.inspectit.util.ThreadLocalStack;
import info.novatec.inspectit.util.Timer;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AverageTimerHook
implements IMethodHook,
IConstructorHook {
    private static final Logger LOG = LoggerFactory.getLogger(AverageTimerHook.class);
    private ThreadLocalStack<Double> timeStack = new ThreadLocalStack();
    private final Timer timer;
    private final IIdManager idManager;
    private final IPropertyAccessor propertyAccessor;
    private StringConstraint strConstraint;

    public AverageTimerHook(Timer timer, IIdManager idManager, IPropertyAccessor propertyAccessor, Map<String, Object> param) {
        this.timer = timer;
        this.idManager = idManager;
        this.propertyAccessor = propertyAccessor;
        this.strConstraint = new StringConstraint(param);
    }

    @Override
    public void beforeBody(long methodId, long sensorTypeId, Object object, Object[] parameters, RegisteredSensorConfig rsc) {
        this.timeStack.push(new Double(this.timer.getCurrentTime()));
    }

    @Override
    public void firstAfterBody(long methodId, long sensorTypeId, Object object, Object[] parameters, Object result, RegisteredSensorConfig rsc) {
        this.timeStack.push(new Double(this.timer.getCurrentTime()));
    }

    @Override
    public void secondAfterBody(ICoreService coreService, long methodId, long sensorTypeId, Object object, Object[] parameters, Object result, RegisteredSensorConfig rsc) {
        TimerData timerData;
        double endTime = this.timeStack.pop();
        double startTime = this.timeStack.pop();
        double duration = endTime - startTime;
        List<ParameterContentData> parameterContentData = null;
        String prefix = null;
        if (rsc.isPropertyAccess()) {
            parameterContentData = this.propertyAccessor.getParameterContentData(rsc.getPropertyAccessorList(), object, parameters, result);
            prefix = parameterContentData.toString();
            for (ParameterContentData contentData : parameterContentData) {
                contentData.setContent(this.strConstraint.crop(contentData.getContent()));
            }
        }
        if (null == (timerData = (TimerData)coreService.getMethodSensorData(sensorTypeId, methodId, prefix))) {
            try {
                long platformId = this.idManager.getPlatformId();
                long registeredSensorTypeId = this.idManager.getRegisteredSensorTypeId(sensorTypeId);
                long registeredMethodId = this.idManager.getRegisteredMethodId(methodId);
                Timestamp timestamp = new Timestamp(System.currentTimeMillis() - Math.round(duration));
                timerData = new TimerData(timestamp, platformId, registeredSensorTypeId, registeredMethodId, parameterContentData);
                timerData.increaseCount();
                timerData.addDuration(duration);
                timerData.calculateMin(duration);
                timerData.calculateMax(duration);
                coreService.addMethodSensorData(sensorTypeId, methodId, prefix, (MethodSensorData)timerData);
            }
            catch (IdNotAvailableException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not save the average timer data because of an unavailable id. " + e.getMessage());
                }
            }
        } else {
            timerData.increaseCount();
            timerData.addDuration(duration);
            timerData.calculateMin(duration);
            timerData.calculateMax(duration);
        }
    }

    @Override
    public void beforeConstructor(long methodId, long sensorTypeId, Object[] parameters, RegisteredSensorConfig rsc) {
        this.timeStack.push(new Double(this.timer.getCurrentTime()));
    }

    @Override
    public void afterConstructor(ICoreService coreService, long methodId, long sensorTypeId, Object object, Object[] parameters, RegisteredSensorConfig rsc) {
        this.timeStack.push(new Double(this.timer.getCurrentTime()));
        this.secondAfterBody(coreService, methodId, sensorTypeId, object, parameters, null, rsc);
    }
}

