/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.sensor.jmx;

import info.novatec.inspectit.agent.config.IConfigurationStorage;
import info.novatec.inspectit.agent.config.impl.JmxSensorConfig;
import info.novatec.inspectit.agent.config.impl.JmxSensorTypeConfig;
import info.novatec.inspectit.agent.config.impl.UnregisteredJmxConfig;
import info.novatec.inspectit.agent.core.ICoreService;
import info.novatec.inspectit.agent.core.IIdManager;
import info.novatec.inspectit.agent.core.IdNotAvailableException;
import info.novatec.inspectit.agent.sensor.jmx.IJmxSensor;
import info.novatec.inspectit.communication.data.JmxSensorValueData;
import info.novatec.inspectit.spring.logger.Log;
import java.lang.management.ManagementFactory;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.slf4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxSensor
implements IJmxSensor,
InitializingBean {
    private static final int DATA_COLLECT_INTERVAL = 5000;
    private static final int REGISTER_BEAN_INTERVAL = 60000;
    @Log
    Logger log;
    @Autowired
    private IConfigurationStorage configurationStorage;
    @Autowired
    private IIdManager idManager;
    private MBeanServer mBeanServer;
    private List<UnregisteredJmxConfig> unregisteredJmxConfigs = new ArrayList<UnregisteredJmxConfig>();
    private final Map<String, JmxSensorConfig> registeredJmxSensorConfigs = new HashMap<String, JmxSensorConfig>();
    private final Map<String, ObjectName> nameStringToObjectName = new HashMap<String, ObjectName>();
    long lastDataCollectionTimestamp = 0L;
    long lastRegisterBeanTimestamp = 0L;
    private final Map<String, JmxSensorConfig> activeAttributes = new HashMap<String, JmxSensorConfig>();

    @Override
    public void init(Map<String, Object> parameter) {
        this.unregisteredJmxConfigs.addAll(this.configurationStorage.getUnregisteredJmxConfigs());
        this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
    }

    @Override
    public void update(ICoreService coreService, long sensorTypeIdent) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastRegisterBeanTimestamp > 60000L) {
            this.lastRegisterBeanTimestamp = System.currentTimeMillis();
            this.registerMBeans();
        }
        if (currentTime - this.lastDataCollectionTimestamp > 5000L) {
            this.lastDataCollectionTimestamp = System.currentTimeMillis();
            this.collectData(coreService, sensorTypeIdent);
        }
    }

    private void collectData(ICoreService coreService, long sensorTypeIdent) {
        Timestamp timestamp = new Timestamp(Calendar.getInstance().getTime().getTime());
        Iterator<Map.Entry<String, JmxSensorConfig>> iterator = this.activeAttributes.entrySet().iterator();
        while (iterator.hasNext()) {
            JmxSensorConfig jsc = iterator.next().getValue();
            try {
                ObjectName objectName = this.nameStringToObjectName.get(jsc.getmBeanObjectName());
                Object collectedValue = this.mBeanServer.getAttribute(objectName, jsc.getAttributeName());
                String value = collectedValue.getClass().isArray() ? Arrays.toString((Object[])collectedValue) : collectedValue.toString();
                long platformid = this.idManager.getPlatformId();
                long sensorTypeId = this.idManager.getRegisteredSensorTypeId(sensorTypeIdent);
                long registeredmBeanId = this.idManager.getRegisteredmBeanId(jsc.getId());
                JmxSensorValueData jsvd = new JmxSensorValueData(registeredmBeanId, value, timestamp, platformid, sensorTypeId);
                coreService.addJmxSensorValueData(sensorTypeIdent, jsc.getmBeanObjectName(), jsc.getAttributeName(), jsvd);
            }
            catch (AttributeNotFoundException e) {
                iterator.remove();
                this.log.warn("JMX::AttributeNotFound. Attribute was not found. Maybe currently not available on the server. Attribute removed from the actively read list.", (Throwable)e);
            }
            catch (InstanceNotFoundException e) {
                iterator.remove();
                this.log.warn("JMX::Instance not found. MBean may not be registered on the Server. Attribute removed from the actively read list.", (Throwable)e);
            }
            catch (MBeanException e) {
                iterator.remove();
                this.log.warn("JMX::MBean. Undefined problem with the MBean. Attribute removed from the actively read list.", (Throwable)e);
            }
            catch (ReflectionException e) {
                iterator.remove();
                this.log.warn("JMX::Reflection error. MBean may not be registered on the Server. Attribute removed from the actively read list.", (Throwable)e);
            }
            catch (IdNotAvailableException e) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("JMX::IdNotAvailable. MBean may not be registered on the Server.", (Throwable)e);
            }
        }
    }

    private void registerMBeans() {
        Iterator<UnregisteredJmxConfig> iterator = this.unregisteredJmxConfigs.iterator();
        while (iterator.hasNext()) {
            UnregisteredJmxConfig ujc = iterator.next();
            String objectNameExpression = ujc.getPassedObjectNameExpression();
            String attributeNameExpression = ujc.getPassedAttributeNameExpression();
            try {
                Set<ObjectName> fittingMBeans = this.mBeanServer.queryNames(new ObjectName(objectNameExpression), null);
                block6: for (ObjectName objectName : fittingMBeans) {
                    MBeanAttributeInfo[] attributes;
                    String mBeanAttributeKey = objectName + attributeNameExpression;
                    if (!this.registeredJmxSensorConfigs.containsKey(mBeanAttributeKey)) {
                        for (MBeanAttributeInfo mBeanAttributeInfo : attributes = this.mBeanServer.getMBeanInfo(objectName).getAttributes()) {
                            if (!mBeanAttributeInfo.getName().equals(attributeNameExpression)) continue;
                            JmxSensorConfig jsc = new JmxSensorConfig();
                            jsc.setJmxSensorTypeConfig(ujc.getJmxSensorTypeConfig());
                            jsc.setmBeanObjectName(objectName.toString());
                            jsc.setAttributeName(mBeanAttributeInfo.getName());
                            jsc.setmBeanAttributeDescription(mBeanAttributeInfo.getDescription());
                            jsc.setmBeanAttributeIsIs(mBeanAttributeInfo.isIs());
                            jsc.setmBeanAttributeIsReadable(mBeanAttributeInfo.isReadable());
                            jsc.setmBeanAttributeIsWritable(mBeanAttributeInfo.isWritable());
                            jsc.setmBeanAttributeType(mBeanAttributeInfo.getType());
                            this.idManager.registerJmxSensorConfig(jsc);
                            this.registeredJmxSensorConfigs.put(mBeanAttributeKey, jsc);
                            this.activeAttributes.put(mBeanAttributeKey, jsc);
                            this.nameStringToObjectName.put(objectName.toString(), objectName);
                            continue block6;
                        }
                        continue;
                    }
                    if (this.activeAttributes.containsKey(mBeanAttributeKey)) continue;
                    for (MBeanAttributeInfo mBeanAttributeInfo : attributes = this.mBeanServer.getMBeanInfo(objectName).getAttributes()) {
                        if (!mBeanAttributeInfo.getName().equals(attributeNameExpression)) continue;
                        this.activeAttributes.put(mBeanAttributeKey, this.registeredJmxSensorConfigs.get(mBeanAttributeKey));
                        continue block6;
                    }
                }
            }
            catch (MalformedObjectNameException e) {
                iterator.remove();
                this.log.warn("JMX::MalformedObjectName. '" + objectNameExpression + "' may not be registered on the Server. Removed from List.", (Throwable)e);
            }
            catch (IntrospectionException e) {
                this.log.warn("JMX::Introspection failure. MBean may not be registered on the Server.", (Throwable)e);
            }
            catch (InstanceNotFoundException e) {
                this.log.warn("JMX::Instance not found. MBean may not be registered on the Server.", (Throwable)e);
            }
            catch (ReflectionException e) {
                this.log.warn("JMX::Reflection error. MBean may not be registered on the Server.", (Throwable)e);
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        for (JmxSensorTypeConfig config : this.configurationStorage.getJmxSensorTypes()) {
            if (!config.getClassName().equals(this.getClass().getName())) continue;
            this.init(config.getParameters());
            config.setSensorType(this);
            break;
        }
    }

    void setUnregisteredJmxConfigs(List<UnregisteredJmxConfig> unregisteredJmxConfigs) {
        this.unregisteredJmxConfigs = unregisteredJmxConfigs;
    }
}

