/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.sensor.exception;

import info.novatec.inspectit.agent.config.impl.RegisteredSensorConfig;
import info.novatec.inspectit.agent.core.ICoreService;
import info.novatec.inspectit.agent.core.IIdManager;
import info.novatec.inspectit.agent.core.IdNotAvailableException;
import info.novatec.inspectit.agent.sensor.exception.IExceptionSensorHook;
import info.novatec.inspectit.agent.sensor.exception.IdentityHashToDataObject;
import info.novatec.inspectit.communication.ExceptionEvent;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.util.StringConstraint;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionSensorHook
implements IExceptionSensorHook {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionSensorHook.class);
    private final IIdManager idManager;
    private ThreadLocal<IdentityHashToDataObject> exceptionDataHolder = new ThreadLocal();
    private ThreadLocal<Long> exceptionHandlerId = new ThreadLocal();
    private StringConstraint strConstraint;

    public ExceptionSensorHook(IIdManager idManager, Map<String, Object> parameter) {
        this.idManager = idManager;
        this.strConstraint = new StringConstraint(parameter);
    }

    @Override
    public void beforeConstructor(long methodId, long sensorTypeId, Object[] parameters, RegisteredSensorConfig rsc) {
    }

    @Override
    public void afterConstructor(ICoreService coreService, long methodId, long sensorTypeId, Object object, Object[] parameters, RegisteredSensorConfig rsc) {
        block3: {
            String rscTragetClassname;
            String throwableClass = object.getClass().getName();
            if (throwableClass.equals(rscTragetClassname = rsc.getQualifiedTargetClassName())) {
                try {
                    long platformId = this.idManager.getPlatformId();
                    Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                    long registeredConstructorId = this.idManager.getRegisteredMethodId(methodId);
                    long registeredSensorTypeId = this.idManager.getRegisteredSensorTypeId(sensorTypeId);
                    Long identityHash = System.identityHashCode(object);
                    this.exceptionHandlerId.set(null);
                    Throwable throwable = (Throwable)object;
                    ExceptionSensorData data = new ExceptionSensorData(timestamp, platformId, registeredSensorTypeId, registeredConstructorId);
                    data.setThrowableIdentityHashCode(identityHash.longValue());
                    data.setExceptionEvent(ExceptionEvent.CREATED);
                    data.setThrowableType(throwable.getClass().getName());
                    this.setStaticInformation(data, throwable);
                    this.exceptionDataHolder.set(new IdentityHashToDataObject(identityHash, data));
                    coreService.addExceptionSensorData(registeredSensorTypeId, data.getThrowableIdentityHashCode(), data);
                }
                catch (IdNotAvailableException e) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("Could not start exception sequence because of a (currently) not mapped ID");
                }
            }
        }
    }

    @Override
    public void dispatchOnThrowInBody(ICoreService coreService, long id, long sensorTypeId, Object object, Object exceptionObject, Object[] parameters, RegisteredSensorConfig rsc) {
        block7: {
            IdentityHashToDataObject mappingObject = this.exceptionDataHolder.get();
            if (null != mappingObject) {
                try {
                    long platformId = this.idManager.getPlatformId();
                    Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                    long registeredMethodId = this.idManager.getRegisteredMethodId(id);
                    long registeredSensorTypeId = this.idManager.getRegisteredSensorTypeId(sensorTypeId);
                    Long identityHash = System.identityHashCode(exceptionObject);
                    Throwable throwable = (Throwable)exceptionObject;
                    ExceptionSensorData data = new ExceptionSensorData(timestamp, platformId, registeredSensorTypeId, registeredMethodId);
                    data.setThrowableIdentityHashCode(identityHash.longValue());
                    data.setThrowableType(throwable.getClass().getName());
                    if (mappingObject.getIdentityHash().equals(identityHash)) {
                        if (null != this.exceptionHandlerId.get() && registeredMethodId == this.exceptionHandlerId.get()) {
                            data.setExceptionEvent(ExceptionEvent.RETHROWN);
                        } else {
                            data.setExceptionEvent(ExceptionEvent.PASSED);
                        }
                        ExceptionSensorData parent = mappingObject.getExceptionSensorData();
                        parent.setChild(data);
                        mappingObject.setExceptionSensorData(data);
                        this.exceptionDataHolder.set(mappingObject);
                    } else {
                        data.setExceptionEvent(ExceptionEvent.UNREGISTERED_PASSED);
                        this.setStaticInformation(data, throwable);
                        this.exceptionDataHolder.set(new IdentityHashToDataObject(identityHash, data));
                    }
                    coreService.addExceptionSensorData(registeredSensorTypeId, data.getThrowableIdentityHashCode(), data);
                }
                catch (IdNotAvailableException e) {
                    if (!LOG.isDebugEnabled()) break block7;
                    LOG.debug("Could not start exception sequence because of a (currently) not mapped ID");
                }
            }
        }
    }

    @Override
    public void dispatchBeforeCatchBody(ICoreService coreService, long id, long sensorTypeId, Object exceptionObject, RegisteredSensorConfig rsc) {
        block5: {
            IdentityHashToDataObject mappingObject = this.exceptionDataHolder.get();
            if (null != mappingObject) {
                try {
                    long platformId = this.idManager.getPlatformId();
                    Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                    long registeredMethodId = this.idManager.getRegisteredMethodId(id);
                    long registeredSensorTypeId = this.idManager.getRegisteredSensorTypeId(sensorTypeId);
                    Long identityHash = System.identityHashCode(exceptionObject);
                    this.exceptionHandlerId.set(registeredMethodId);
                    Throwable throwable = (Throwable)exceptionObject;
                    ExceptionSensorData data = new ExceptionSensorData(timestamp, platformId, registeredSensorTypeId, registeredMethodId);
                    data.setThrowableIdentityHashCode(identityHash.longValue());
                    data.setThrowableType(throwable.getClass().getName());
                    data.setExceptionEvent(ExceptionEvent.HANDLED);
                    if (mappingObject.getIdentityHash().equals(identityHash)) {
                        ExceptionSensorData parent = mappingObject.getExceptionSensorData();
                        parent.setChild(data);
                        mappingObject.setExceptionSensorData(data);
                        this.exceptionDataHolder.set(mappingObject);
                    } else {
                        data.setExceptionEvent(ExceptionEvent.UNREGISTERED_PASSED);
                        this.setStaticInformation(data, throwable);
                        this.exceptionDataHolder.set(new IdentityHashToDataObject(identityHash, data));
                    }
                    coreService.addExceptionSensorData(registeredSensorTypeId, data.getThrowableIdentityHashCode(), data);
                }
                catch (IdNotAvailableException e) {
                    if (!LOG.isDebugEnabled()) break block5;
                    LOG.debug("Could not start exception sequence because of a (currently) not mapped ID");
                }
            }
        }
    }

    private void setStaticInformation(ExceptionSensorData exceptionSensorData, Throwable throwable) {
        block9: {
            block8: {
                block7: {
                    try {
                        Throwable cause = throwable.getCause();
                        if (null != cause) {
                            exceptionSensorData.setCause(this.strConstraint.crop(cause.getClass().getName()));
                        }
                    }
                    catch (Exception e) {
                        if (!LOG.isDebugEnabled()) break block7;
                        LOG.debug("It was not possible to retrieve the exception cause from " + throwable.getClass().getName(), (Throwable)e);
                    }
                }
                try {
                    exceptionSensorData.setErrorMessage(this.strConstraint.crop(throwable.getMessage()));
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block8;
                    LOG.debug("It was not possible to retrieve the error message from " + throwable.getClass().getName(), (Throwable)e);
                }
            }
            try {
                exceptionSensorData.setStackTrace(this.strConstraint.crop(this.stackTraceToString(throwable)));
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block9;
                LOG.debug("It was not possible to retrieve the stack trace from " + throwable.getClass().getName(), (Throwable)e);
            }
        }
    }

    private String stackTraceToString(Throwable throwable) {
        StringWriter result = new StringWriter();
        PrintWriter writer = new PrintWriter(result);
        throwable.printStackTrace(writer);
        return ((Object)result).toString();
    }
}

