/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.sending;

import info.novatec.inspectit.agent.config.IConfigurationStorage;
import info.novatec.inspectit.agent.config.impl.StrategyConfig;
import info.novatec.inspectit.agent.core.ICoreService;
import info.novatec.inspectit.agent.sending.ISendingStrategy;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSendingStrategy
implements ISendingStrategy,
InitializingBean {
    private ICoreService coreService;
    @Autowired
    private IConfigurationStorage configurationStorage;

    protected final void sendNow() {
        this.coreService.sendData();
    }

    public final void start(ICoreService coreService) {
        this.coreService = coreService;
        this.startStrategy();
    }

    protected abstract void startStrategy();

    public abstract void stop();

    protected final ICoreService getCoreService() {
        return this.coreService;
    }

    public void afterPropertiesSet() throws Exception {
        for (StrategyConfig sendingStrategyConfig : this.configurationStorage.getSendingStrategyConfigs()) {
            if (!sendingStrategyConfig.getClazzName().equals(this.getClass().getName())) continue;
            this.init(sendingStrategyConfig.getSettings());
            break;
        }
    }
}

