/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.logback;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.PropertyDefinerBase;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import info.novatec.inspectit.minlog.MinlogToSLF4JLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.LoggerFactory;

public final class LogInitializer
extends PropertyDefinerBase {
    public static final String DEFAULT_LOG_FILE_NAME = "logging-config.xml";
    private static final String LOG_FILE_PROPERTY = "inspectit.logging.config";
    private static String logDirLocation;
    private static String inspectitJarLocation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initLogging() {
        LoggerContext context;
        block10: {
            if (null == inspectitJarLocation) {
                return;
            }
            File agentJar = new File(inspectitJarLocation).getAbsoluteFile();
            context = (LoggerContext)LoggerFactory.getILoggerFactory();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            context.reset();
            InputStream is = null;
            try {
                String logPath;
                File logFile;
                File logFile2;
                String logFileLocation = System.getProperty(LOG_FILE_PROPERTY);
                if (null != logFileLocation && (logFile2 = new File(logFileLocation).getAbsoluteFile()).exists()) {
                    is = new FileInputStream(logFile2);
                }
                if (null == is && null != agentJar && (logFile = new File(logPath = agentJar.getParent() + File.separator + File.separator + DEFAULT_LOG_FILE_NAME)).exists()) {
                    is = new FileInputStream(logFile);
                }
                if (null == is) break block10;
                try {
                    configurator.doConfigure(is);
                }
                catch (JoranException joranException) {
                }
                finally {
                    is.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
        MinlogToSLF4JLogger.init();
    }

    public static void setAgentNameAndInitLogging(String agentName) {
        if (null == inspectitJarLocation) {
            return;
        }
        File agentJar = new File(inspectitJarLocation).getAbsoluteFile();
        logDirLocation = agentJar.getParent() + File.separator + "logs" + File.separator + agentName;
        LogInitializer.initLogging();
    }

    public static void setInspectitJarLocation(String inspectitJarLoc) {
        inspectitJarLocation = inspectitJarLoc;
        File agentJar = new File(inspectitJarLocation).getAbsoluteFile();
        logDirLocation = agentJar.getParent() + File.separator + "logs" + File.separator + "startup";
    }

    public String getPropertyValue() {
        return logDirLocation;
    }
}

