/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.jrebel;

import info.novatec.inspectit.agent.analyzer.IClassPoolAnalyzer;
import info.novatec.inspectit.agent.analyzer.IInheritanceAnalyzer;
import info.novatec.inspectit.agent.config.impl.PropertyAccessor;
import info.novatec.inspectit.agent.config.impl.UnregisteredSensorConfig;
import info.novatec.inspectit.communication.data.ParameterContentType;
import org.apache.commons.collections.CollectionUtils;

public final class JRebelUtil {
    private static final String JREBEL_CONSTRUCTOR_INIT_METHOD = "__init__";
    private static final String JREBEL_SUFFIX_PATTERN = "$$M$*";

    private JRebelUtil() {
    }

    public static UnregisteredSensorConfig getJRebelSensorConfiguration(UnregisteredSensorConfig original, IClassPoolAnalyzer classPoolAnalyzer, IInheritanceAnalyzer inheritanceAnalyzer) {
        UnregisteredSensorConfig jRebelSensorConfig = new UnregisteredSensorConfig(classPoolAnalyzer, inheritanceAnalyzer);
        jRebelSensorConfig.setTargetPackageName(original.getTargetPackageName());
        jRebelSensorConfig.setTargetClassName(original.getTargetClassName() + JREBEL_SUFFIX_PATTERN);
        if (original.isConstructor()) {
            jRebelSensorConfig.setTargetMethodName(JREBEL_CONSTRUCTOR_INIT_METHOD);
        } else {
            jRebelSensorConfig.setTargetMethodName(original.getTargetMethodName());
        }
        if (!original.isIgnoreSignature()) {
            jRebelSensorConfig.getParameterTypes().add(original.getTargetClassName());
            jRebelSensorConfig.getParameterTypes().addAll(original.getParameterTypes());
        }
        jRebelSensorConfig.setConstructor(false);
        jRebelSensorConfig.setIgnoreSignature(original.isIgnoreSignature());
        jRebelSensorConfig.setExceptionSensorActivated(original.isExceptionSensorActivated());
        jRebelSensorConfig.setSuperclass(original.isSuperclass());
        jRebelSensorConfig.setInterface(original.isInterface());
        jRebelSensorConfig.setAnnotationClassName(original.getAnnotationClassName());
        jRebelSensorConfig.setModifiers(original.getModifiers());
        jRebelSensorConfig.getSettings().putAll(original.getSettings());
        jRebelSensorConfig.setIgnoreSignature(original.isIgnoreSignature());
        jRebelSensorConfig.setVirtual(true);
        jRebelSensorConfig.setSensorTypeConfig(original.getSensorTypeConfig());
        if (CollectionUtils.isNotEmpty(original.getPropertyAccessorList())) {
            for (PropertyAccessor.PropertyPathStart pathStart : original.getPropertyAccessorList()) {
                if (pathStart.getContentType() != ParameterContentType.PARAM) {
                    jRebelSensorConfig.getPropertyAccessorList().add(pathStart);
                    continue;
                }
                PropertyAccessor.PropertyPathStart newPathStart = new PropertyAccessor.PropertyPathStart();
                newPathStart.setName(pathStart.getName());
                newPathStart.setContentType(pathStart.getContentType());
                newPathStart.setSignaturePosition(pathStart.getSignaturePosition() + 1);
                newPathStart.setPathToContinue(pathStart.getPathToContinue());
                jRebelSensorConfig.getPropertyAccessorList().add(newPathStart);
            }
        }
        jRebelSensorConfig.setPropertyAccess(original.isPropertyAccess());
        return jRebelSensorConfig;
    }
}

