/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.javaagent;

import info.novatec.inspectit.agent.Agent;
import info.novatec.inspectit.agent.IAgent;
import info.novatec.inspectit.agent.hooking.IHookDispatcher;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaAgent
implements ClassFileTransformer {
    private static final Logger LOGGER = Logger.getLogger(JavaAgent.class.getName());
    private static volatile boolean operationInProgress = false;
    private static Instrumentation instrumentation;
    private static boolean instrumentCoreClasses;
    private static final String INSPECTIT_AGENT = "info.novatec.inspectit.agent.SpringAgent";
    private static Set<String> selfFirstClasses;

    public static void premain(String agentArgs, Instrumentation inst) {
        instrumentation = inst;
        LOGGER.info("inspectIT Agent: Starting initialization...");
        JavaAgent.checkForCorrectSetup();
        try {
            InspectItClassLoader classLoader = new InspectItClassLoader(new URL[0], JavaAgent.class.getClassLoader());
            Class<?> agentClazz = classLoader.loadClass(INSPECTIT_AGENT);
            Constructor<?> constructor = agentClazz.getConstructor(String.class);
            Object realAgent = constructor.newInstance(JavaAgent.getInspectItAgentJarFileLocation());
            Agent.agent = (IAgent)realAgent;
            JavaAgent.preloadClasses();
            LOGGER.info("inspectIT Agent: Initialization complete...");
            JavaAgent.analyzeAlreadyLoadedClasses();
            inst.addTransformer(new JavaAgent());
        }
        catch (Exception e) {
            LOGGER.severe("Something unexpected happened while trying to initialize the Agent, aborting!");
            e.printStackTrace();
        }
    }

    @Override
    public byte[] transform(ClassLoader classLoader, String className, Class<?> clazz, ProtectionDomain pd, byte[] data) throws IllegalClassFormatException {
        try {
            if (null != classLoader && InspectItClassLoader.class.getCanonicalName().equals(classLoader.getClass().getCanonicalName())) {
                return data;
            }
            if (null == data || data.length == 0 || null == className || "".equals(className)) {
                return data;
            }
            if (!instrumentCoreClasses & null == classLoader) {
                return data;
            }
            if (!operationInProgress) {
                operationInProgress = true;
                String modifiedClassName = className.replaceAll("/", ".");
                byte[] instrumentedData = Agent.agent.inspectByteCode(data, modifiedClassName, classLoader);
                operationInProgress = false;
                return instrumentedData;
            }
            return data;
        }
        catch (Throwable ex) {
            LOGGER.severe("Error occurred while dealing with class: " + className + " " + ex.getMessage());
            ex.printStackTrace();
            return null;
        }
    }

    private static void checkForCorrectSetup() {
        try {
            Method append = instrumentation.getClass().getDeclaredMethod("appendToBootstrapClassLoaderSearch", JarFile.class);
            append.setAccessible(true);
            append.invoke((Object)instrumentation, new JarFile(JavaAgent.getInspectItAgentJarFileLocation()));
            instrumentCoreClasses = true;
        }
        catch (NoSuchMethodException e) {
            LOGGER.info("inspectIT Agent: Advanced instrumentation capabilities not detected...");
        }
        catch (SecurityException e) {
            LOGGER.info("inspectIT Agent: Advanced instrumentation capabilities not detected due to security constraints...");
        }
        catch (Exception e) {
            LOGGER.severe("Something unexpected happened while trying to get advanced instrumentation capabilities!");
            e.printStackTrace();
        }
        if (!instrumentCoreClasses) {
            List<String> inputArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
            for (String arg : inputArgs) {
                if (!arg.contains("Xbootclasspath") || !arg.contains("inspectit-agent.jar")) continue;
                instrumentCoreClasses = true;
                LOGGER.info("inspectIT Agent: Xbootclasspath setting found, activating core class instrumentation...");
                break;
            }
        }
    }

    private static void analyzeAlreadyLoadedClasses() {
        try {
            if (instrumentation.isRedefineClassesSupported()) {
                if (instrumentCoreClasses) {
                    for (Class loadedClass : instrumentation.getAllLoadedClasses()) {
                        String clazzName = loadedClass.getCanonicalName();
                        if (null == clazzName || selfFirstClasses.contains(clazzName) || null != loadedClass.getClassLoader() && InspectItClassLoader.class.getCanonicalName().equals(loadedClass.getClassLoader().getClass().getCanonicalName())) continue;
                        try {
                            clazzName = JavaAgent.getClassNameForJavassist(loadedClass);
                            byte[] modified = Agent.agent.inspectByteCode(null, clazzName, loadedClass.getClassLoader());
                            if (null == modified) continue;
                            ClassDefinition classDefinition = new ClassDefinition(loadedClass, modified);
                            instrumentation.redefineClasses(classDefinition);
                        }
                        catch (ClassNotFoundException e) {
                            LOGGER.severe(e.getMessage());
                        }
                        catch (UnmodifiableClassException e) {
                            LOGGER.severe(e.getMessage());
                        }
                    }
                    LOGGER.info("inspectIT Agent: Instrumentation of core classes finished...");
                } else {
                    LOGGER.info("inspectIT Agent: Core classes cannot be instrumented, please add -Xbootclasspath/a:<path_to_agent.jar> to the JVM parameters!");
                }
            } else {
                LOGGER.info("Redefinition of Classes is not supported in this JVM!");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            LOGGER.severe("The process of class redefinitions produced an error: " + t.getMessage());
            LOGGER.severe("If you are running on an IBM JVM, please ignore this error as the JVM does not support this feature!");
            LOGGER.throwing(JavaAgent.class.getCanonicalName(), "analyzeAlreadyLoadedClasses", t);
        }
    }

    private static void preloadClasses() {
        LOGGER.info("Preloading classes ...");
        StringIndexOutOfBoundsException.class.getClass();
        LOGGER.info("Preloading classes complete...");
    }

    private static String getClassNameForJavassist(Class<?> clazz) {
        String clazzName = clazz.getCanonicalName();
        while (null != clazz.getEnclosingClass()) {
            clazz = clazz.getEnclosingClass();
        }
        if (!clazzName.equals(clazz.getCanonicalName())) {
            String enclosingClasses = clazzName.substring(clazz.getCanonicalName().length());
            enclosingClasses = enclosingClasses.replaceAll("\\.", "\\$");
            clazzName = clazz.getCanonicalName() + enclosingClasses;
        }
        return clazzName;
    }

    public static String getInspectItAgentJarFileLocation() {
        CodeSource cs = JavaAgent.class.getProtectionDomain().getCodeSource();
        if (null != cs) {
            return cs.getLocation().getFile();
        }
        List<String> inputArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
        for (String arg : inputArgs) {
            if (!arg.contains("javaagent") || !arg.contains("inspectit-agent.jar")) continue;
            Pattern pattern = Pattern.compile("-javaagent:(.*\\.jar)");
            Matcher matcher = pattern.matcher(arg);
            boolean matches = matcher.matches();
            if (!matches) break;
            String path = matcher.group(1);
            return path;
        }
        return null;
    }

    static {
        instrumentCoreClasses = false;
        selfFirstClasses = new HashSet<String>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InspectItClassLoader
    extends URLClassLoader {
        private Set<String> ignoreClasses = new HashSet<String>();

        public InspectItClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
            try {
                String agentFile = JavaAgent.getInspectItAgentJarFileLocation();
                if (!this.isJar(agentFile)) {
                    LOGGER.severe("There was a problem in retrieving the root jar name!");
                    throw new RuntimeException("There was a problem in retrieving the root jar name!");
                }
                this.addJarResource(new File(agentFile));
            }
            catch (IOException e) {
                LOGGER.severe("There was a problem in extracting needed libs for the inspectIT agent: " + e.getMessage());
                LOGGER.throwing(InspectItClassLoader.class.getCanonicalName(), "InspectItClassLoader", e);
            }
            this.ignoreClasses.add(IAgent.class.getCanonicalName());
            this.ignoreClasses.add(Agent.class.getCanonicalName());
            this.ignoreClasses.add(IHookDispatcher.class.getCanonicalName());
            this.ignoreClasses.add(JavaAgent.class.getCanonicalName());
            this.ignoreClasses.add(InspectItClassLoader.class.getCanonicalName());
        }

        private void addJarResource(File file) throws IOException {
            JarFile jarFile = new JarFile(file);
            this.addURL(file.toURI().toURL());
            this.analyzeFile(file);
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                if (jarEntry.isDirectory() || !this.isJar(jarEntry.getName())) continue;
                this.addJarResource(this.jarEntryAsFile(jarFile, jarEntry));
            }
        }

        private boolean isJar(String fileName) {
            return fileName != null && fileName.toLowerCase().endsWith(".jar");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File jarEntryAsFile(JarFile jarFile, JarEntry jarEntry) throws IOException {
            File file;
            InputStream input = null;
            FileOutputStream output = null;
            try {
                String name = jarEntry.getName().replace('/', '_');
                int i = name.lastIndexOf(46);
                String extension = i > -1 ? name.substring(i) : "";
                File file2 = File.createTempFile(name.substring(0, name.length() - extension.length()) + ".", extension);
                file2.deleteOnExit();
                input = jarFile.getInputStream(jarEntry);
                output = new FileOutputStream(file2);
                byte[] buffer = new byte[4096];
                int readCount = input.read(buffer);
                while (readCount != -1) {
                    ((OutputStream)output).write(buffer, 0, readCount);
                    readCount = input.read(buffer);
                }
                file = file2;
            }
            catch (Throwable throwable) {
                InspectItClassLoader.close(input);
                InspectItClassLoader.close(output);
                throw throwable;
            }
            InspectItClassLoader.close(input);
            InspectItClassLoader.close(output);
            return file;
        }

        private void analyzeFile(File file) throws IOException {
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                if (!jarEntry.getName().endsWith(".class")) continue;
                selfFirstClasses.add(jarEntry.getName().replaceAll("/", "\\.").replace(".class", ""));
            }
            if (null != jarFile) {
                jarFile.close();
            }
        }

        private static void close(Closeable closeable) {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return this.loadClass(name, false);
        }

        @Override
        public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> result = this.findLoadedClass(name);
            if (null != result) {
                if (resolve) {
                    this.resolveClass(result);
                }
                return result;
            }
            boolean selfFirst = false;
            if (!this.ignoreClasses.contains(name) && selfFirstClasses.contains(name)) {
                selfFirst = true;
            }
            if (selfFirst) {
                Class<?> c = this.findClass(name);
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
            return super.loadClass(name, resolve);
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codesource) {
            AllPermission allPerm = new AllPermission();
            PermissionCollection pc = allPerm.newPermissionCollection();
            pc.add(allPerm);
            return pc;
        }
    }
}

