/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.hooking.impl;

import info.novatec.inspectit.agent.config.IConfigurationStorage;
import info.novatec.inspectit.agent.config.impl.MethodSensorTypeConfig;
import info.novatec.inspectit.agent.config.impl.RegisteredSensorConfig;
import info.novatec.inspectit.agent.core.IIdManager;
import info.novatec.inspectit.agent.hooking.IHookDispatcherMapper;
import info.novatec.inspectit.agent.hooking.IHookInstrumenter;
import info.novatec.inspectit.agent.hooking.impl.HookException;
import info.novatec.inspectit.spring.logger.Log;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.Handler;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HookInstrumenter
implements IHookInstrumenter {
    @Log
    Logger log;
    private static String hookDispatcherTarget = "info.novatec.inspectit.agent.Agent#agent.getHookDispatcher()";
    private static String agentTarget = "info.novatec.inspectit.agent.Agent#agent";
    private final IHookDispatcherMapper hookDispatcher;
    private final IIdManager idManager;
    private MethodExprEditor methodExprEditor = new MethodExprEditor();
    private ConstructorExprEditor constructorExprEditor = new ConstructorExprEditor();
    private IConfigurationStorage configurationStorage;

    @Autowired
    public HookInstrumenter(IHookDispatcherMapper hookDispatcher, IIdManager idManager, IConfigurationStorage configurationStorage) {
        this.hookDispatcher = hookDispatcher;
        this.idManager = idManager;
        this.configurationStorage = configurationStorage;
    }

    public void addMethodHook(CtMethod method, RegisteredSensorConfig rsc) throws HookException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Match found! Class: " + rsc.getTargetClassName() + " Method: " + rsc.getTargetMethodName() + " Parameter: " + rsc.getParameterTypes() + " id: " + rsc.getId());
        }
        if (method.getDeclaringClass().isFrozen()) {
            method.getDeclaringClass().defrost();
        }
        long methodId = this.idManager.registerMethod(rsc);
        for (MethodSensorTypeConfig config : rsc.getSensorTypeConfigs()) {
            long sensorTypeId = config.getId();
            this.idManager.addSensorTypeToMethod(sensorTypeId, methodId);
        }
        try {
            boolean asFinally;
            boolean exceptionSensorActivated = this.configurationStorage.isExceptionSensorActivated();
            boolean exceptionSensorEnhanced = this.configurationStorage.isEnhancedExceptionSensorActivated();
            boolean bl = asFinally = !exceptionSensorActivated || !exceptionSensorEnhanced;
            if (Modifier.isStatic((int)method.getModifiers())) {
                method.insertBefore(hookDispatcherTarget + ".dispatchMethodBeforeBody(" + methodId + "l, null, $args);");
                method.insertAfter(hookDispatcherTarget + ".dispatchFirstMethodAfterBody(" + methodId + "l, null, $args, ($w)$_);", asFinally);
                method.insertAfter(hookDispatcherTarget + ".dispatchSecondMethodAfterBody(" + methodId + "l, null, $args, ($w)$_);", asFinally);
                if (!asFinally) {
                    this.instrumentMethodWithTryCatch(method, methodId, true);
                }
            } else {
                method.insertBefore(hookDispatcherTarget + ".dispatchMethodBeforeBody(" + methodId + "l, $0, $args);");
                method.insertAfter(hookDispatcherTarget + ".dispatchFirstMethodAfterBody(" + methodId + "l, $0, $args, ($w)$_);", asFinally);
                method.insertAfter(hookDispatcherTarget + ".dispatchSecondMethodAfterBody(" + methodId + "l, $0, $args, ($w)$_);", asFinally);
                if (!asFinally) {
                    this.instrumentMethodWithTryCatch(method, methodId, false);
                }
            }
            this.hookDispatcher.addMethodMapping(methodId, rsc);
        }
        catch (CannotCompileException cannotCompileException) {
            throw new HookException("Could not insert the bytecode into the method/class", cannotCompileException);
        }
        catch (NotFoundException notFoundException) {
            throw new HookException("Could not insert the bytecode into the method/class", notFoundException);
        }
    }

    public void addConstructorHook(CtConstructor constructor, RegisteredSensorConfig rsc) throws HookException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Constructor match found! Class: " + rsc.getTargetClassName() + " Parameter: " + rsc.getParameterTypes() + " id: " + rsc.getId());
        }
        if (constructor.getDeclaringClass().isFrozen()) {
            constructor.getDeclaringClass().defrost();
        }
        long constructorId = this.idManager.registerMethod(rsc);
        for (MethodSensorTypeConfig config : rsc.getSensorTypeConfigs()) {
            long sensorTypeId = config.getId();
            this.idManager.addSensorTypeToMethod(sensorTypeId, constructorId);
        }
        try {
            boolean exceptionSensorActivated = this.configurationStorage.isExceptionSensorActivated();
            boolean exceptionSensorEnhanced = this.configurationStorage.isEnhancedExceptionSensorActivated();
            boolean asFinally = !exceptionSensorActivated || !exceptionSensorEnhanced;
            constructor.insertBefore(hookDispatcherTarget + ".dispatchConstructorBeforeBody(" + constructorId + "l, $args);");
            constructor.insertAfter(hookDispatcherTarget + ".dispatchConstructorAfterBody(" + constructorId + "l, $0, $args);", asFinally);
            if (!asFinally) {
                this.instrumentConstructorWithTryCatch(constructor, constructorId);
            }
            this.hookDispatcher.addConstructorMapping(constructorId, rsc);
        }
        catch (CannotCompileException cannotCompileException) {
            throw new HookException("Could not insert the bytecode into the constructor/class", cannotCompileException);
        }
        catch (NotFoundException notFoundException) {
            throw new HookException("Could not insert the bytecode into the constructor/class", notFoundException);
        }
    }

    public void addClassLoaderDelegationHook(CtMethod ctMethod) throws HookException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Class loader delegation match found! Method signature: " + ctMethod.getSignature());
        }
        if (ctMethod.getDeclaringClass().isFrozen()) {
            ctMethod.getDeclaringClass().defrost();
        }
        try {
            ctMethod.insertBefore("Class c = " + agentTarget + ".loadClass($args); if (null != c) { return c; }");
        }
        catch (CannotCompileException cannotCompileException) {
            throw new HookException("Could not insert the bytecode into the method/class for class loader delegation", cannotCompileException);
        }
    }

    private void instrumentMethodWithTryCatch(CtMethod method, long methodId, boolean isStatic) throws CannotCompileException, NotFoundException {
        if (this.configurationStorage.isExceptionSensorActivated()) {
            this.methodExprEditor.setId(methodId);
            method.instrument((ExprEditor)this.methodExprEditor);
        }
        CtClass type = ClassPool.getDefault().get("java.lang.Throwable");
        if (!isStatic) {
            method.addCatch(hookDispatcherTarget + ".dispatchOnThrowInBody(" + methodId + "l, $0, $args, $e);" + hookDispatcherTarget + ".dispatchFirstMethodAfterBody(" + methodId + "l, $0, $args, null);" + hookDispatcherTarget + ".dispatchSecondMethodAfterBody(" + methodId + "l, $0, $args, null);" + "throw $e; ", type);
        } else {
            method.addCatch(hookDispatcherTarget + ".dispatchOnThrowInBody(" + methodId + "l, null, $args, $e);" + hookDispatcherTarget + ".dispatchFirstMethodAfterBody(" + methodId + "l, null, $args, null);" + hookDispatcherTarget + ".dispatchSecondMethodAfterBody(" + methodId + "l, null, $args, null);" + "throw $e; ", type);
        }
    }

    private void instrumentConstructorWithTryCatch(CtConstructor constructor, long constructorId) throws CannotCompileException, NotFoundException {
        if (this.configurationStorage.isExceptionSensorActivated()) {
            this.constructorExprEditor.setId(constructorId);
            constructor.instrument((ExprEditor)this.constructorExprEditor);
        }
        CtClass type = ClassPool.getDefault().get("java.lang.Throwable");
        constructor.addCatch(hookDispatcherTarget + ".dispatchConstructorOnThrowInBody(" + constructorId + "l, $0, $args, $e);" + hookDispatcherTarget + ".dispatchConstructorAfterBody(" + constructorId + "l, $0, $args);" + "throw $e; ", type);
    }

    public static class ConstructorExprEditor
    extends ExprEditor {
        private long id = 0L;

        public void setId(long id) {
            this.id = id;
        }

        public void edit(Handler handler) throws CannotCompileException {
            if (!handler.isFinally()) {
                handler.insertBefore(hookDispatcherTarget + ".dispatchConstructorBeforeCatch(" + this.id + "l, $1);");
            }
        }
    }

    public static class MethodExprEditor
    extends ExprEditor {
        private long id = 0L;

        public void setId(long id) {
            this.id = id;
        }

        public void edit(Handler handler) throws CannotCompileException {
            if (!handler.isFinally()) {
                handler.insertBefore(hookDispatcherTarget + ".dispatchBeforeCatch(" + this.id + "l, $1);");
            }
        }
    }
}

