/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.hooking.impl;

import info.novatec.inspectit.agent.config.impl.RegisteredSensorConfig;
import info.novatec.inspectit.agent.core.ICoreService;
import info.novatec.inspectit.agent.hooking.IConstructorHook;
import info.novatec.inspectit.agent.hooking.IHook;
import info.novatec.inspectit.agent.hooking.IHookDispatcher;
import info.novatec.inspectit.agent.hooking.IHookDispatcherMapper;
import info.novatec.inspectit.agent.hooking.IMethodHook;
import info.novatec.inspectit.agent.sensor.exception.IExceptionSensorHook;
import info.novatec.inspectit.agent.sensor.method.IMethodSensor;
import info.novatec.inspectit.spring.logger.Log;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HookDispatcher
implements IHookDispatcherMapper,
IHookDispatcher {
    @Log
    Logger log;
    private final ICoreService coreService;
    private Map<Long, RegisteredSensorConfig> methodHooks = new HashMap<Long, RegisteredSensorConfig>();
    private Map<Long, RegisteredSensorConfig> constructorHooks = new HashMap<Long, RegisteredSensorConfig>();
    private InvocationSequenceCount invocationSequenceCount = new InvocationSequenceCount();
    private ThreadLocal<IHook> invocationSequenceHolder = new ThreadLocal();
    private ExecutionMarker executionMarker = new ExecutionMarker();

    @Autowired
    public HookDispatcher(ICoreService coreService) {
        this.coreService = coreService;
    }

    public void addMethodMapping(long id, RegisteredSensorConfig rsc) {
        this.methodHooks.put(id, rsc);
    }

    public void addConstructorMapping(long id, RegisteredSensorConfig rsc) {
        this.constructorHooks.put(id, rsc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchMethodBeforeBody(long id, Object object, Object[] parameters) {
        if (!this.executionMarker.isActive()) {
            try {
                this.executionMarker.active();
                try {
                    RegisteredSensorConfig rsc = this.methodHooks.get(id);
                    if (rsc.startsInvocationSequence()) {
                        this.invocationSequenceCount.increment();
                        if (null == this.invocationSequenceHolder.get()) {
                            this.invocationSequenceHolder.set(((IMethodSensor)rsc.getInvocationSequenceSensorTypeConfig().getSensorType()).getHook());
                        }
                    } else if (null != this.invocationSequenceHolder.get()) {
                        IMethodHook invocationHook = (IMethodHook)this.invocationSequenceHolder.get();
                        invocationHook.beforeBody(id, -1L, object, parameters, rsc);
                    }
                    for (Map.Entry<Long, IHook> entry : rsc.getReverseMethodHooks().entrySet()) {
                        IMethodHook methodHook = (IMethodHook)entry.getValue();
                        methodHook.beforeBody(id, entry.getKey(), object, parameters, rsc);
                    }
                }
                catch (Throwable throwable) {
                    this.log.error("An error happened in the Hook Dispatcher! (before body)", throwable);
                }
            }
            finally {
                this.executionMarker.deactive();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchFirstMethodAfterBody(long id, Object object, Object[] parameters, Object returnValue) {
        if (!this.executionMarker.isActive()) {
            try {
                this.executionMarker.active();
                try {
                    RegisteredSensorConfig rsc = this.methodHooks.get(id);
                    for (Map.Entry<Long, IHook> entry : rsc.getMethodHooks().entrySet()) {
                        IMethodHook methodHook = (IMethodHook)entry.getValue();
                        methodHook.firstAfterBody(id, entry.getKey(), object, parameters, returnValue, rsc);
                    }
                }
                catch (Throwable throwable) {
                    this.log.error("An error happened in the Hook Dispatcher! (after body)", throwable);
                }
            }
            finally {
                this.executionMarker.deactive();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchSecondMethodAfterBody(long id, Object object, Object[] parameters, Object returnValue) {
        if (!this.executionMarker.isActive()) {
            try {
                this.executionMarker.active();
                try {
                    RegisteredSensorConfig rsc = this.methodHooks.get(id);
                    if (null != this.invocationSequenceHolder.get()) {
                        ICoreService invocCoreService = (ICoreService)((Object)this.invocationSequenceHolder.get());
                        for (Map.Entry<Long, IHook> entry : rsc.getMethodHooks().entrySet()) {
                            IMethodHook methodHook = (IMethodHook)entry.getValue();
                            if (invocCoreService == methodHook) {
                                methodHook.secondAfterBody(this.coreService, id, entry.getKey(), object, parameters, returnValue, rsc);
                                continue;
                            }
                            methodHook.secondAfterBody(invocCoreService, id, entry.getKey(), object, parameters, returnValue, rsc);
                        }
                    } else {
                        for (Map.Entry<Long, IHook> entry : rsc.getMethodHooks().entrySet()) {
                            IMethodHook methodHook = (IMethodHook)entry.getValue();
                            methodHook.secondAfterBody(this.coreService, id, entry.getKey(), object, parameters, returnValue, rsc);
                        }
                    }
                    if (rsc.startsInvocationSequence()) {
                        this.invocationSequenceCount.decrement();
                        if (0L == this.invocationSequenceCount.getCount()) {
                            this.invocationSequenceHolder.set(null);
                        }
                    } else if (null != this.invocationSequenceHolder.get()) {
                        IMethodHook invocationHook = (IMethodHook)this.invocationSequenceHolder.get();
                        invocationHook.secondAfterBody(this.coreService, id, -1L, object, parameters, returnValue, rsc);
                    }
                }
                catch (Throwable throwable) {
                    this.log.error("An error happened in the Hook Dispatcher! (second after body)", throwable);
                }
            }
            finally {
                this.executionMarker.deactive();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchOnThrowInBody(long id, Object object, Object[] parameters, Object exceptionObject) {
        if (!this.executionMarker.isActive()) {
            try {
                this.executionMarker.active();
                RegisteredSensorConfig rsc = this.methodHooks.get(id);
                long sensorTypeId = rsc.getExceptionSensorTypeConfig().getId();
                ICoreService invocCoreService = null;
                if (null != this.invocationSequenceHolder.get()) {
                    invocCoreService = (ICoreService)((Object)this.invocationSequenceHolder.get());
                }
                IExceptionSensorHook exceptionHook = (IExceptionSensorHook)((IMethodSensor)rsc.getExceptionSensorTypeConfig().getSensorType()).getHook();
                if (null != invocCoreService) {
                    exceptionHook.dispatchOnThrowInBody(invocCoreService, id, sensorTypeId, object, exceptionObject, parameters, rsc);
                } else {
                    exceptionHook.dispatchOnThrowInBody(this.coreService, id, sensorTypeId, object, exceptionObject, parameters, rsc);
                }
            }
            finally {
                this.executionMarker.deactive();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchBeforeCatch(long id, Object exceptionObject) {
        if (!this.executionMarker.isActive()) {
            try {
                this.executionMarker.active();
                RegisteredSensorConfig rsc = this.methodHooks.get(id);
                long sensorTypeId = rsc.getExceptionSensorTypeConfig().getId();
                ICoreService invocCoreService = null;
                if (null != this.invocationSequenceHolder.get()) {
                    invocCoreService = (ICoreService)((Object)this.invocationSequenceHolder.get());
                }
                IExceptionSensorHook exceptionHook = (IExceptionSensorHook)((IMethodSensor)rsc.getExceptionSensorTypeConfig().getSensorType()).getHook();
                if (null != invocCoreService) {
                    exceptionHook.dispatchBeforeCatchBody(invocCoreService, id, sensorTypeId, exceptionObject, rsc);
                } else {
                    exceptionHook.dispatchBeforeCatchBody(this.coreService, id, sensorTypeId, exceptionObject, rsc);
                }
            }
            finally {
                this.executionMarker.deactive();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchConstructorOnThrowInBody(long id, Object object, Object[] parameters, Object exceptionObject) {
        if (!this.executionMarker.isActive()) {
            try {
                this.executionMarker.active();
                RegisteredSensorConfig rsc = this.constructorHooks.get(id);
                long sensorTypeId = rsc.getExceptionSensorTypeConfig().getId();
                ICoreService invocCoreService = null;
                if (null != this.invocationSequenceHolder.get()) {
                    invocCoreService = (ICoreService)((Object)this.invocationSequenceHolder.get());
                }
                IExceptionSensorHook exceptionHook = (IExceptionSensorHook)((IMethodSensor)rsc.getExceptionSensorTypeConfig().getSensorType()).getHook();
                if (null != invocCoreService) {
                    exceptionHook.dispatchOnThrowInBody(invocCoreService, id, sensorTypeId, object, exceptionObject, parameters, rsc);
                } else {
                    exceptionHook.dispatchOnThrowInBody(this.coreService, id, sensorTypeId, object, exceptionObject, parameters, rsc);
                }
            }
            finally {
                this.executionMarker.deactive();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchConstructorBeforeCatch(long id, Object exceptionObject) {
        if (!this.executionMarker.isActive()) {
            try {
                this.executionMarker.active();
                RegisteredSensorConfig rsc = this.constructorHooks.get(id);
                long sensorTypeId = rsc.getExceptionSensorTypeConfig().getId();
                ICoreService invocCoreService = null;
                if (null != this.invocationSequenceHolder.get()) {
                    invocCoreService = (ICoreService)((Object)this.invocationSequenceHolder.get());
                }
                IExceptionSensorHook exceptionHook = (IExceptionSensorHook)((IMethodSensor)rsc.getExceptionSensorTypeConfig().getSensorType()).getHook();
                if (null != invocCoreService) {
                    exceptionHook.dispatchBeforeCatchBody(invocCoreService, id, sensorTypeId, exceptionObject, rsc);
                } else {
                    exceptionHook.dispatchBeforeCatchBody(this.coreService, id, sensorTypeId, exceptionObject, rsc);
                }
            }
            finally {
                this.executionMarker.deactive();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchConstructorBeforeBody(long id, Object[] parameters) {
        if (!this.executionMarker.isActive()) {
            try {
                this.executionMarker.active();
                try {
                    RegisteredSensorConfig rsc = this.constructorHooks.get(id);
                    if (rsc.startsInvocationSequence()) {
                        this.invocationSequenceCount.increment();
                        if (null == this.invocationSequenceHolder.get()) {
                            this.invocationSequenceHolder.set(((IMethodSensor)rsc.getInvocationSequenceSensorTypeConfig().getSensorType()).getHook());
                        }
                    } else if (null != this.invocationSequenceHolder.get()) {
                        IConstructorHook invocationHook = (IConstructorHook)this.invocationSequenceHolder.get();
                        invocationHook.beforeConstructor(id, -1L, parameters, rsc);
                    }
                    for (Map.Entry<Long, IHook> entry : rsc.getReverseMethodHooks().entrySet()) {
                        IConstructorHook constructorHook = (IConstructorHook)entry.getValue();
                        constructorHook.beforeConstructor(id, entry.getKey(), parameters, rsc);
                    }
                }
                catch (Throwable throwable) {
                    this.log.error("An error happened in the Hook Dispatcher! (before constructor)", throwable);
                }
            }
            finally {
                this.executionMarker.deactive();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchConstructorAfterBody(long id, Object object, Object[] parameters) {
        if (!this.executionMarker.isActive()) {
            try {
                this.executionMarker.active();
                try {
                    RegisteredSensorConfig rsc = this.constructorHooks.get(id);
                    if (null != this.invocationSequenceHolder.get()) {
                        ICoreService invocCoreService = (ICoreService)((Object)this.invocationSequenceHolder.get());
                        for (Map.Entry<Long, IHook> entry : rsc.getMethodHooks().entrySet()) {
                            IConstructorHook constructorHook = (IConstructorHook)entry.getValue();
                            if (invocCoreService == constructorHook) {
                                constructorHook.afterConstructor(this.coreService, id, entry.getKey(), object, parameters, rsc);
                                continue;
                            }
                            constructorHook.afterConstructor(invocCoreService, id, entry.getKey(), object, parameters, rsc);
                        }
                    } else {
                        for (Map.Entry<Long, IHook> entry : rsc.getMethodHooks().entrySet()) {
                            IConstructorHook constructorHook = (IConstructorHook)entry.getValue();
                            constructorHook.afterConstructor(this.coreService, id, entry.getKey(), object, parameters, rsc);
                        }
                    }
                    if (rsc.startsInvocationSequence()) {
                        this.invocationSequenceCount.decrement();
                        if (0L == this.invocationSequenceCount.getCount()) {
                            this.invocationSequenceHolder.set(null);
                        }
                    } else if (null != this.invocationSequenceHolder.get()) {
                        IConstructorHook invocationHook = (IConstructorHook)this.invocationSequenceHolder.get();
                        invocationHook.afterConstructor(this.coreService, id, -1L, object, parameters, rsc);
                    }
                }
                catch (Throwable throwable) {
                    this.log.error("An error happened in the Hook Dispatcher! (after constructor)", throwable);
                }
            }
            finally {
                this.executionMarker.deactive();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExecutionMarker
    extends ThreadLocal<Boolean> {
        private ExecutionMarker() {
        }

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }

        public void active() {
            super.set(Boolean.TRUE);
        }

        public void deactive() {
            super.set(Boolean.FALSE);
        }

        public boolean isActive() {
            return (Boolean)super.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InvocationSequenceCount
    extends ThreadLocal<Long> {
        private InvocationSequenceCount() {
        }

        @Override
        protected Long initialValue() {
            return 0L;
        }

        public void increment() {
            super.set((Long)super.get() + 1L);
        }

        public void decrement() {
            super.set((Long)super.get() - 1L);
        }

        public long getCount() {
            return (Long)super.get();
        }
    }
}

