/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.core.impl;

import info.novatec.inspectit.agent.config.IConfigurationStorage;
import info.novatec.inspectit.agent.config.impl.AbstractSensorTypeConfig;
import info.novatec.inspectit.agent.config.impl.JmxSensorConfig;
import info.novatec.inspectit.agent.config.impl.JmxSensorTypeConfig;
import info.novatec.inspectit.agent.config.impl.MethodSensorTypeConfig;
import info.novatec.inspectit.agent.config.impl.PlatformSensorTypeConfig;
import info.novatec.inspectit.agent.config.impl.RegisteredSensorConfig;
import info.novatec.inspectit.agent.config.impl.RepositoryConfig;
import info.novatec.inspectit.agent.connection.IConnection;
import info.novatec.inspectit.agent.connection.RegistrationException;
import info.novatec.inspectit.agent.connection.ServerUnavailableException;
import info.novatec.inspectit.agent.core.IIdManager;
import info.novatec.inspectit.agent.core.IdNotAvailableException;
import info.novatec.inspectit.spring.logger.Log;
import info.novatec.inspectit.version.VersionService;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IdManager
implements IIdManager,
InitializingBean,
DisposableBean {
    @Log
    Logger log;
    private final IConfigurationStorage configurationStorage;
    private final VersionService versionService;
    private final IConnection connection;
    private long platformId = -1L;
    private Map<Long, Long> methodIdMap = new HashMap<Long, Long>();
    private Map<Long, Long> sensorTypeIdMap = new HashMap<Long, Long>();
    private Map<Long, Long> jmxDefinitionDataIdMap = new HashMap<Long, Long>();
    private volatile RegistrationThread registrationThread;
    private LinkedList<RegisteredSensorConfig> methodsToRegister = new LinkedList();
    private LinkedList<JmxSensorConfig> jmxDefinitionDataIdentToRegister = new LinkedList();
    private LinkedList<AbstractSensorTypeConfig> sensorTypesToRegister = new LinkedList();
    private LinkedList<SensorTypeToMethodMapping> sensorTypeToMethodRegister = new LinkedList();
    private volatile boolean serverErrorOccured = false;
    private volatile boolean shutdownInitialized = false;

    @Autowired
    public IdManager(IConfigurationStorage configurationStorage, IConnection connection, VersionService versionService) {
        this.configurationStorage = configurationStorage;
        this.connection = connection;
        this.versionService = versionService;
    }

    public void start() {
        if (null == this.registrationThread) {
            this.registrationThread = new RegistrationThread();
            this.registrationThread.start();
        }
        for (MethodSensorTypeConfig methodSensorTypeConfig : this.configurationStorage.getMethodSensorTypes()) {
            this.registerMethodSensorType(methodSensorTypeConfig);
        }
        for (PlatformSensorTypeConfig platformSensorTypeConfig : this.configurationStorage.getPlatformSensorTypes()) {
            this.registerPlatformSensorType(platformSensorTypeConfig);
        }
        for (JmxSensorTypeConfig jmxSensorTypeConfig : this.configurationStorage.getJmxSensorTypes()) {
            this.registerJmxSensorType(jmxSensorTypeConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        RegistrationThread temp = this.registrationThread;
        this.registrationThread = null;
        RegistrationThread registrationThread = temp;
        synchronized (registrationThread) {
            temp.interrupt();
        }
    }

    public boolean isPlatformRegistered() {
        return -1L != this.platformId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getPlatformId() throws IdNotAvailableException {
        if (!(this.connection.isConnected() || this.isPlatformRegistered() || this.shutdownInitialized)) {
            if (this.serverErrorOccured) throw new IdNotAvailableException("Cannot retrieve platform ID");
            try {
                this.registrationThread.connect();
                this.registrationThread.registerPlatform();
                return this.platformId;
            }
            catch (Throwable throwable) {
                this.serverErrorOccured = true;
                throw new IdNotAvailableException("Connection is not established yet, cannot retrieve platform ID", throwable);
            }
        } else if (!this.isPlatformRegistered() && !this.shutdownInitialized) {
            if (this.serverErrorOccured) throw new IdNotAvailableException("Cannot retrieve platform ID");
            try {
                this.registrationThread.registerPlatform();
                return this.platformId;
            }
            catch (Throwable throwable) {
                this.serverErrorOccured = true;
                this.log.warn("Could not register the platform even though the connection seems to be established, will try later!");
                throw new IdNotAvailableException("Could not register the platform even though the connection seems to be established, will try later!", throwable);
            }
        } else {
            if (!this.shutdownInitialized) return this.platformId;
            throw new IdNotAvailableException("Cannot retrieve platform ID because the shutdown has been initialized.");
        }
    }

    public void unregisterPlatform() {
        this.shutdownInitialized = true;
        if (this.connection.isConnected() && this.isPlatformRegistered()) {
            try {
                this.connection.unregisterPlatform(this.configurationStorage.getAgentName());
                this.platformId = -1L;
            }
            catch (Throwable e) {
                this.log.warn("Could not un-register the platform.");
            }
        }
    }

    public long getRegisteredMethodId(long methodId) throws IdNotAvailableException {
        Long methodIdentifier = methodId;
        if (!this.methodIdMap.containsKey(methodIdentifier)) {
            throw new IdNotAvailableException("Method ID '" + methodId + "' is not mapped");
        }
        Long registeredMethodIdentifier = this.methodIdMap.get(methodIdentifier);
        return registeredMethodIdentifier;
    }

    public long getRegisteredSensorTypeId(long sensorTypeId) throws IdNotAvailableException {
        Long sensorTypeIdentifier = sensorTypeId;
        if (!this.sensorTypeIdMap.containsKey(sensorTypeIdentifier)) {
            throw new IdNotAvailableException("Sensor Type ID '" + sensorTypeId + "' is not mapped");
        }
        Long registeredSensorTypeIdentifier = this.sensorTypeIdMap.get(sensorTypeIdentifier);
        return registeredSensorTypeIdentifier;
    }

    public long getRegisteredmBeanId(long mBeanId) throws IdNotAvailableException {
        Long mBeanIdentifier = mBeanId;
        if (!this.sensorTypeIdMap.containsKey(mBeanIdentifier)) {
            throw new IdNotAvailableException("mBean '" + mBeanId + "' is not mapped");
        }
        Long registeredSensorTypeIdentifier = this.jmxDefinitionDataIdMap.get(mBeanIdentifier);
        return registeredSensorTypeIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long registerMethod(RegisteredSensorConfig registeredSensorConfig) {
        long id;
        LinkedList<RegisteredSensorConfig> linkedList = this.methodsToRegister;
        synchronized (linkedList) {
            id = this.methodIdMap.size() + this.methodsToRegister.size();
        }
        registeredSensorConfig.setId(id);
        if (!this.serverErrorOccured) {
            try {
                if (!this.isPlatformRegistered()) {
                    this.getPlatformId();
                }
                this.registrationThread.registerMethod(registeredSensorConfig);
            }
            catch (Throwable throwable) {
                LinkedList<RegisteredSensorConfig> linkedList2 = this.methodsToRegister;
                synchronized (linkedList2) {
                    this.methodsToRegister.addLast(registeredSensorConfig);
                    RegistrationThread registrationThread = this.registrationThread;
                    synchronized (registrationThread) {
                        this.registrationThread.notifyAll();
                    }
                }
            }
        } else {
            linkedList = this.methodsToRegister;
            synchronized (linkedList) {
                this.methodsToRegister.addLast(registeredSensorConfig);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long registerMethodSensorType(MethodSensorTypeConfig methodSensorTypeConfig) {
        long id;
        LinkedList<AbstractSensorTypeConfig> linkedList = this.sensorTypesToRegister;
        synchronized (linkedList) {
            id = this.sensorTypeIdMap.size() + this.sensorTypesToRegister.size();
        }
        methodSensorTypeConfig.setId(id);
        if (!this.serverErrorOccured) {
            try {
                if (!this.isPlatformRegistered()) {
                    this.getPlatformId();
                }
                this.registrationThread.registerSensorType(methodSensorTypeConfig);
            }
            catch (Throwable throwable) {
                LinkedList<AbstractSensorTypeConfig> linkedList2 = this.sensorTypesToRegister;
                synchronized (linkedList2) {
                    this.sensorTypesToRegister.addLast(methodSensorTypeConfig);
                    RegistrationThread registrationThread = this.registrationThread;
                    synchronized (registrationThread) {
                        this.registrationThread.notifyAll();
                    }
                }
            }
        } else {
            linkedList = this.sensorTypesToRegister;
            synchronized (linkedList) {
                this.sensorTypesToRegister.addLast(methodSensorTypeConfig);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSensorTypeToMethod(long sensorTypeId, long methodId) {
        if (!this.serverErrorOccured) {
            try {
                if (!this.isPlatformRegistered()) {
                    this.getPlatformId();
                }
                this.registrationThread.addSensorTypeToMethod(sensorTypeId, methodId);
            }
            catch (Throwable throwable) {
                Object object = this.sensorTypeToMethodRegister;
                synchronized (object) {
                    this.sensorTypeToMethodRegister.addLast(new SensorTypeToMethodMapping(sensorTypeId, methodId));
                }
                object = this.registrationThread;
                synchronized (object) {
                    this.registrationThread.notifyAll();
                }
            }
        } else {
            LinkedList<SensorTypeToMethodMapping> linkedList = this.sensorTypeToMethodRegister;
            synchronized (linkedList) {
                this.sensorTypeToMethodRegister.addLast(new SensorTypeToMethodMapping(sensorTypeId, methodId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long registerPlatformSensorType(PlatformSensorTypeConfig platformSensorTypeConfig) {
        long id;
        LinkedList<AbstractSensorTypeConfig> linkedList = this.sensorTypesToRegister;
        synchronized (linkedList) {
            id = this.sensorTypeIdMap.size() + this.sensorTypesToRegister.size();
        }
        platformSensorTypeConfig.setId(id);
        if (!this.serverErrorOccured) {
            try {
                if (!this.isPlatformRegistered()) {
                    this.getPlatformId();
                }
                this.registrationThread.registerSensorType(platformSensorTypeConfig);
            }
            catch (Throwable throwable) {
                LinkedList<AbstractSensorTypeConfig> linkedList2 = this.sensorTypesToRegister;
                synchronized (linkedList2) {
                    this.sensorTypesToRegister.addLast(platformSensorTypeConfig);
                    RegistrationThread registrationThread = this.registrationThread;
                    synchronized (registrationThread) {
                        this.registrationThread.notifyAll();
                    }
                }
            }
        } else {
            linkedList = this.sensorTypesToRegister;
            synchronized (linkedList) {
                this.sensorTypesToRegister.addLast(platformSensorTypeConfig);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long registerJmxSensorConfig(JmxSensorConfig config) {
        long id;
        LinkedList<JmxSensorConfig> linkedList = this.jmxDefinitionDataIdentToRegister;
        synchronized (linkedList) {
            id = this.jmxDefinitionDataIdMap.size() + this.jmxDefinitionDataIdentToRegister.size();
        }
        config.setId(id);
        if (!this.serverErrorOccured) {
            try {
                if (!this.isPlatformRegistered()) {
                    this.getPlatformId();
                }
                this.registrationThread.registerJmxDefinitionData(config);
            }
            catch (Throwable throwable) {
                LinkedList<JmxSensorConfig> linkedList2 = this.jmxDefinitionDataIdentToRegister;
                synchronized (linkedList2) {
                    this.jmxDefinitionDataIdentToRegister.addLast(config);
                    RegistrationThread registrationThread = this.registrationThread;
                    synchronized (registrationThread) {
                        this.registrationThread.notifyAll();
                    }
                }
            }
        } else {
            linkedList = this.jmxDefinitionDataIdentToRegister;
            synchronized (linkedList) {
                this.jmxDefinitionDataIdentToRegister.addLast(config);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long registerJmxSensorType(JmxSensorTypeConfig jmxSensorTypeConfig) {
        long id;
        LinkedList<AbstractSensorTypeConfig> linkedList = this.sensorTypesToRegister;
        synchronized (linkedList) {
            id = this.sensorTypeIdMap.size() + this.sensorTypesToRegister.size();
        }
        jmxSensorTypeConfig.setId(id);
        if (!this.serverErrorOccured) {
            try {
                if (!this.isPlatformRegistered()) {
                    this.getPlatformId();
                }
                this.registrationThread.registerSensorType(jmxSensorTypeConfig);
            }
            catch (Throwable throwable) {
                LinkedList<AbstractSensorTypeConfig> linkedList2 = this.sensorTypesToRegister;
                synchronized (linkedList2) {
                    this.sensorTypesToRegister.addLast(jmxSensorTypeConfig);
                    RegistrationThread registrationThread = this.registrationThread;
                    synchronized (registrationThread) {
                        this.registrationThread.notifyAll();
                    }
                }
            }
        } else {
            linkedList = this.sensorTypesToRegister;
            synchronized (linkedList) {
                this.sensorTypesToRegister.addLast(jmxSensorTypeConfig);
            }
        }
        return id;
    }

    public void afterPropertiesSet() throws Exception {
        this.start();
    }

    public void destroy() throws Exception {
        this.stop();
    }

    private class RegistrationThread
    extends Thread {
        private static final long REGISTRATION_WAIT_TIME = 10000L;

        public RegistrationThread() {
            this.setName("inspectit-registration-thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread thisThread = Thread.currentThread();
            while (IdManager.this.registrationThread == thisThread) {
                try {
                    RegistrationThread registrationThread = this;
                    synchronized (registrationThread) {
                        if (IdManager.this.serverErrorOccured) {
                            this.wait(10000L);
                        } else if (IdManager.this.methodsToRegister.isEmpty() && IdManager.this.sensorTypesToRegister.isEmpty() && IdManager.this.sensorTypeToMethodRegister.isEmpty()) {
                            this.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.doRegistration();
            }
        }

        private void doRegistration() {
            try {
                if (!IdManager.this.connection.isConnected()) {
                    this.connect();
                }
                if (!IdManager.this.isPlatformRegistered()) {
                    this.registerPlatform();
                }
                this.registerMethods();
                this.registerJmxDefinitionDataIdents();
                this.registerSensorTypes();
                this.registerSensorTypeToMethodMapping();
                IdManager.this.serverErrorOccured = false;
            }
            catch (ServerUnavailableException serverUnavailableException) {
                if (serverUnavailableException.isServerTimeout()) {
                    IdManager.this.log.error("Server timeout while trying to register something at the server.");
                } else {
                    if (!IdManager.this.serverErrorOccured) {
                        IdManager.this.log.error("Server unavailable while trying to register something at the server.");
                    }
                    IdManager.this.serverErrorOccured = true;
                }
            }
            catch (RegistrationException registrationException) {
                IdManager.this.log.error("Registration exception occurred while trying to register something at the server.", (Throwable)registrationException);
            }
            catch (ConnectException connectException) {
                if (!IdManager.this.serverErrorOccured) {
                    IdManager.this.log.error("Connection to the server failed.", (Throwable)connectException);
                }
                IdManager.this.serverErrorOccured = true;
            }
        }

        private void connect() throws ConnectException {
            RepositoryConfig repositoryConfig = IdManager.this.configurationStorage.getRepositoryConfig();
            IdManager.this.connection.connect(repositoryConfig.getHost(), repositoryConfig.getPort());
        }

        private void registerPlatform() throws ServerUnavailableException, RegistrationException {
            IdManager.this.platformId = IdManager.this.connection.registerPlatform(IdManager.this.configurationStorage.getAgentName(), IdManager.this.versionService.getVersionAsString());
            if (IdManager.this.log.isDebugEnabled()) {
                IdManager.this.log.debug("Received platform ID: " + IdManager.this.platformId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerSensorTypeToMethodMapping() throws ServerUnavailableException, RegistrationException {
            while (!IdManager.this.sensorTypeToMethodRegister.isEmpty()) {
                SensorTypeToMethodMapping mapping = (SensorTypeToMethodMapping)IdManager.this.sensorTypeToMethodRegister.getFirst();
                Long sensorTypeId = mapping.getSensorTypeId();
                Long methodId = mapping.getMethodId();
                this.addSensorTypeToMethod(sensorTypeId, methodId);
                LinkedList linkedList = IdManager.this.sensorTypeToMethodRegister;
                synchronized (linkedList) {
                    IdManager.this.sensorTypeToMethodRegister.removeFirst();
                }
            }
        }

        private void addSensorTypeToMethod(Long sensorTypeId, Long methodId) throws ServerUnavailableException, RegistrationException {
            if (!IdManager.this.sensorTypeIdMap.containsKey(sensorTypeId)) {
                throw new RegistrationException("Sensor type ID could not be found in the map!");
            }
            if (!IdManager.this.methodIdMap.containsKey(methodId)) {
                throw new RegistrationException("Method ID could not be found in the map!");
            }
            Long serverSensorTypeId = (Long)IdManager.this.sensorTypeIdMap.get(sensorTypeId);
            Long serverMethodId = (Long)IdManager.this.methodIdMap.get(methodId);
            IdManager.this.connection.addSensorTypeToMethod(serverSensorTypeId, serverMethodId);
            if (IdManager.this.log.isDebugEnabled()) {
                IdManager.this.log.debug("Mapping registered (method -> sensor type) :: local:" + methodId + "->" + sensorTypeId + " global:" + serverMethodId + "->" + serverSensorTypeId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerSensorTypes() throws ServerUnavailableException, RegistrationException {
            while (!IdManager.this.sensorTypesToRegister.isEmpty()) {
                AbstractSensorTypeConfig astc = (AbstractSensorTypeConfig)IdManager.this.sensorTypesToRegister.getFirst();
                this.registerSensorType(astc);
                LinkedList linkedList = IdManager.this.sensorTypesToRegister;
                synchronized (linkedList) {
                    IdManager.this.sensorTypesToRegister.removeFirst();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerSensorType(AbstractSensorTypeConfig astc) throws ServerUnavailableException, RegistrationException {
            long registeredId;
            if (astc instanceof MethodSensorTypeConfig) {
                registeredId = IdManager.this.connection.registerMethodSensorType(IdManager.this.platformId, (MethodSensorTypeConfig)astc);
            } else if (astc instanceof JmxSensorTypeConfig) {
                registeredId = IdManager.this.connection.registerJmxSensorType(IdManager.this.platformId, (JmxSensorTypeConfig)astc);
            } else if (astc instanceof PlatformSensorTypeConfig) {
                registeredId = IdManager.this.connection.registerPlatformSensorType(IdManager.this.platformId, (PlatformSensorTypeConfig)astc);
            } else {
                throw new RegistrationException("Could not register sensor type, because unhandled type: " + astc.getClass().getName());
            }
            LinkedList linkedList = IdManager.this.sensorTypesToRegister;
            synchronized (linkedList) {
                Long localId = IdManager.this.sensorTypeIdMap.size();
                IdManager.this.sensorTypeIdMap.put(localId, registeredId);
                if (IdManager.this.log.isDebugEnabled()) {
                    IdManager.this.log.debug("Sensor type " + astc.toString() + " registered. ID (local/global): " + localId + "/" + registeredId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerMethods() throws ServerUnavailableException, RegistrationException {
            while (!IdManager.this.methodsToRegister.isEmpty()) {
                RegisteredSensorConfig rsc = (RegisteredSensorConfig)IdManager.this.methodsToRegister.getFirst();
                this.registerMethod(rsc);
                LinkedList linkedList = IdManager.this.methodsToRegister;
                synchronized (linkedList) {
                    IdManager.this.methodsToRegister.removeFirst();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerMethod(RegisteredSensorConfig rsc) throws ServerUnavailableException, RegistrationException {
            long registeredId = IdManager.this.connection.registerMethod(IdManager.this.platformId, rsc);
            LinkedList linkedList = IdManager.this.methodsToRegister;
            synchronized (linkedList) {
                Long localId = IdManager.this.methodIdMap.size();
                IdManager.this.methodIdMap.put(localId, registeredId);
                if (IdManager.this.log.isDebugEnabled()) {
                    IdManager.this.log.debug("Method " + rsc.toString() + " registered. ID (local/global): " + localId + "/" + registeredId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerJmxDefinitionDataIdents() throws ServerUnavailableException, RegistrationException {
            while (!IdManager.this.jmxDefinitionDataIdentToRegister.isEmpty()) {
                JmxSensorConfig jsc = (JmxSensorConfig)IdManager.this.jmxDefinitionDataIdentToRegister.getFirst();
                this.registerJmxDefinitionData(jsc);
                LinkedList linkedList = IdManager.this.jmxDefinitionDataIdentToRegister;
                synchronized (linkedList) {
                    IdManager.this.jmxDefinitionDataIdentToRegister.removeFirst();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerJmxDefinitionData(JmxSensorConfig config) throws ServerUnavailableException, RegistrationException {
            long registeredId = IdManager.this.connection.registerJmxDefinitionData(IdManager.this.platformId, config);
            LinkedList linkedList = IdManager.this.jmxDefinitionDataIdentToRegister;
            synchronized (linkedList) {
                Long localId = IdManager.this.jmxDefinitionDataIdMap.size();
                IdManager.this.jmxDefinitionDataIdMap.put(localId, registeredId);
                if (IdManager.this.log.isDebugEnabled()) {
                    IdManager.this.log.debug("Method " + config.toString() + " registered. ID (local/global): " + localId + "/" + registeredId);
                }
            }
        }
    }

    private static class SensorTypeToMethodMapping {
        private long sensorTypeId;
        private long methodId;

        public SensorTypeToMethodMapping(long sensorTypeId, long methodId) {
            this.sensorTypeId = sensorTypeId;
            this.methodId = methodId;
        }

        public long getSensorTypeId() {
            return this.sensorTypeId;
        }

        public long getMethodId() {
            return this.methodId;
        }
    }
}

