/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.core.impl;

import info.novatec.inspectit.agent.buffer.IBufferStrategy;
import info.novatec.inspectit.agent.config.IConfigurationStorage;
import info.novatec.inspectit.agent.config.impl.JmxSensorTypeConfig;
import info.novatec.inspectit.agent.config.impl.PlatformSensorTypeConfig;
import info.novatec.inspectit.agent.connection.IConnection;
import info.novatec.inspectit.agent.connection.ServerUnavailableException;
import info.novatec.inspectit.agent.core.ICoreService;
import info.novatec.inspectit.agent.core.IIdManager;
import info.novatec.inspectit.agent.core.IObjectStorage;
import info.novatec.inspectit.agent.core.ListListener;
import info.novatec.inspectit.agent.sending.ISendingStrategy;
import info.novatec.inspectit.agent.sensor.jmx.IJmxSensor;
import info.novatec.inspectit.agent.sensor.platform.IPlatformSensor;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.ExceptionEvent;
import info.novatec.inspectit.communication.MethodSensorData;
import info.novatec.inspectit.communication.SystemSensorData;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.communication.data.JmxSensorValueData;
import info.novatec.inspectit.spring.logger.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@DependsOn(value={"strategyAndSensorConfiguration"})
public class CoreService
implements ICoreService,
InitializingBean,
DisposableBean {
    @Log
    Logger log;
    private final IConfigurationStorage configurationStorage;
    private final IConnection connection;
    private final IIdManager idManager;
    private Map<String, DefaultData> sensorDataObjects = new ConcurrentHashMap<String, DefaultData>();
    private Map<String, IObjectStorage> objectStorages = new ConcurrentHashMap<String, IObjectStorage>();
    private Map<String, DefaultData> measurementsProcessing = new ConcurrentHashMap<String, DefaultData>();
    private Map<String, IObjectStorage> objectStoragesProcessing = new ConcurrentHashMap<String, IObjectStorage>();
    private Map<String, ?> temp;
    private List<ListListener<?>> listListeners = new ArrayList();
    private List<ISendingStrategy> sendingStrategies = new ArrayList<ISendingStrategy>();
    private IBufferStrategy<DefaultData> bufferStrategy;
    private static final long DEFAULT_REFRESH_TIME = 1000L;
    private long sensorRefreshTime = 1000L;
    private volatile SensorRefresher sensorRefresher;
    private volatile PreparingThread preparingThread;
    private volatile SendingThread sendingThread;
    private boolean sendingExceptionNotice = false;
    @Autowired
    @Qualifier(value="coreServiceExecutorService")
    private ScheduledExecutorService scheduledExecutorService;

    @Autowired
    public CoreService(IConfigurationStorage configurationStorage, IConnection connection, IBufferStrategy<DefaultData> bufferStrategy, List<ISendingStrategy> sendingStrategies, IIdManager idManager) {
        if (null == configurationStorage) {
            throw new IllegalArgumentException("Configuration Storage cannot be null!");
        }
        if (null == connection) {
            throw new IllegalArgumentException("Connection cannot be null!");
        }
        if (null == bufferStrategy) {
            throw new IllegalArgumentException("Buffer strategy cannot be null!");
        }
        if (null == sendingStrategies || sendingStrategies.isEmpty()) {
            throw new IllegalArgumentException("At least one sending strategy has to be defined!");
        }
        if (null == idManager) {
            throw new IllegalArgumentException("IdManager cannot be null!");
        }
        this.configurationStorage = configurationStorage;
        this.connection = connection;
        this.bufferStrategy = bufferStrategy;
        this.sendingStrategies = sendingStrategies;
        this.idManager = idManager;
    }

    @Override
    public void start() {
        for (ISendingStrategy strategy : this.sendingStrategies) {
            strategy.start(this);
        }
        this.preparingThread = new PreparingThread();
        this.preparingThread.start();
        this.sendingThread = new SendingThread();
        this.sendingThread.start();
        this.sensorRefresher = new SensorRefresher();
        this.sensorRefresher.start();
        Runtime.getRuntime().addShutdownHook(new ShutdownHookSender());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        for (ISendingStrategy strategy : this.sendingStrategies) {
            strategy.stop();
        }
        Object i$ = this.preparingThread;
        synchronized (i$) {
            this.preparingThread.interrupt();
        }
        i$ = this.sendingThread;
        synchronized (i$) {
            this.sendingThread.interrupt();
        }
        SensorRefresher temp = this.sensorRefresher;
        this.sensorRefresher = null;
        SensorRefresher sensorRefresher = temp;
        synchronized (sensorRefresher) {
            temp.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendData() {
        PreparingThread preparingThread = this.preparingThread;
        synchronized (preparingThread) {
            this.preparingThread.notifyAll();
        }
    }

    @Override
    public void addJmxSensorValueData(long sensorTypeIdent, String objectName, String attributeName, JmxSensorValueData jmxSensorValueData) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(sensorTypeIdent);
        buffer.append('.');
        buffer.append(objectName);
        buffer.append('.');
        buffer.append(attributeName);
        buffer.append('.');
        buffer.append(jmxSensorValueData.getTimeStamp().getTime());
        this.sensorDataObjects.put(buffer.toString(), (DefaultData)jmxSensorValueData);
        this.notifyListListeners();
    }

    @Override
    public void addMethodSensorData(long sensorTypeIdent, long methodIdent, String prefix, MethodSensorData methodSensorData) {
        StringBuffer buffer = new StringBuffer();
        if (null != prefix) {
            buffer.append(prefix);
            buffer.append('.');
        }
        buffer.append(methodIdent);
        buffer.append('.');
        buffer.append(sensorTypeIdent);
        this.sensorDataObjects.put(buffer.toString(), (DefaultData)methodSensorData);
        this.notifyListListeners();
    }

    @Override
    public MethodSensorData getMethodSensorData(long sensorTypeIdent, long methodIdent, String prefix) {
        StringBuffer buffer = new StringBuffer();
        if (null != prefix) {
            buffer.append(prefix);
            buffer.append('.');
        }
        buffer.append(methodIdent);
        buffer.append('.');
        buffer.append(sensorTypeIdent);
        return (MethodSensorData)this.sensorDataObjects.get(buffer.toString());
    }

    @Override
    public void addPlatformSensorData(long sensorTypeIdent, SystemSensorData systemSensorData) {
        this.sensorDataObjects.put(Long.toString(sensorTypeIdent), (DefaultData)systemSensorData);
        this.notifyListListeners();
    }

    @Override
    public SystemSensorData getPlatformSensorData(long sensorTypeIdent) {
        return (SystemSensorData)this.sensorDataObjects.get(Long.toString(sensorTypeIdent));
    }

    @Override
    public void addExceptionSensorData(long sensorTypeIdent, long throwableIdentityHashCode, ExceptionSensorData exceptionSensorData) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(sensorTypeIdent);
        buffer.append("::");
        buffer.append(throwableIdentityHashCode);
        String key = buffer.toString();
        if (exceptionSensorData.getExceptionEvent().equals((Object)ExceptionEvent.CREATED)) {
            this.sensorDataObjects.put(key, (DefaultData)exceptionSensorData);
            this.notifyListListeners();
        }
    }

    @Override
    public ExceptionSensorData getExceptionSensorData(long sensorTypeIdent, long throwableIdentityHashCode) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(sensorTypeIdent);
        buffer.append("::");
        buffer.append(throwableIdentityHashCode);
        return (ExceptionSensorData)this.sensorDataObjects.get(buffer.toString());
    }

    @Override
    public void addObjectStorage(long sensorTypeIdent, long methodIdent, String prefix, IObjectStorage objectStorage) {
        StringBuffer buffer = new StringBuffer();
        if (null != prefix) {
            buffer.append(prefix);
            buffer.append('.');
        }
        buffer.append(methodIdent);
        buffer.append('.');
        buffer.append(sensorTypeIdent);
        this.objectStorages.put(buffer.toString(), objectStorage);
        this.notifyListListeners();
    }

    @Override
    public IObjectStorage getObjectStorage(long sensorTypeIdent, long methodIdent, String prefix) {
        StringBuffer buffer = new StringBuffer();
        if (null != prefix) {
            buffer.append(prefix);
            buffer.append('.');
        }
        buffer.append(methodIdent);
        buffer.append('.');
        buffer.append(sensorTypeIdent);
        return this.objectStorages.get(buffer.toString());
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    @Override
    public void addListListener(ListListener<?> listener) {
        if (!this.listListeners.contains(listener)) {
            this.listListeners.add(listener);
        }
    }

    @Override
    public void removeListListener(ListListener<?> listener) {
        this.listListeners.remove(listener);
    }

    private void notifyListListeners() {
        if (!this.listListeners.isEmpty()) {
            ArrayList<DefaultData> temp = new ArrayList<DefaultData>(this.sensorDataObjects.values());
            temp.addAll(this.objectStorages.values());
            for (ListListener<?> listListener : this.listListeners) {
                listListener.contentChanged(temp);
            }
        }
    }

    public long getSensorRefreshTime() {
        return this.sensorRefreshTime;
    }

    public void setSensorRefreshTime(long sensorRefreshTime) {
        this.sensorRefreshTime = sensorRefreshTime;
    }

    private boolean prepareData() {
        if (this.sensorDataObjects.isEmpty() && this.objectStorages.isEmpty()) {
            return false;
        }
        this.temp = this.sensorDataObjects;
        this.sensorDataObjects = this.measurementsProcessing;
        this.measurementsProcessing = this.temp;
        this.temp = this.objectStorages;
        this.objectStorages = this.objectStoragesProcessing;
        this.objectStoragesProcessing = this.temp;
        ArrayList<DefaultData> tempList = new ArrayList<DefaultData>(this.measurementsProcessing.values());
        this.measurementsProcessing.clear();
        for (IObjectStorage objectStorage : this.objectStoragesProcessing.values()) {
            tempList.add(objectStorage.finalizeDataObject());
        }
        this.objectStoragesProcessing.clear();
        this.bufferStrategy.addMeasurements(tempList);
        return true;
    }

    private void send() {
        block8: {
            try {
                while (this.bufferStrategy.hasNext()) {
                    if (!this.connection.isConnected()) {
                        return;
                    }
                    List dataToSend = (List)this.bufferStrategy.next();
                    this.connection.sendDataObjects(dataToSend);
                    this.sendingExceptionNotice = false;
                }
            }
            catch (ServerUnavailableException serverUnavailableException) {
                if (serverUnavailableException.isServerTimeout()) {
                    this.log.warn("Timeout on server when sending actual data. Data might be lost!", (Throwable)serverUnavailableException);
                } else if (!this.sendingExceptionNotice) {
                    this.sendingExceptionNotice = true;
                    this.log.error("Connection problem appeared, stopping sending actual data!", (Throwable)serverUnavailableException);
                }
            }
            catch (Throwable throwable) {
                if (this.sendingExceptionNotice) break block8;
                this.sendingExceptionNotice = true;
                this.log.error("Connection problem appeared, stopping sending actual data!", throwable);
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.start();
    }

    public void destroy() throws Exception {
        this.stop();
    }

    private class ShutdownHookSender
    extends Thread {
        private ShutdownHookSender() {
        }

        public void run() {
            CoreService.this.log.info("Shutdown initialized, sending remaining data");
            CoreService.this.stop();
            try {
                CoreService.this.preparingThread.join(10000L);
            }
            catch (InterruptedException e) {
                CoreService.this.log.error("ShutdownHook was interrupted while waiting for the preparing thread to shut down. Stopping the shutdown hook");
                return;
            }
            try {
                CoreService.this.sendingThread.join(10000L);
            }
            catch (InterruptedException e) {
                CoreService.this.log.error("ShutdownHook was interrupted while waiting for the sending thread to shut down. Stopping the shutdown hook");
                return;
            }
            CoreService.this.prepareData();
            CoreService.this.send();
            CoreService.this.log.info("Unregistering the Agent");
            CoreService.this.idManager.unregisterPlatform();
        }
    }

    private class SendingThread
    extends Thread {
        public SendingThread() {
            this.setName("inspectit-sending-thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.isInterrupted()) {
                if (!CoreService.this.bufferStrategy.hasNext()) {
                    SendingThread sendingThread = this;
                    synchronized (sendingThread) {
                        block7: {
                            try {
                                if (this.isInterrupted()) break block7;
                                this.wait();
                            }
                            catch (InterruptedException e) {
                                CoreService.this.log.error("Sending thread interrupted and shuting down!");
                                break;
                            }
                        }
                    }
                }
                CoreService.this.send();
            }
        }
    }

    private class PreparingThread
    extends Thread {
        public PreparingThread() {
            this.setName("inspectit-preparing-thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.isInterrupted()) {
                PreparingThread preparingThread = this;
                synchronized (preparingThread) {
                    block9: {
                        try {
                            if (this.isInterrupted()) break block9;
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            CoreService.this.log.error("Preparing thread interrupted and shutting down!");
                            break;
                        }
                    }
                }
                boolean newDataAvailable = CoreService.this.prepareData();
                if (!newDataAvailable) continue;
                SendingThread sendingThread = CoreService.this.sendingThread;
                synchronized (sendingThread) {
                    CoreService.this.sendingThread.notifyAll();
                }
            }
        }
    }

    private class SensorRefresher
    extends Thread {
        public SensorRefresher() {
            this.setName("inspectit-platform-sensor-refresher-thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread thisThread = Thread.currentThread();
            while (CoreService.this.sensorRefresher == thisThread) {
                try {
                    SensorRefresher sensorRefresher = this;
                    synchronized (sensorRefresher) {
                        this.wait(CoreService.this.sensorRefreshTime);
                    }
                }
                catch (InterruptedException e) {
                    CoreService.this.log.error("Sensor refresher was interrupted!");
                }
                for (PlatformSensorTypeConfig platformSensorTypeConfig : CoreService.this.configurationStorage.getPlatformSensorTypes()) {
                    IPlatformSensor platformSensor = (IPlatformSensor)platformSensorTypeConfig.getSensorType();
                    if (!platformSensor.automaticUpdate()) continue;
                    platformSensor.update(CoreService.this, platformSensorTypeConfig.getId());
                }
                for (JmxSensorTypeConfig jmxSensorTypeConfig : CoreService.this.configurationStorage.getJmxSensorTypes()) {
                    IJmxSensor jmxSensor = (IJmxSensor)jmxSensorTypeConfig.getSensorType();
                    jmxSensor.update(CoreService.this, jmxSensorTypeConfig.getId());
                }
            }
        }
    }
}

