/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.connection.impl;

import com.esotericsoftware.kryonet.rmi.RemoteObject;
import info.novatec.inspectit.agent.config.impl.JmxSensorConfig;
import info.novatec.inspectit.agent.config.impl.JmxSensorTypeConfig;
import info.novatec.inspectit.agent.config.impl.MethodSensorTypeConfig;
import info.novatec.inspectit.agent.config.impl.PlatformSensorTypeConfig;
import info.novatec.inspectit.agent.config.impl.RegisteredSensorConfig;
import info.novatec.inspectit.agent.connection.FailFastRemoteMethodCall;
import info.novatec.inspectit.agent.connection.IConnection;
import info.novatec.inspectit.agent.connection.RegistrationException;
import info.novatec.inspectit.agent.connection.ServerUnavailableException;
import info.novatec.inspectit.agent.connection.impl.AddDataObjects;
import info.novatec.inspectit.agent.connection.impl.AddSensorTypeToMethod;
import info.novatec.inspectit.agent.connection.impl.RegisterJmxDefinitionDataIdent;
import info.novatec.inspectit.agent.connection.impl.RegisterJmxSensorType;
import info.novatec.inspectit.agent.connection.impl.RegisterMethodIdent;
import info.novatec.inspectit.agent.connection.impl.RegisterMethodSensorType;
import info.novatec.inspectit.agent.connection.impl.RegisterPlatformSensorType;
import info.novatec.inspectit.agent.spring.PrototypesProvider;
import info.novatec.inspectit.cmr.service.IAgentStorageService;
import info.novatec.inspectit.cmr.service.IKeepAliveService;
import info.novatec.inspectit.cmr.service.IRegistrationService;
import info.novatec.inspectit.cmr.service.ServiceInterface;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.kryonet.Client;
import info.novatec.inspectit.kryonet.Connection;
import info.novatec.inspectit.kryonet.ExtendedSerializationImpl;
import info.novatec.inspectit.kryonet.IExtendedSerialization;
import info.novatec.inspectit.kryonet.rmi.ObjectSpace;
import info.novatec.inspectit.spring.logger.Log;
import info.novatec.inspectit.storage.nio.stream.StreamProvider;
import info.novatec.inspectit.storage.serializer.ISerializerProvider;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class KryoNetConnection
implements IConnection {
    @Log
    Logger log;
    @Autowired
    private PrototypesProvider prototypesProvider;
    private Client client;
    private IAgentStorageService agentStorageService;
    private IRegistrationService registrationService;
    private IKeepAliveService keepAliveService;
    private boolean connectionException = false;
    private List<String> networkInterfaces;

    @Override
    public void connect(String host, int port) throws ConnectException {
        if (null == this.client) {
            try {
                if (!this.connectionException) {
                    this.log.info("KryoNet: Connecting to " + host + ":" + port);
                }
                this.initClient(host, port);
                int agentStorageServiceId = IAgentStorageService.class.getAnnotation(ServiceInterface.class).serviceId();
                this.agentStorageService = (IAgentStorageService)ObjectSpace.getRemoteObject((Connection)this.client, (int)agentStorageServiceId, IAgentStorageService.class);
                ((RemoteObject)this.agentStorageService).setNonBlocking(true);
                ((RemoteObject)this.agentStorageService).setTransmitReturnValue(false);
                int registrationServiceServiceId = IRegistrationService.class.getAnnotation(ServiceInterface.class).serviceId();
                this.registrationService = (IRegistrationService)ObjectSpace.getRemoteObject((Connection)this.client, (int)registrationServiceServiceId, IRegistrationService.class);
                ((RemoteObject)this.registrationService).setNonBlocking(false);
                ((RemoteObject)this.registrationService).setTransmitReturnValue(true);
                int keepAliveServiceId = IKeepAliveService.class.getAnnotation(ServiceInterface.class).serviceId();
                this.keepAliveService = (IKeepAliveService)ObjectSpace.getRemoteObject((Connection)this.client, (int)keepAliveServiceId, IKeepAliveService.class);
                ((RemoteObject)this.keepAliveService).setNonBlocking(true);
                ((RemoteObject)this.registrationService).setTransmitReturnValue(false);
                this.log.info("KryoNet: Connection established!");
                this.connectionException = false;
            }
            catch (Exception exception) {
                if (!this.connectionException) {
                    this.log.info("KryoNet: Connection to the server failed.");
                }
                this.connectionException = true;
                this.disconnect();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("connect()", (Throwable)exception);
                }
                ConnectException e = new ConnectException(exception.getMessage());
                e.initCause(exception);
                throw e;
            }
        }
    }

    private void initClient(String host, int port) throws Exception {
        ExtendedSerializationImpl serialization = new ExtendedSerializationImpl((ISerializerProvider)this.prototypesProvider);
        this.client = new Client((IExtendedSerialization)serialization, (StreamProvider)this.prototypesProvider);
        this.client.start();
        this.client.connect(5000, host, port);
    }

    @Override
    public void disconnect() {
        if (null != this.client) {
            this.client.stop();
            this.client = null;
        }
        this.agentStorageService = null;
        this.registrationService = null;
        this.keepAliveService = null;
    }

    @Override
    public void sendKeepAlive(final long platformId) throws ServerUnavailableException {
        if (!this.isConnected()) {
            throw new ServerUnavailableException();
        }
        FailFastRemoteMethodCall<IKeepAliveService, Void> call = new FailFastRemoteMethodCall<IKeepAliveService, Void>(this.keepAliveService){

            @Override
            protected Void performRemoteCall(IKeepAliveService service) {
                service.sendKeepAlive(platformId);
                return null;
            }
        };
        try {
            call.makeCall();
        }
        catch (ExecutionException e) {
            this.log.error("Exception thrown while trying to send keep-alive signal to the server.", (Throwable)e);
        }
    }

    @Override
    public long registerPlatform(final String agentName, final String version) throws ServerUnavailableException, RegistrationException {
        if (!this.isConnected()) {
            throw new ServerUnavailableException();
        }
        try {
            if (null == this.networkInterfaces) {
                this.networkInterfaces = this.getNetworkInterfaces();
            }
        }
        catch (SocketException socketException) {
            this.log.error("Could not obtain network interfaces from this machine!");
            if (this.log.isTraceEnabled()) {
                this.log.trace("unregisterPlatform(List,String)", (Throwable)socketException);
            }
            throw new RegistrationException("Could not un-register the platform", socketException);
        }
        FailFastRemoteMethodCall<IRegistrationService, Long> call = new FailFastRemoteMethodCall<IRegistrationService, Long>(this.registrationService){

            @Override
            protected Long performRemoteCall(IRegistrationService service) throws Exception {
                return service.registerPlatformIdent(KryoNetConnection.this.networkInterfaces, agentName, version);
            }
        };
        try {
            return (Long)call.makeCall();
        }
        catch (ExecutionException executionException) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("registerPlatform(String)", (Throwable)executionException);
            }
            throw new RegistrationException("Could not register the platform", executionException);
        }
    }

    @Override
    public void unregisterPlatform(final String agentName) throws ServerUnavailableException, RegistrationException {
        if (!this.isConnected()) {
            throw new ServerUnavailableException();
        }
        try {
            if (null == this.networkInterfaces) {
                this.networkInterfaces = this.getNetworkInterfaces();
            }
        }
        catch (SocketException socketException) {
            this.log.error("Could not obtain network interfaces from this machine!");
            if (this.log.isTraceEnabled()) {
                this.log.trace("unregisterPlatform(List,String)", (Throwable)socketException);
            }
            throw new RegistrationException("Could not un-register the platform", socketException);
        }
        FailFastRemoteMethodCall<IRegistrationService, Void> call = new FailFastRemoteMethodCall<IRegistrationService, Void>(this.registrationService){

            @Override
            protected Void performRemoteCall(IRegistrationService service) throws Exception {
                service.unregisterPlatformIdent(KryoNetConnection.this.networkInterfaces, agentName);
                return null;
            }
        };
        try {
            call.makeCall();
        }
        catch (ExecutionException executionException) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("unregisterPlatform(List,String)", (Throwable)executionException);
            }
            throw new RegistrationException("Could not un-register the platform", executionException);
        }
    }

    @Override
    public void sendDataObjects(List<? extends DefaultData> measurements) throws ServerUnavailableException {
        if (!this.isConnected()) {
            throw new ServerUnavailableException();
        }
        if (null != measurements && !measurements.isEmpty()) {
            try {
                AddDataObjects remote = new AddDataObjects(this.agentStorageService, measurements);
                remote.makeCall();
            }
            catch (ExecutionException executionException) {
                this.log.error("Could not send data objects", (Throwable)executionException);
            }
        }
    }

    @Override
    public long registerMethod(long platformId, RegisteredSensorConfig sensorConfig) throws ServerUnavailableException, RegistrationException {
        if (!this.isConnected()) {
            throw new ServerUnavailableException();
        }
        RegisterMethodIdent register = new RegisterMethodIdent(this.registrationService, sensorConfig, platformId);
        try {
            Long id = (Long)register.makeCall();
            return id;
        }
        catch (ExecutionException executionException) {
            this.log.error("Could not register the method", (Throwable)executionException);
            throw new RegistrationException("Could not register the method", executionException);
        }
    }

    @Override
    public long registerMethodSensorType(long platformId, MethodSensorTypeConfig methodSensorTypeConfig) throws ServerUnavailableException, RegistrationException {
        if (!this.isConnected()) {
            throw new ServerUnavailableException();
        }
        RegisterMethodSensorType register = new RegisterMethodSensorType(this.registrationService, methodSensorTypeConfig, platformId);
        try {
            Long id = (Long)register.makeCall();
            return id;
        }
        catch (ExecutionException executionException) {
            this.log.error("Could not register the method sensor type", (Throwable)executionException);
            throw new RegistrationException("Could not register the method sensor type", executionException);
        }
    }

    @Override
    public long registerPlatformSensorType(long platformId, PlatformSensorTypeConfig platformSensorTypeConfig) throws ServerUnavailableException, RegistrationException {
        if (!this.isConnected()) {
            throw new ServerUnavailableException();
        }
        RegisterPlatformSensorType register = new RegisterPlatformSensorType(this.registrationService, platformSensorTypeConfig, platformId);
        try {
            Long id = (Long)register.makeCall();
            return id;
        }
        catch (ExecutionException executionException) {
            this.log.error("Could not register the platform sensor type", (Throwable)executionException);
            throw new RegistrationException("Could not register the platform sensor type", executionException);
        }
    }

    @Override
    public long registerJmxSensorType(long platformId, JmxSensorTypeConfig jmxSensorTypeConfig) throws ServerUnavailableException, RegistrationException {
        if (!this.isConnected()) {
            throw new ServerUnavailableException();
        }
        RegisterJmxSensorType register = new RegisterJmxSensorType(this.registrationService, jmxSensorTypeConfig, platformId);
        try {
            Long id = (Long)register.makeCall();
            return id;
        }
        catch (ExecutionException executionException) {
            this.log.error("Could not register the jmx sensor type", (Throwable)executionException);
            throw new RegistrationException("Could not register the method sensor type", executionException);
        }
    }

    @Override
    public long registerJmxDefinitionData(long platformId, JmxSensorConfig config) throws ServerUnavailableException, RegistrationException {
        if (!this.isConnected()) {
            throw new ServerUnavailableException();
        }
        if (config.getmBeanObjectName() != null) {
            RegisterJmxDefinitionDataIdent register = new RegisterJmxDefinitionDataIdent(this.registrationService, config, platformId);
            try {
                Long id = (Long)register.makeCall();
                return id;
            }
            catch (ExecutionException executionException) {
                this.log.error("Could not register the jmx sensor type", (Throwable)executionException);
                throw new RegistrationException("Could not register the jmx definition data", executionException);
            }
        }
        throw new RegistrationException("Could not register the jmx definition data - empty set of data");
    }

    @Override
    public void addSensorTypeToMethod(long sensorTypeId, long methodId) throws ServerUnavailableException, RegistrationException {
        if (!this.isConnected()) {
            throw new ServerUnavailableException();
        }
        AddSensorTypeToMethod addTypeToSensor = new AddSensorTypeToMethod(this.registrationService, sensorTypeId, methodId);
        try {
            addTypeToSensor.makeCall();
        }
        catch (ExecutionException executionException) {
            this.log.error("Could not add the sensor type to a method", (Throwable)executionException);
            throw new RegistrationException("Could not add the sensor type to a method", executionException);
        }
    }

    private List<String> getNetworkInterfaces() throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        ArrayList<String> networkInterfaces = new ArrayList<String>();
        while (interfaces.hasMoreElements()) {
            NetworkInterface networkInterface = interfaces.nextElement();
            Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                networkInterfaces.add(address.getHostAddress());
            }
        }
        return networkInterfaces;
    }

    @Override
    public boolean isConnected() {
        return null != this.client && this.client.isConnected();
    }
}

