/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.connection.impl;

import info.novatec.inspectit.agent.connection.IConnection;
import info.novatec.inspectit.agent.connection.ServerUnavailableException;
import info.novatec.inspectit.agent.core.ICoreService;
import info.novatec.inspectit.agent.core.IIdManager;
import info.novatec.inspectit.agent.core.IdNotAvailableException;
import info.novatec.inspectit.spring.logger.Log;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KeepAliveManager
implements InitializingBean,
DisposableBean {
    private final Runnable keepAliveRunner = new Runnable(){

        public void run() {
            block6: {
                try {
                    if (KeepAliveManager.this.connection.isConnected()) {
                        KeepAliveManager.this.connection.sendKeepAlive(KeepAliveManager.this.idManager.getPlatformId());
                    }
                }
                catch (IdNotAvailableException e) {
                    if (KeepAliveManager.this.log.isDebugEnabled()) {
                        KeepAliveManager.this.log.debug("Keep-alive signal could not be sent. No platform id available.", (Throwable)e);
                    }
                }
                catch (ServerUnavailableException e) {
                    if (!KeepAliveManager.this.log.isDebugEnabled()) break block6;
                    if (e.isServerTimeout()) {
                        KeepAliveManager.this.log.debug("Keep-alive signal could not be sent. Server timeout.", (Throwable)e);
                    }
                    KeepAliveManager.this.log.debug("Keep-alive signal could not be sent. Server not available.", (Throwable)e);
                }
            }
        }
    };
    @Log
    Logger log;
    @Autowired
    private IConnection connection;
    @Autowired
    private IIdManager idManager;
    private ScheduledFuture<?> scheduledTask;
    @Autowired
    private ICoreService coreService;

    public void afterPropertiesSet() throws Exception {
        if (this.scheduledTask == null) {
            this.scheduledTask = this.coreService.getScheduledExecutorService().scheduleAtFixedRate(this.keepAliveRunner, 2500L, 2500L, TimeUnit.MILLISECONDS);
        }
    }

    public void destroy() throws Exception {
        this.scheduledTask.cancel(false);
    }
}

