/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.agent.connection;

import info.novatec.inspectit.agent.connection.RetryException;

public abstract class RetryStrategy {
    public static final int DEFAULT_NUMBER_OF_RETRIES = 3;
    private int numberOfTriesLeft;

    public RetryStrategy() {
        this(3);
    }

    public RetryStrategy(int numberOfRetries) {
        this.numberOfTriesLeft = numberOfRetries;
    }

    public final boolean shouldRetry() {
        return 0 < this.numberOfTriesLeft;
    }

    public final void remoteExceptionOccured() throws RetryException {
        --this.numberOfTriesLeft;
        if (!this.shouldRetry()) {
            throw new RetryException();
        }
        this.waitUntilNextTry();
    }

    protected abstract long getTimeToWait();

    private void waitUntilNextTry() {
        long timeToWait = this.getTimeToWait();
        try {
            Thread.sleep(timeToWait);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

